/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractResultSetRow
implements ResultSetRow {
    private ResultSet resultSet;
    private int index;
    private Map<Path, Serializable> properties;

    public AbstractResultSetRow(ResultSet resultSet, int index) {
        this.resultSet = resultSet;
        this.index = index;
    }

    @Override
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public NodeRef getNodeRef() {
        return this.getResultSet().getNodeRef(this.getIndex());
    }

    @Override
    public float getScore() {
        return this.getResultSet().getScore(this.getIndex());
    }

    @Override
    public Map<Path, Serializable> getValues() {
        if (this.properties == null) {
            this.properties = new HashMap<Path, Serializable>();
            this.setProperties(this.getDirectProperties());
        }
        return Collections.unmodifiableMap(this.properties);
    }

    protected Map<QName, Serializable> getDirectProperties() {
        return Collections.emptyMap();
    }

    protected void setProperties(Map<QName, Serializable> byQname) {
        for (QName qname : byQname.keySet()) {
            Serializable value = byQname.get(qname);
            Path path = new Path();
            path.append(new Path.SelfElement());
            path.append(new Path.AttributeElement(qname));
            this.properties.put(path, value);
        }
    }

    @Override
    public Serializable getValue(QName qname) {
        Path path = new Path();
        path.append(new Path.SelfElement());
        path.append(new Path.AttributeElement(qname));
        return this.getValues().get(path);
    }
}

