/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.io.Serializable;
import java.util.List;
import org.alfresco.repo.search.AbstractSearcherComponent;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearcherComponent
extends AbstractSearcherComponent {
    private IndexerAndSearcher indexerAndSearcherFactory;

    public void setIndexerAndSearcherFactory(IndexerAndSearcher indexerAndSearcherFactory) {
        this.indexerAndSearcherFactory = indexerAndSearcherFactory;
    }

    @Override
    public ResultSet query(StoreRef store, String language, String query, Path[] queryOptions, QueryParameterDefinition[] queryParameterDefinitions) {
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(store, true);
        return searcher.query(store, language, query, queryOptions, queryParameterDefinitions);
    }

    @Override
    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResultSet query(SearchParameters searchParameters) {
        if (searchParameters.getStores().size() != 1) {
            throw new IllegalStateException("Only one store can be searched at present");
        }
        StoreRef storeRef = searchParameters.getStores().get(0);
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(storeRef, !searchParameters.excludeDataInTheCurrentTransaction());
        return searcher.query(searchParameters);
    }

    @Override
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) throws InvalidNodeRefException {
        return this.contains(nodeRef, propertyQName, googleLikePattern, SearchParameters.Operator.OR);
    }

    @Override
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) throws InvalidNodeRefException {
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(nodeRef.getStoreRef(), true);
        return searcher.contains(nodeRef, propertyQName, googleLikePattern);
    }

    @Override
    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) throws InvalidNodeRefException {
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(nodeRef.getStoreRef(), true);
        return searcher.like(nodeRef, propertyQName, sqlLikePattern, includeFTS);
    }

    @Override
    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(contextNodeRef.getStoreRef(), true);
        return searcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    @Override
    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        SearchService searcher = this.indexerAndSearcherFactory.getSearcher(contextNodeRef.getStoreRef(), true);
        return searcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }
}

