/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.util.BitSet;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterIndexReaderByNodeRefs
extends FilterIndexReader {
    BitSet deletedDocuments;

    public FilterIndexReaderByNodeRefs(IndexReader reader, Set<NodeRef> deletions) {
        super(reader);
        this.deletedDocuments = new BitSet(reader.maxDoc());
        try {
            for (NodeRef nodeRef : deletions) {
                TermDocs td = reader.termDocs(new Term("ID", nodeRef.toString()));
                while (td.next()) {
                    this.deletedDocuments.set(td.doc(), true);
                }
            }
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("Failed to construct filtering index reader", (Throwable)e);
        }
    }

    public int numDocs() {
        return super.numDocs() - this.deletedDocuments.cardinality();
    }

    public TermDocs termDocs() throws IOException {
        return new FilterTermDocs(super.termDocs(), this.deletedDocuments);
    }

    public TermPositions termPositions() throws IOException {
        return new FilterTermPositions(super.termPositions(), this.deletedDocuments);
    }

    public static class FilterTermPositions
    extends FilterTermDocs
    implements TermPositions {
        public FilterTermPositions(TermPositions in, BitSet deletedDocuements) {
            super((TermDocs)in, deletedDocuements);
        }

        public int nextPosition() throws IOException {
            return ((TermPositions)this.in).nextPosition();
        }
    }

    public static class FilterTermDocs
    implements TermDocs {
        BitSet deletedDocuments;
        protected TermDocs in;

        public FilterTermDocs(TermDocs in, BitSet deletedDocuments) {
            this.in = in;
            this.deletedDocuments = deletedDocuments;
        }

        public void seek(Term term) throws IOException {
            this.in.seek(term);
        }

        public void seek(TermEnum termEnum) throws IOException {
            this.in.seek(termEnum);
        }

        public int doc() {
            return this.in.doc();
        }

        public int freq() {
            return this.in.freq();
        }

        public boolean next() throws IOException {
            while (this.in.next()) {
                if (this.deletedDocuments.get(this.in.doc())) continue;
                return true;
            }
            return false;
        }

        public int read(int[] docs, int[] freqs) throws IOException {
            int[] innerDocs = new int[docs.length];
            int[] innerFreq = new int[docs.length];
            int count = this.in.read(innerDocs, innerFreq);
            if (count == 0) {
                return 0;
            }
            if (this.allDeleted(innerDocs, count)) {
                return this.read(docs, freqs);
            }
            int insertPosition = 0;
            for (int i = 0; i < count; ++i) {
                if (this.deletedDocuments.get(innerDocs[i])) continue;
                docs[insertPosition] = innerDocs[i];
                freqs[insertPosition] = innerFreq[i];
                ++insertPosition;
            }
            return insertPosition;
        }

        private boolean allDeleted(int[] docs, int fillSize) {
            for (int i = 0; i < fillSize; ++i) {
                if (this.deletedDocuments.get(docs[i])) continue;
                return false;
            }
            return true;
        }

        public boolean skipTo(int i) throws IOException {
            boolean result = this.in.skipTo(i);
            if (!result) {
                return false;
            }
            if (this.deletedDocuments.get(this.in.doc())) {
                return this.skipTo(i);
            }
            return true;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

