/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.search.impl.lucene.analysis.PathAnalyser;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;

public class LuceneAnalyser
extends Analyzer {
    private DictionaryService dictionaryService;
    private Analyzer defaultAnalyser;
    private Map<String, Analyzer> analysers = new HashMap<String, Analyzer>();

    public LuceneAnalyser(DictionaryService dictionaryService) {
        this((Analyzer)new StandardAnalyzer());
        this.dictionaryService = dictionaryService;
    }

    public LuceneAnalyser(Analyzer defaultAnalyser) {
        this.defaultAnalyser = defaultAnalyser;
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        Analyzer analyser = this.analysers.get(fieldName);
        if (analyser == null) {
            analyser = this.findAnalyser(fieldName);
        }
        return analyser.tokenStream(fieldName, reader);
    }

    private Analyzer findAnalyser(String fieldName) {
        PathAnalyser analyser;
        if (fieldName.equals("PATH")) {
            analyser = new PathAnalyser();
        } else if (fieldName.equals("QNAME")) {
            analyser = new PathAnalyser();
        } else {
            if (fieldName.equals("TYPE")) {
                throw new UnsupportedOperationException("TYPE must not be tokenised");
            }
            if (fieldName.equals("ASPECT")) {
                throw new UnsupportedOperationException("ASPECT must not be tokenised");
            }
            if (fieldName.equals("ANCESTOR")) {
                analyser = new WhitespaceAnalyzer();
            } else if (fieldName.equals("TEXT")) {
                DataTypeDefinition dataType = this.dictionaryService.getDataType(DataTypeDefinition.TEXT);
                analyser = this.loadAnalyzer(dataType);
            } else if (fieldName.startsWith("@")) {
                QName propertyQName = QName.createQName(fieldName.substring(1));
                PropertyDefinition propertyDef = this.dictionaryService.getProperty(propertyQName);
                DataTypeDefinition dataType = propertyDef == null ? this.dictionaryService.getDataType(DataTypeDefinition.TEXT) : propertyDef.getDataType();
                analyser = this.loadAnalyzer(dataType);
            } else {
                analyser = this.defaultAnalyser;
            }
        }
        this.analysers.put(fieldName, analyser);
        return analyser;
    }

    private Analyzer loadAnalyzer(DataTypeDefinition dataType) {
        String analyserClassName = dataType.getAnalyserClassName();
        try {
            Class<?> clazz = Class.forName(analyserClassName);
            Analyzer analyser = (Analyzer)clazz.newInstance();
            return analyser;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to load analyser for property of type " + dataType.getName() + " using " + analyserClassName);
        }
    }
}

