/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.FilterIndexReaderByNodeRefs;
import org.alfresco.repo.search.impl.lucene.Lockable;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.transaction.LuceneIndexLock;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LuceneBase
implements Lockable {
    private static Logger s_logger = Logger.getLogger(LuceneBase.class);
    private File baseDir;
    private File deltaDir;
    private File undoDir;
    private IndexReader deltaReader;
    private IndexWriter deltaWriter;
    private IndexWriter mainWriter;
    private IndexReader mainReader;
    protected StoreRef store;
    protected String deltaId;
    private LuceneIndexLock luceneIndexLock;
    private LuceneConfig config;
    private int writeLockCount = 0;
    private DictionaryService dictionaryService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(StoreRef store, String deltaId, boolean createMain, boolean createDelta) throws LuceneIndexException {
        block9: {
            this.store = store;
            this.deltaId = deltaId;
            String basePath = this.getMainPath();
            this.baseDir = new File(basePath);
            if (createMain) {
                this.getWriteLock();
            }
            try {
                try {
                    this.initialiseFSDirectory(basePath, false, createMain).close();
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Failed to close directory after initialisation " + basePath);
                }
                if (deltaId == null) break block9;
                String deltaPath = this.getDeltaPath();
                this.deltaDir = new File(deltaPath);
                try {
                    this.initialiseFSDirectory(deltaPath, createDelta, createDelta).close();
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Failed to close directory after initialisation " + deltaPath);
                }
            }
            finally {
                if (createMain) {
                    this.releaseWriteLock();
                }
            }
        }
    }

    private String getDeltaPath() {
        String deltaPath = this.getBasePath() + File.separator + "delta" + File.separator + this.deltaId + File.separator;
        return deltaPath;
    }

    private String getMainPath() {
        String mainPath = this.getBasePath() + File.separator + "index" + File.separator;
        return mainPath;
    }

    private String getBasePath() {
        if (this.config.getIndexRootLocation() == null) {
            throw new IndexerException("No configuration for index location");
        }
        String basePath = this.config.getIndexRootLocation() + File.separator + this.store.getProtocol() + File.separator + this.store.getIdentifier() + File.separator;
        return basePath;
    }

    private Directory initialiseFSDirectory(String path, boolean deleteOnExit, boolean overwrite) throws LuceneIndexException {
        try {
            File file = new File(path);
            if (overwrite) {
                // empty if block
            }
            if (!file.exists()) {
                file.mkdirs();
                if (deleteOnExit) {
                    file.deleteOnExit();
                }
                return FSDirectory.getDirectory((File)file, (boolean)true);
            }
            return FSDirectory.getDirectory((File)file, (boolean)overwrite);
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Filed to initialise lucene file directory " + path, e);
        }
    }

    protected IndexSearcher getSearcher() throws LuceneIndexException {
        try {
            return new IndexSearcher(this.getMainPath());
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getMainPath(), e);
        }
    }

    protected Searcher getSearcher(LuceneIndexer luceneIndexer) throws LuceneIndexException {
        try {
            if (this.mainIndexExists()) {
                if (luceneIndexer == null) {
                    return new IndexSearcher(this.getMainPath());
                }
                luceneIndexer.flushPending();
                return new ClosingIndexSearcher((IndexReader)new MultiReader(new IndexReader[]{new FilterIndexReaderByNodeRefs(IndexReader.open((String)this.getMainPath()), luceneIndexer.getDeletions()), IndexReader.open((String)this.getDeltaPath())}));
            }
            if (luceneIndexer == null) {
                return null;
            }
            luceneIndexer.flushPending();
            return new IndexSearcher(this.getDeltaPath());
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getMainPath(), e);
        }
    }

    protected IndexReader getDeltaReader() throws LuceneIndexException {
        if (this.deltaReader == null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Trying to get index delta reader for tx " + this.deltaDir));
            }
            this.closeDeltaWriter();
            if (!this.indexExists(this.deltaDir)) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("... index does not already exist for " + this.deltaDir + " creating ..."));
                }
                try {
                    IndexWriter writer = new IndexWriter(this.deltaDir, (Analyzer)new LuceneAnalyser(this.dictionaryService), true);
                    writer.setUseCompoundFile(true);
                    writer.close();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("... index created " + this.deltaDir));
                    }
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Failed to create empty index for delta reader: " + this.deltaDir, e);
                }
            }
            try {
                this.deltaReader = IndexReader.open((File)this.deltaDir);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Opened delta reader for " + this.deltaDir));
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new LuceneIndexException("Failed to open delta reader: " + this.deltaDir, e);
            }
        }
        return this.deltaReader;
    }

    private boolean indexExists(File dir) {
        return IndexReader.indexExists((File)dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDeltaReader() throws LuceneIndexException {
        if (this.deltaReader != null) {
            try {
                try {
                    this.deltaReader.close();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Closed delta read for " + this.deltaDir));
                    }
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Filed to close delta reader " + this.deltaDir, e);
                }
            }
            finally {
                this.deltaReader = null;
            }
        }
    }

    protected IndexWriter getDeltaWriter() throws LuceneIndexException {
        if (this.deltaWriter == null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Trying to create delta writer " + this.deltaDir));
            }
            this.closeDeltaReader();
            try {
                boolean create;
                boolean bl = create = !IndexReader.indexExists((File)this.deltaDir);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Creating delta writer " + this.deltaDir + " " + (create ? "CREATE" : "OPEN")));
                }
                this.deltaWriter = new IndexWriter(this.deltaDir, (Analyzer)new LuceneAnalyser(this.dictionaryService), create);
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new IndexerException("Failed to get delta writer for " + this.deltaDir, e);
            }
        }
        this.deltaWriter.setUseCompoundFile(true);
        this.deltaWriter.minMergeDocs = this.config.getIndexerMinMergeDocs();
        this.deltaWriter.mergeFactor = this.config.getIndexerMergeFactor();
        this.deltaWriter.maxMergeDocs = this.config.getIndexerMaxMergeDocs();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Created delta writer " + this.deltaDir));
        }
        return this.deltaWriter;
    }

    protected void closeDeltaWriter() throws LuceneIndexException {
        if (this.deltaWriter != null) {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Trying to close delta writer... " + this.deltaDir));
            }
            try {
                this.deltaWriter.close();
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Closed delta writer " + this.deltaDir));
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new LuceneIndexException("Failed to close delta writer " + this.deltaDir, e);
            }
            finally {
                this.deltaWriter = null;
            }
        }
    }

    protected void saveDelta() throws LuceneIndexException {
        this.closeDeltaReader();
        this.closeDeltaWriter();
    }

    protected void prepareToMergeIntoMain() throws LuceneIndexException {
        if (this.mainWriter != null) {
            throw new IndexerException("Can not merge as main writer is active");
        }
        if (this.mainReader != null) {
            throw new IndexerException("Can not merge as main reader is active");
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Getting write lock for " + this.baseDir + " for " + this.deltaDir));
        }
        this.getWriteLock();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Got write lock for " + this.baseDir + " for " + this.deltaDir));
        }
        try {
            this.getDeltaReader();
            this.closeDeltaReader();
        }
        catch (LuceneIndexException e) {
            s_logger.error((Object)"Error", (Throwable)((Object)e));
            this.releaseWriteLock();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void mergeDeltaIntoMain(Set<Term> terms) throws LuceneIndexException {
        if (this.writeLockCount < 1) {
            throw new LuceneIndexException("Must hold the write lock to merge");
        }
        try {
            if (!this.indexExists(this.baseDir)) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Creating base index " + this.baseDir));
                }
                try {
                    this.mainWriter = new IndexWriter(this.baseDir, (Analyzer)new LuceneAnalyser(this.dictionaryService), true);
                    this.mainWriter.setUseCompoundFile(true);
                    this.mainWriter.close();
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Created base index " + this.baseDir));
                    }
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Failed to create empty base index at " + this.baseDir, e);
                }
            }
            try {
                this.mainReader = IndexReader.open((File)this.baseDir);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Opened base index for deletes " + this.baseDir));
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new LuceneIndexException("Failed to create base index reader at " + this.baseDir, e);
            }
            try {
                if (this.mainReader.numDocs() > 0 && terms.size() > 0) {
                    for (Term term : terms) {
                        try {
                            this.mainReader.delete(term);
                        }
                        catch (IOException e) {
                            s_logger.error((Object)"Error", (Throwable)e);
                            throw new LuceneIndexException("Failed to delete term from main index at " + this.baseDir, e);
                        }
                    }
                }
            }
            finally {
                try {
                    try {
                        this.mainReader.close();
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("Completed index deletes on " + this.baseDir + " for " + this.deltaDir));
                        }
                    }
                    catch (IOException e) {
                        s_logger.error((Object)"Error", (Throwable)e);
                        throw new LuceneIndexException("Failed to close from main index reader at " + this.baseDir, e);
                    }
                }
                finally {
                    this.mainReader = null;
                }
            }
            try {
                this.mainWriter = new IndexWriter(this.baseDir, (Analyzer)new LuceneAnalyser(this.dictionaryService), false);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Opened index for append " + this.baseDir + " for " + this.deltaDir));
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new LuceneIndexException("Failed to open main index for append at " + this.baseDir, e);
            }
            this.mainWriter.setUseCompoundFile(true);
            this.mainWriter.minMergeDocs = this.config.getIndexerMinMergeDocs();
            this.mainWriter.mergeFactor = this.config.getIndexerMergeFactor();
            this.mainWriter.maxMergeDocs = this.config.getIndexerMaxMergeDocs();
            try {
                IndexReader reader = this.getDeltaReader();
                if (reader.numDocs() > 0) {
                    IndexReader[] readers = new IndexReader[]{reader};
                    try {
                        this.mainWriter.mergeIndexes(readers);
                    }
                    catch (IOException e) {
                        s_logger.error((Object)"Error", (Throwable)e);
                        throw new LuceneIndexException("Failed to merge indexes into the main index for " + this.baseDir + " merging in " + this.deltaDir, e);
                    }
                    this.closeDeltaReader();
                } else {
                    this.closeDeltaReader();
                }
                if (!s_logger.isDebugEnabled()) return;
                s_logger.debug((Object)("Closed index after append " + this.baseDir + " for " + this.deltaDir));
                return;
            }
            finally {
                try {
                    try {
                        this.mainWriter.close();
                    }
                    catch (IOException e) {
                        s_logger.error((Object)"Error", (Throwable)e);
                        throw new LuceneIndexException("Failed to cloase main index after append at " + this.baseDir, e);
                    }
                }
                finally {
                    this.mainWriter = null;
                }
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteDelta() throws LuceneIndexException {
        try {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Deleting delta " + this.deltaDir));
            }
            try {
                this.closeDeltaReader();
            }
            catch (LuceneIndexException e) {
                s_logger.warn((Object)e);
            }
            try {
                this.closeDeltaWriter();
            }
            catch (LuceneIndexException e) {
                s_logger.warn((Object)e);
            }
            this.deltaDir = null;
            if (this.mainReader != null) {
                try {
                    this.mainReader.close();
                }
                catch (IOException e) {
                    s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
                }
            }
            this.mainReader = null;
            if (this.mainWriter != null) {
                try {
                    this.mainWriter.close();
                }
                catch (IOException e) {
                    s_logger.warn((Object)"Failed to close main writer", (Throwable)e);
                }
            }
            this.mainWriter = null;
            String deltaPath = this.getDeltaPath();
            File file = new File(deltaPath);
            this.deleteDirectory(file);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void deleteDirectory(File file) {
        File[] children = file.listFiles();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (child.isDirectory()) {
                    this.deleteDirectory(child);
                    continue;
                }
                if (!child.exists() || child.delete() || !child.exists()) continue;
                s_logger.warn((Object)("Failed to delete " + child));
            }
        }
        if (file.exists() && !file.delete() && file.exists()) {
            s_logger.warn((Object)("Failed to delete " + file));
        }
    }

    @Override
    public LuceneIndexLock getLuceneIndexLock() {
        return this.luceneIndexLock;
    }

    @Override
    public void setLuceneIndexLock(LuceneIndexLock luceneIndexLock) {
        this.luceneIndexLock = luceneIndexLock;
    }

    @Override
    public void getReadLock() {
        this.getLuceneIndexLock().getReadLock(this.store);
    }

    public static boolean isWriteLocked(String directory) throws IOException {
        FSDirectory dir = FSDirectory.getDirectory((String)directory, (boolean)false);
        boolean result = LuceneBase.isWriteLocked((Directory)dir);
        dir.close();
        return result;
    }

    public static boolean isWriteLocked(Directory directory) throws IOException {
        return directory.makeLock("write.lock").isLocked();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getWriteLock() throws LuceneIndexException {
        block6: {
            this.getLuceneIndexLock().getWriteLock(this.store);
            ++this.writeLockCount;
            try {
                StackTraceElement[] trace;
                if (this.writeLockCount != 1 || !IndexReader.indexExists((File)this.baseDir) || !LuceneBase.isWriteLocked(this.baseDir.getPath())) break block6;
                FSDirectory dir = FSDirectory.getDirectory((File)this.baseDir, (boolean)false);
                try {
                    dir.makeLock("write.lock").release();
                }
                finally {
                    dir.close();
                }
                s_logger.warn((Object)("Releasing unexpected lucene index write lock for " + this.baseDir));
                for (StackTraceElement el : trace = Thread.currentThread().getStackTrace()) {
                    s_logger.warn((Object)el.toString());
                }
            }
            catch (IOException e) {
                s_logger.error((Object)"Error", (Throwable)e);
                throw new LuceneIndexException("Write lock failed to check or clear any existing lucene locks", e);
            }
        }
    }

    @Override
    public void releaseReadLock() {
        this.getLuceneIndexLock().releaseReadLock(this.store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseWriteLock() {
        if (this.writeLockCount > 0) {
            block7: {
                try {
                    if (this.writeLockCount != 1 || !IndexReader.indexExists((File)this.baseDir) || !LuceneBase.isWriteLocked(this.baseDir.getPath())) break block7;
                    FSDirectory dir = FSDirectory.getDirectory((File)this.baseDir, (boolean)false);
                    try {
                        dir.makeLock("write.lock").release();
                    }
                    finally {
                        dir.close();
                    }
                }
                catch (IOException e) {
                    s_logger.error((Object)"Error", (Throwable)e);
                    throw new LuceneIndexException("Write lock failed to check or clear any existing lucene locks", e);
                }
            }
            this.getLuceneIndexLock().releaseWriteLock(this.store);
            --this.writeLockCount;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Released write lock " + this.baseDir + " for " + this.deltaDir));
            }
        }
    }

    public boolean mainIndexExists() {
        return IndexReader.indexExists((File)this.baseDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexReader getReader() throws LuceneIndexException {
        block8: {
            if (!this.indexExists(this.baseDir)) {
                this.getWriteLock();
                try {
                    if (this.indexExists(this.baseDir)) break block8;
                    try {
                        this.mainWriter = new IndexWriter(this.baseDir, (Analyzer)new LuceneAnalyser(this.dictionaryService), true);
                        this.mainWriter.setUseCompoundFile(true);
                        this.mainWriter.close();
                        this.mainWriter = null;
                    }
                    catch (IOException e) {
                        s_logger.error((Object)"Error", (Throwable)e);
                        throw new LuceneIndexException("Failed to create empty main index", e);
                    }
                }
                finally {
                    this.releaseWriteLock();
                }
            }
        }
        try {
            return IndexReader.open((File)this.baseDir);
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open main index reader", e);
        }
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setLuceneConfig(LuceneConfig config) {
        this.config = config;
    }

    public LuceneConfig getLuceneConfig() {
        return this.config;
    }

    public String getDeltaId() {
        return this.deltaId;
    }
}

