/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer2;
import org.alfresco.repo.search.impl.lucene.index.IndexInfo;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.apache.log4j.Logger;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Searcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LuceneBase2 {
    private static Logger s_logger = Logger.getLogger(LuceneBase2.class);
    private IndexInfo indexInfo;
    protected StoreRef store;
    protected String deltaId;
    private LuceneConfig config;
    private DictionaryService dictionaryService;

    protected void initialise(StoreRef store, String deltaId, boolean createMain, boolean createDelta) throws LuceneIndexException {
        this.store = store;
        this.deltaId = deltaId;
        String basePath = this.getBasePath();
        File baseDir = new File(basePath);
        this.indexInfo = IndexInfo.getIndexInfo(baseDir);
        try {
            if (deltaId != null) {
                this.indexInfo.setStatus(deltaId, TransactionStatus.ACTIVE, null, null);
            }
        }
        catch (IOException e) {
            throw new IndexerException("Filed to set delta as active");
        }
    }

    private String getBasePath() {
        if (this.config.getIndexRootLocation() == null) {
            throw new IndexerException("No configuration for index location");
        }
        String basePath = this.config.getIndexRootLocation() + File.separator + this.store.getProtocol() + File.separator + this.store.getIdentifier() + File.separator;
        return basePath;
    }

    protected IndexSearcher getSearcher() throws LuceneIndexException {
        try {
            return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader());
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getBasePath(), e);
        }
    }

    protected Searcher getSearcher(LuceneIndexer2 luceneIndexer) throws LuceneIndexException {
        try {
            if (luceneIndexer == null) {
                return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader());
            }
            luceneIndexer.flushPending();
            return new ClosingIndexSearcher(this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader(this.deltaId, luceneIndexer.getDeletions(), luceneIndexer.getDeleteOnlyNodes()));
        }
        catch (IOException e) {
            s_logger.error((Object)"Error", (Throwable)e);
            throw new LuceneIndexException("Failed to open IndexSarcher for " + this.getBasePath(), e);
        }
    }

    protected IndexReader getDeltaReader() throws LuceneIndexException, IOException {
        return this.indexInfo.getDeltaIndexReader(this.deltaId);
    }

    protected void closeDeltaReader() throws LuceneIndexException, IOException {
        this.indexInfo.closeDeltaIndexReader(this.deltaId);
    }

    protected IndexWriter getDeltaWriter() throws LuceneIndexException, IOException {
        return this.indexInfo.getDeltaIndexWriter(this.deltaId, new LuceneAnalyser(this.dictionaryService));
    }

    protected void closeDeltaWriter() throws LuceneIndexException, IOException {
        this.indexInfo.closeDeltaIndexWriter(this.deltaId);
    }

    protected void saveDelta() throws LuceneIndexException, IOException {
        this.closeDeltaReader();
        this.closeDeltaWriter();
    }

    protected void setInfo(long docs, Set<NodeRef> deletions, boolean deleteNodesOnly) throws IOException {
        this.indexInfo.setPreparedState(this.deltaId, deletions, docs, deleteNodesOnly);
    }

    protected void setStatus(TransactionStatus status) throws IOException {
        this.indexInfo.setStatus(this.deltaId, status, null, null);
    }

    protected IndexReader getReader() throws LuceneIndexException, IOException {
        return this.indexInfo.getMainIndexReferenceCountingReadOnlyIndexReader();
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public DictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setLuceneConfig(LuceneConfig config) {
        this.config = config;
    }

    public LuceneConfig getLuceneConfig() {
        return this.config;
    }

    public String getDeltaId() {
        return this.deltaId;
    }
}

