/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCategoryServiceImpl
implements CategoryService {
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    HashMap<String, String> prefixLookup = new HashMap();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setIndexerAndSearcher(LuceneIndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth) {
        if (categoryRef == null) {
            return Collections.emptyList();
        }
        ResultSet resultSet = null;
        try {
            StringBuilder luceneQuery = new StringBuilder(64);
            if (!mode.equals((Object)CategoryService.Mode.ALL)) {
                luceneQuery.append(mode.equals((Object)CategoryService.Mode.SUB_CATEGORIES) ? "-" : "").append("PATH_WITH_REPEATS:\"");
                luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                if (depth.equals((Object)CategoryService.Depth.ANY)) {
                    luceneQuery.append("/");
                }
                luceneQuery.append("member").append("\" ");
            }
            if (!mode.equals((Object)CategoryService.Mode.MEMBERS)) {
                luceneQuery.append("PATH_WITH_REPEATS:\"");
                luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                if (depth.equals((Object)CategoryService.Depth.ANY)) {
                    luceneQuery.append("/");
                }
                luceneQuery.append("*").append("\" ");
            }
            resultSet = this.indexerAndSearcher.getSearcher(categoryRef.getStoreRef(), false).query(categoryRef.getStoreRef(), "lucene", luceneQuery.toString(), null, null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private String buildXPath(Path path) {
        StringBuilder pathBuffer = new StringBuilder(64);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            if (cae.getRef().getParentRef() == null) continue;
            pathBuffer.append("/");
            pathBuffer.append(this.getPrefix(cae.getRef().getQName().getNamespaceURI()));
            pathBuffer.append(ISO9075.encode(cae.getRef().getQName().getLocalName()));
        }
        return pathBuffer.toString();
    }

    private String getPrefix(String uri) {
        String prefix = this.prefixLookup.get(uri);
        if (prefix == null) {
            Collection<String> prefixes = this.namespacePrefixResolver.getPrefixes(uri);
            Iterator<String> i$ = prefixes.iterator();
            if (i$.hasNext()) {
                String first;
                prefix = first = i$.next();
            }
            this.prefixLookup.put(uri, prefix);
        }
        if (prefix == null) {
            return "";
        }
        return prefix + ":";
    }

    private Collection<ChildAssociationRef> resultSetToChildAssocCollection(ResultSet resultSet) {
        ArrayList<ChildAssociationRef> collection = new ArrayList<ChildAssociationRef>();
        if (resultSet != null) {
            for (ResultSetRow row : resultSet) {
                ChildAssociationRef car = this.nodeService.getPrimaryParent(row.getNodeRef());
                collection.add(car);
            }
        }
        return collection;
    }

    @Override
    public Collection<ChildAssociationRef> getCategories(StoreRef storeRef, QName aspectQName, CategoryService.Depth depth) {
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectQName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, depth));
        }
        return assocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NodeRef> getClassificationNodes(StoreRef storeRef, QName qname) {
        ResultSet resultSet = null;
        try {
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH_WITH_REPEATS:\"/" + this.getPrefix(qname.getNamespaceURI()) + ISO9075.encode(qname.getLocalName()) + "\"", null, null);
            HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>(resultSet.length());
            for (ResultSetRow row : resultSet) {
                nodeRefs.add(row.getNodeRef());
            }
            HashSet<NodeRef> hashSet = nodeRefs;
            return hashSet;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ChildAssociationRef> getClassifications(StoreRef storeRef) {
        ResultSet resultSet = null;
        try {
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH_WITH_REPEATS:\"//cm:categoryRoot/*\"", null, null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public Collection<QName> getClassificationAspects() {
        ArrayList<QName> list = new ArrayList<QName>();
        for (QName aspect : this.dictionaryService.getAllAspects()) {
            if (!this.dictionaryService.isSubClass(aspect, ContentModel.ASPECT_CLASSIFIABLE)) continue;
            list.add(aspect);
        }
        return list;
    }

    @Override
    public NodeRef createClassifiction(StoreRef storeRef, QName typeName, String attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName) {
        ArrayList<ChildAssociationRef> assocs = new ArrayList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE));
        }
        return assocs;
    }

    @Override
    public NodeRef createCategory(NodeRef parent, String name) {
        if (!this.nodeService.exists(parent)) {
            throw new AlfrescoRuntimeException("Missing category?");
        }
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        String validLocalName = QName.createValidLocalName(name);
        NodeRef newCategory = this.nodeService.createNode(parent, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(uri, validLocalName), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.setProperty(newCategory, ContentModel.PROP_NAME, (Serializable)((Object)name));
        return newCategory;
    }

    @Override
    public NodeRef createRootCategory(StoreRef storeRef, QName aspectName, String name) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("Missing classification: " + aspectName);
        }
        NodeRef parent = nodeRefs.iterator().next();
        return this.createCategory(parent, name);
    }

    @Override
    public void deleteCategory(NodeRef nodeRef) {
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public void deleteClassification(StoreRef storeRef, QName aspectName) {
        throw new UnsupportedOperationException();
    }
}

