/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.M2Property;
import org.alfresco.repo.search.impl.lucene.LuceneCategoryServiceImpl;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerImpl2;
import org.alfresco.repo.search.impl.lucene.LuceneSearcherImpl2;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.search.transaction.LuceneIndexLock;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneCategoryTest2
extends TestCase {
    private ServiceRegistry serviceRegistry;
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    NodeService nodeService;
    DictionaryService dictionaryService;
    LuceneIndexLock luceneIndexLock;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n6;
    private NodeRef n5;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeRef n11;
    private NodeRef n12;
    private NodeRef n13;
    private NodeRef n14;
    private NodeRef catContainer;
    private NodeRef catRoot;
    private NodeRef catACBase;
    private NodeRef catACOne;
    private NodeRef catACTwo;
    private NodeRef catACThree;
    private FullTextSearchIndexer luceneFTS;
    private DictionaryDAO dictionaryDAO;
    private String TEST_NAMESPACE = "http://www.alfresco.org/test/lucenecategorytest";
    private QName regionCategorisationQName;
    private QName assetClassCategorisationQName;
    private QName investmentRegionCategorisationQName;
    private QName marketingRegionCategorisationQName;
    private NodeRef catRBase;
    private NodeRef catROne;
    private NodeRef catRTwo;
    private NodeRef catRThree;
    private SearchService searcher;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    private CategoryService categoryService;

    public LuceneCategoryTest2() {
    }

    public LuceneCategoryTest2(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.luceneIndexLock = (LuceneIndexLock)ctx.getBean("luceneIndexLock");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.searcher = (SearchService)ctx.getBean("searchService");
        this.indexerAndSearcher = (LuceneIndexerAndSearcher)ctx.getBean("luceneIndexerAndSearcherFactory");
        this.categoryService = (CategoryService)ctx.getBean("categoryService");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.createTestTypes();
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.setProperty(this.n1, QName.createQName("{namespace}property-1"), (Serializable)((Object)"value-1"));
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}two"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.setProperty(this.n2, QName.createQName("{namespace}property-1"), (Serializable)((Object)"value-1"));
        this.nodeService.setProperty(this.n2, QName.createQName("{namespace}property-2"), (Serializable)((Object)"value-2"));
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}three"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}four"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n5 = this.nodeService.createNode(this.n1, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}five"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n6 = this.nodeService.createNode(this.n1, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}six"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n7 = this.nodeService.createNode(this.n2, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}seven"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n8 = this.nodeService.createNode(this.n2, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}eight-2"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n9 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}nine"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n10 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}ten"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n11 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}eleven"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n12 = this.nodeService.createNode(this.n5, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}twelve"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n13 = this.nodeService.createNode(this.n12, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}thirteen"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.n14 = this.nodeService.createNode(this.n13, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}fourteen"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.nodeService.addChild(this.rootNodeRef, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}eight-0"));
        this.nodeService.addChild(this.n1, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}eight-1"));
        this.nodeService.addChild(this.n2, this.n13, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}link"));
        this.nodeService.addChild(this.n1, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n2, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n5, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n6, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n12, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n13, this.n14, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}common"));
        this.catContainer = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org/model/content/1.0", "categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
        this.catRoot = this.nodeService.createNode(this.catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName("http://www.alfresco.org/model/content/1.0", "categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
        this.catRBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName(this.TEST_NAMESPACE, "Region"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catROne = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "Europe"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRTwo = this.nodeService.createNode(this.catRBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "RestOfWorld"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catRThree = this.nodeService.createNode(this.catRTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "US"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.addChild(this.catRoot, this.catRBase, ContentModel.ASSOC_CATEGORIES, QName.createQName(this.TEST_NAMESPACE, "InvestmentRegion"));
        this.nodeService.addChild(this.catRoot, this.catRBase, ContentModel.ASSOC_CATEGORIES, QName.createQName(this.TEST_NAMESPACE, "MarketingRegion"));
        this.catACBase = this.nodeService.createNode(this.catRoot, ContentModel.ASSOC_CATEGORIES, QName.createQName(this.TEST_NAMESPACE, "AssetClass"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACOne = this.nodeService.createNode(this.catACBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "Fixed"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACTwo = this.nodeService.createNode(this.catACBase, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "Equity"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.catACThree = this.nodeService.createNode(this.catACTwo, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName(this.TEST_NAMESPACE, "SpecialEquity"), ContentModel.TYPE_CATEGORY).getChildRef();
        this.nodeService.addAspect(this.n1, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACBase));
        this.nodeService.addAspect(this.n1, this.regionCategorisationQName, this.createMap("region", this.catRBase));
        this.nodeService.addAspect(this.n2, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n3, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n4, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n5, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n6, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne));
        this.nodeService.addAspect(this.n7, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n8, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n9, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n10, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n11, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACTwo));
        this.nodeService.addAspect(this.n12, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo));
        this.nodeService.addAspect(this.n13, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo, this.catACThree));
        this.nodeService.addAspect(this.n14, this.assetClassCategorisationQName, this.createMap("assetClass", this.catACOne, this.catACTwo));
        this.nodeService.addAspect(this.n2, this.regionCategorisationQName, this.createMap("region", this.catROne));
        this.nodeService.addAspect(this.n3, this.regionCategorisationQName, this.createMap("region", this.catROne));
        this.nodeService.addAspect(this.n4, this.regionCategorisationQName, this.createMap("region", this.catRTwo));
        this.nodeService.addAspect(this.n5, this.regionCategorisationQName, this.createMap("region", this.catRTwo));
        this.nodeService.addAspect(this.n5, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n5, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n6, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n7, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n8, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n9, this.investmentRegionCategorisationQName, this.createMap("investmentRegion", this.catRBase));
        this.nodeService.addAspect(this.n10, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n11, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n12, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n13, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        this.nodeService.addAspect(this.n14, this.marketingRegionCategorisationQName, this.createMap("marketingRegion", this.catRBase));
        tx.commit();
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef[] nodeRefs) {
        HashMap<QName, Serializable> map = new HashMap<QName, Serializable>();
        Serializable value = (Serializable)((Object)Arrays.asList(nodeRefs));
        map.put(QName.createQName(this.TEST_NAMESPACE, name), value);
        return map;
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef) {
        return this.createMap(name, new NodeRef[]{nodeRef});
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef1, NodeRef nodeRef2) {
        return this.createMap(name, new NodeRef[]{nodeRef1, nodeRef2});
    }

    private HashMap<QName, Serializable> createMap(String name, NodeRef nodeRef1, NodeRef nodeRef2, NodeRef nodeRef3) {
        return this.createMap(name, new NodeRef[]{nodeRef1, nodeRef2, nodeRef3});
    }

    private void createTestTypes() {
        M2Model model = M2Model.createModel("test:lucenecategory");
        model.createNamespace(this.TEST_NAMESPACE, "test");
        model.createImport("http://www.alfresco.org/model/dictionary/1.0", "d");
        model.createImport("http://www.alfresco.org/model/content/1.0", "cm");
        this.regionCategorisationQName = QName.createQName(this.TEST_NAMESPACE, "Region");
        M2Aspect generalCategorisation = model.createAspect("test:" + this.regionCategorisationQName.getLocalName());
        generalCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property genCatProp = generalCategorisation.createProperty("test:region");
        genCatProp.setIndexed(true);
        genCatProp.setIndexedAtomically(true);
        genCatProp.setMandatory(true);
        genCatProp.setMultiValued(true);
        genCatProp.setStoredInIndex(true);
        genCatProp.setTokenisedInIndex(true);
        genCatProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.assetClassCategorisationQName = QName.createQName(this.TEST_NAMESPACE, "AssetClass");
        M2Aspect assetClassCategorisation = model.createAspect("test:" + this.assetClassCategorisationQName.getLocalName());
        assetClassCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property acProp = assetClassCategorisation.createProperty("test:assetClass");
        acProp.setIndexed(true);
        acProp.setIndexedAtomically(true);
        acProp.setMandatory(true);
        acProp.setMultiValued(true);
        acProp.setStoredInIndex(true);
        acProp.setTokenisedInIndex(true);
        acProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.investmentRegionCategorisationQName = QName.createQName(this.TEST_NAMESPACE, "InvestmentRegion");
        M2Aspect investmentRegionCategorisation = model.createAspect("test:" + this.investmentRegionCategorisationQName.getLocalName());
        investmentRegionCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property irProp = investmentRegionCategorisation.createProperty("test:investmentRegion");
        irProp.setIndexed(true);
        irProp.setIndexedAtomically(true);
        irProp.setMandatory(true);
        irProp.setMultiValued(true);
        irProp.setStoredInIndex(true);
        irProp.setTokenisedInIndex(true);
        irProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.marketingRegionCategorisationQName = QName.createQName(this.TEST_NAMESPACE, "MarketingRegion");
        M2Aspect marketingRegionCategorisation = model.createAspect("test:" + this.marketingRegionCategorisationQName.getLocalName());
        marketingRegionCategorisation.setParentName("cm:" + ContentModel.ASPECT_CLASSIFIABLE.getLocalName());
        M2Property mrProp = marketingRegionCategorisation.createProperty("test:marketingRegion");
        mrProp.setIndexed(true);
        mrProp.setIndexedAtomically(true);
        mrProp.setMandatory(true);
        mrProp.setMultiValued(true);
        mrProp.setStoredInIndex(true);
        mrProp.setTokenisedInIndex(true);
        mrProp.setType("d:" + DataTypeDefinition.CATEGORY.getLocalName());
        this.dictionaryDAO.putModel(model);
    }

    private void buildBaseIndex() {
        LuceneIndexerImpl2 indexer = LuceneIndexerImpl2.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}two"), this.n2));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}three"), this.n3));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}four"), this.n4));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}categoryContainer"), this.catContainer));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.catContainer, QName.createQName("{cat}categoryRoot"), this.catRoot));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.catRoot, QName.createQName(this.TEST_NAMESPACE, "AssetClass"), this.catACBase));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACBase, QName.createQName(this.TEST_NAMESPACE, "Fixed"), this.catACOne));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACBase, QName.createQName(this.TEST_NAMESPACE, "Equity"), this.catACTwo));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catACTwo, QName.createQName(this.TEST_NAMESPACE, "SpecialEquity"), this.catACThree));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.catRoot, QName.createQName(this.TEST_NAMESPACE, "Region"), this.catRBase));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRBase, QName.createQName(this.TEST_NAMESPACE, "Europe"), this.catROne));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRBase, QName.createQName(this.TEST_NAMESPACE, "RestOfWorld"), this.catRTwo));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_SUBCATEGORIES, this.catRTwo, QName.createQName(this.TEST_NAMESPACE, "US"), this.catRThree));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n1, QName.createQName("{namespace}five"), this.n5));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n1, QName.createQName("{namespace}six"), this.n6));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n2, QName.createQName("{namespace}seven"), this.n7));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n2, QName.createQName("{namespace}eight"), this.n8));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName("{namespace}nine"), this.n9));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName("{namespace}ten"), this.n10));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName("{namespace}eleven"), this.n11));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n5, QName.createQName("{namespace}twelve"), this.n12));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n12, QName.createQName("{namespace}thirteen"), this.n13));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CATEGORIES, this.n13, QName.createQName("{namespace}fourteen"), this.n14));
        indexer.prepare();
        indexer.commit();
    }

    public void testMulti() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        LuceneSearcherImpl2 searcher = LuceneSearcherImpl2.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\" AND (PATH:\"/test:AssetClass/test:Equity/member\" PATH:\"/test:MarketingRegion/member\")", null, null);
        LuceneCategoryTest2.assertEquals((int)9, (int)results.length());
        results.close();
        tx.rollback();
    }

    public void testBasic() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        LuceneSearcherImpl2 searcher = LuceneSearcherImpl2.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:MarketingRegion\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:MarketingRegion//member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/member\" ", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/test:Fixed\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/test:Equity\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Fixed\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:*\"", null, null);
        LuceneCategoryTest2.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass//test:*\"", null, null);
        LuceneCategoryTest2.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Fixed/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/test:SpecialEquity/member//.\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/test:SpecialEquity/member//*\"", null, null);
        LuceneCategoryTest2.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/test:SpecialEquity/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/test:AssetClass/test:Equity/member\" AND +PATH:\"/test:AssetClass/test:Fixed/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/member\" PATH:\"/test:AssetClass/test:Fixed/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)13, (int)results.length());
        results.close();
        LuceneCategoryTest2.assertEquals((int)4, (int)this.nodeService.getChildAssocs(this.catRoot).size());
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:Region\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:Region/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:Region/test:Europe/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:Region/test:RestOfWorld/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:Region//member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:InvestmentRegion//member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:MarketingRegion//member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/test:AssetClass/test:Fixed/member\" AND +PATH:\"/test:Region/test:Europe/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/test:Fixed/member\" AND +PATH:\"/cm:categoryContainer/cm:categoryRoot/test:Region/test:Europe/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/test:AssetClass/test:Equity/member\" PATH:\"/test:MarketingRegion/member\"", null, null);
        LuceneCategoryTest2.assertEquals((int)9, (int)results.length());
        results.close();
        tx.rollback();
    }

    public void testCategoryServiceImpl() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        LuceneSearcherImpl2 searcher = LuceneSearcherImpl2.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/*\" ", null, null);
        LuceneCategoryTest2.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/cm:categoryContainer/cm:categoryRoot/test:AssetClass/member\" ", null, null);
        LuceneCategoryTest2.assertEquals((int)1, (int)results.length());
        results.close();
        LuceneCategoryServiceImpl impl = new LuceneCategoryServiceImpl();
        impl.setNodeService(this.nodeService);
        impl.setNamespacePrefixResolver(this.getNamespacePrefixReolsver(""));
        impl.setIndexerAndSearcher(this.indexerAndSearcher);
        impl.setDictionaryService(this.dictionaryService);
        Collection<ChildAssociationRef> result = impl.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE);
        LuceneCategoryTest2.assertEquals((int)1, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE);
        LuceneCategoryTest2.assertEquals((int)3, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE);
        LuceneCategoryTest2.assertEquals((int)2, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY);
        LuceneCategoryTest2.assertEquals((int)18, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.ANY);
        LuceneCategoryTest2.assertEquals((int)21, (int)result.size());
        result = impl.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY);
        LuceneCategoryTest2.assertEquals((int)3, (int)result.size());
        result = impl.getClassifications(this.rootNodeRef.getStoreRef());
        LuceneCategoryTest2.assertEquals((int)4, (int)result.size());
        result = impl.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE);
        LuceneCategoryTest2.assertEquals((int)2, (int)result.size());
        Collection<QName> aspects = impl.getClassificationAspects();
        LuceneCategoryTest2.assertEquals((int)6, (int)aspects.size());
        tx.rollback();
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("test", this.TEST_NAMESPACE);
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    public void testCategoryService() throws Exception {
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        UserTransaction tx = transactionService.getUserTransaction();
        tx.begin();
        this.buildBaseIndex();
        LuceneCategoryTest2.assertEquals((int)1, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)2, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)18, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY).size());
        LuceneCategoryTest2.assertEquals((int)21, (int)this.categoryService.getChildren(this.catACBase, CategoryService.Mode.ALL, CategoryService.Depth.ANY).size());
        LuceneCategoryTest2.assertEquals((int)4, (int)this.categoryService.getClassifications(this.rootNodeRef.getStoreRef()).size());
        LuceneCategoryTest2.assertEquals((int)2, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.ANY).size());
        LuceneCategoryTest2.assertEquals((int)6, (int)this.categoryService.getClassificationAspects().size());
        LuceneCategoryTest2.assertEquals((int)2, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass")).size());
        NodeRef newRoot = this.categoryService.createRootCategory(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), "Fruit");
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass")).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)4, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.ANY).size());
        NodeRef newCat = this.categoryService.createCategory(newRoot, "Banana");
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass")).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)5, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.ANY).size());
        this.categoryService.deleteCategory(newCat);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass")).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)4, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.ANY).size());
        this.categoryService.deleteCategory(newRoot);
        tx.commit();
        tx = transactionService.getUserTransaction();
        tx.begin();
        LuceneCategoryTest2.assertEquals((int)2, (int)this.categoryService.getRootCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass")).size());
        LuceneCategoryTest2.assertEquals((int)2, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.IMMEDIATE).size());
        LuceneCategoryTest2.assertEquals((int)3, (int)this.categoryService.getCategories(this.rootNodeRef.getStoreRef(), QName.createQName(this.TEST_NAMESPACE, "AssetClass"), CategoryService.Depth.ANY).size());
        tx.rollback();
    }

    private int getTotalScore(ResultSet results) {
        int totalScore = 0;
        for (ResultSetRow row : results) {
            totalScore = (int)((float)totalScore + row.getScore());
        }
        return totalScore;
    }
}

