/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer2;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerImpl2;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher2;
import org.alfresco.repo.search.impl.lucene.LuceneSearcherImpl2;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.search.transaction.LuceneIndexLock;
import org.alfresco.repo.search.transaction.SimpleTransaction;
import org.alfresco.repo.search.transaction.SimpleTransactionManager;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.store.Lock;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LuceneIndexerAndSearcherFactory2
implements LuceneIndexerAndSearcher,
XAResource {
    private DictionaryService dictionaryService;
    private NamespaceService nameSpaceService;
    private int queryMaxClauses;
    private int indexerBatchSize;
    private int indexerMinMergeDocs;
    private int indexerMergeFactor;
    private int indexerMaxMergeDocs;
    private String lockDirectory;
    private static Map<Xid, Map<StoreRef, LuceneIndexer2>> activeIndexersInGlobalTx = new HashMap<Xid, Map<StoreRef, LuceneIndexer2>>();
    private static Map<Xid, Map<StoreRef, LuceneIndexer2>> suspendedIndexersInGlobalTx = new HashMap<Xid, Map<StoreRef, LuceneIndexer2>>();
    private static ThreadLocal<Map<StoreRef, LuceneIndexer2>> threadLocalIndexers = new ThreadLocal();
    private int timeout = 600000;
    private static final int DEFAULT_TIMEOUT = 600000;
    private NodeService nodeService;
    private LuceneIndexLock luceneIndexLock;
    private FullTextSearchIndexer luceneFullTextSearchIndexer;
    private String indexRootLocation;
    private ContentService contentService;
    private QueryRegisterComponent queryRegister;
    private long maxAtomicTransformationTime = 20L;
    private int indexerMaxFieldLength;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNameSpaceService(NamespaceService nameSpaceService) {
        this.nameSpaceService = nameSpaceService;
    }

    public void setLuceneIndexLock(LuceneIndexLock luceneIndexLock) {
        this.luceneIndexLock = luceneIndexLock;
    }

    public void setLuceneFullTextSearchIndexer(FullTextSearchIndexer luceneFullTextSearchIndexer) {
        this.luceneFullTextSearchIndexer = luceneFullTextSearchIndexer;
    }

    public void setIndexRootLocation(String indexRootLocation) {
        this.indexRootLocation = indexRootLocation;
    }

    public void setQueryRegister(QueryRegisterComponent queryRegister) {
        this.queryRegister = queryRegister;
    }

    public void setMaxAtomicTransformationTime(long maxAtomicTransformationTime) {
        this.maxAtomicTransformationTime = maxAtomicTransformationTime;
    }

    private boolean inGlobalTransaction() {
        try {
            return SimpleTransactionManager.getInstance().getTransaction() != null;
        }
        catch (SystemException e) {
            return false;
        }
    }

    private SimpleTransaction getTransaction() throws IndexerException {
        try {
            return SimpleTransactionManager.getInstance().getTransaction();
        }
        catch (SystemException e) {
            throw new IndexerException("Failed to get transaction", e);
        }
    }

    public LuceneIndexer2 getIndexer(StoreRef storeRef) throws IndexerException {
        AlfrescoTransactionSupport.bindLucene(this);
        if (this.inGlobalTransaction()) {
            LuceneIndexer2 indexer;
            SimpleTransaction tx = this.getTransaction();
            Map<StoreRef, LuceneIndexer2> indexers = activeIndexersInGlobalTx.get(tx);
            if (indexers == null) {
                if (suspendedIndexersInGlobalTx.containsKey(tx)) {
                    throw new IndexerException("Trying to obtain an index for a suspended transaction.");
                }
                indexers = new HashMap<StoreRef, LuceneIndexer2>();
                activeIndexersInGlobalTx.put(tx, indexers);
                try {
                    tx.enlistResource(this);
                }
                catch (IllegalStateException e) {
                    throw new IndexerException("", e);
                }
                catch (RollbackException e) {
                    throw new IndexerException("", e);
                }
                catch (SystemException e) {
                    throw new IndexerException("", e);
                }
            }
            if ((indexer = indexers.get(storeRef)) == null) {
                indexer = this.createIndexer(storeRef, LuceneIndexerAndSearcherFactory2.getTransactionId(tx, storeRef));
                indexers.put(storeRef, indexer);
            }
            return indexer;
        }
        return this.getThreadLocalIndexer(storeRef);
    }

    private LuceneIndexer2 getThreadLocalIndexer(StoreRef storeRef) {
        LuceneIndexer2 indexer;
        Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
        if (indexers == null) {
            indexers = new HashMap<StoreRef, LuceneIndexer2>();
            threadLocalIndexers.set(indexers);
        }
        if ((indexer = indexers.get(storeRef)) == null) {
            indexer = this.createIndexer(storeRef, GUID.generate());
            indexers.put(storeRef, indexer);
        }
        return indexer;
    }

    private static String getTransactionId(Transaction tx, StoreRef storeRef) {
        LuceneIndexer2 indexer;
        if (tx instanceof SimpleTransaction) {
            SimpleTransaction simpleTx = (SimpleTransaction)tx;
            return simpleTx.getGUID();
        }
        Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
        if (indexers != null && (indexer = indexers.get(storeRef)) != null) {
            return indexer.getDeltaId();
        }
        return null;
    }

    private LuceneIndexerImpl2 createIndexer(StoreRef storeRef, String deltaId) {
        LuceneIndexerImpl2 indexer = LuceneIndexerImpl2.getUpdateIndexer(storeRef, deltaId, this);
        indexer.setNodeService(this.nodeService);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFullTextSearchIndexer);
        indexer.setContentService(this.contentService);
        indexer.setMaxAtomicTransformationTime(this.maxAtomicTransformationTime);
        return indexer;
    }

    public LuceneSearcher2 getSearcher(StoreRef storeRef, boolean searchDelta) throws SearcherException {
        String deltaId = null;
        LuceneIndexer2 indexer = null;
        if (searchDelta && (deltaId = LuceneIndexerAndSearcherFactory2.getTransactionId(this.getTransaction(), storeRef)) != null) {
            indexer = this.getIndexer(storeRef);
        }
        LuceneSearcher2 searcher = this.getSearcher(storeRef, indexer);
        return searcher;
    }

    private LuceneSearcher2 getSearcher(StoreRef storeRef, LuceneIndexer2 indexer) throws SearcherException {
        LuceneSearcherImpl2 searcher = LuceneSearcherImpl2.getSearcher(storeRef, indexer, this);
        searcher.setNamespacePrefixResolver(this.nameSpaceService);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setQueryRegister(this.queryRegister);
        return searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            Map<StoreRef, LuceneIndexer2> indexers = activeIndexersInGlobalTx.get(xid);
            if (indexers == null) {
                if (suspendedIndexersInGlobalTx.containsKey(xid)) {
                    throw new XAException("Trying to commit indexes for a suspended transaction.");
                }
                return;
            }
            if (onePhase) {
                if (indexers.size() == 0) {
                    return;
                }
                if (indexers.size() == 1) {
                    for (LuceneIndexer2 indexer : indexers.values()) {
                        indexer.commit();
                    }
                    return;
                }
                throw new XAException("Trying to do one phase commit on more than one index");
            }
            for (LuceneIndexer2 indexer : indexers.values()) {
                indexer.commit();
            }
            return;
        }
        finally {
            activeIndexersInGlobalTx.remove(xid);
        }
    }

    public void end(Xid xid, int flag) throws XAException {
        Map<StoreRef, LuceneIndexer2> indexers = activeIndexersInGlobalTx.get(xid);
        if (indexers == null) {
            if (suspendedIndexersInGlobalTx.containsKey(xid)) {
                throw new XAException("Trying to commit indexes for a suspended transaction.");
            }
            return;
        }
        if (flag == 0x2000000) {
            activeIndexersInGlobalTx.remove(xid);
            suspendedIndexersInGlobalTx.put(xid, indexers);
        } else if (flag == 0x20000000) {
            activeIndexersInGlobalTx.remove(xid);
            suspendedIndexersInGlobalTx.remove(xid);
        } else if (flag == 0x4000000) {
            activeIndexersInGlobalTx.remove(xid);
        }
    }

    public void forget(Xid xid) throws XAException {
        activeIndexersInGlobalTx.remove(xid);
        suspendedIndexersInGlobalTx.remove(xid);
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    public boolean isSameRM(XAResource xar) throws XAException {
        return xar instanceof LuceneIndexerAndSearcherFactory2;
    }

    public int prepare(Xid xid) throws XAException {
        Map<StoreRef, LuceneIndexer2> indexers = activeIndexersInGlobalTx.get(xid);
        if (indexers == null) {
            if (suspendedIndexersInGlobalTx.containsKey(xid)) {
                throw new XAException("Trying to commit indexes for a suspended transaction.");
            }
            return 0;
        }
        boolean isPrepared = true;
        boolean isModified = false;
        for (LuceneIndexer2 indexer : indexers.values()) {
            try {
                isModified |= indexer.isModified();
                indexer.prepare();
            }
            catch (IndexerException e) {
                isPrepared = false;
            }
        }
        if (isPrepared) {
            if (isModified) {
                return 0;
            }
            return 3;
        }
        throw new XAException("Failed to prepare: requires rollback");
    }

    public Xid[] recover(int arg0) throws XAException {
        return new Xid[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Xid xid) throws XAException {
        try {
            Map<StoreRef, LuceneIndexer2> indexers = activeIndexersInGlobalTx.get(xid);
            if (indexers == null) {
                if (suspendedIndexersInGlobalTx.containsKey(xid)) {
                    throw new XAException("Trying to commit indexes for a suspended transaction.");
                }
                return;
            }
            for (LuceneIndexer2 indexer : indexers.values()) {
                indexer.rollback();
            }
        }
        finally {
            activeIndexersInGlobalTx.remove(xid);
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout = timeout;
        return true;
    }

    public void start(Xid xid, int flag) throws XAException {
        Map<StoreRef, LuceneIndexer2> active = activeIndexersInGlobalTx.get(xid);
        Map<StoreRef, LuceneIndexer2> suspended = suspendedIndexersInGlobalTx.get(xid);
        if (flag == 0x200000) {
            if (active != null && suspended == null) {
                return;
            }
            throw new XAException("Trying to rejoin transaction in an invalid state");
        }
        if (flag == 0x8000000) {
            if (active == null && suspended != null) {
                suspendedIndexersInGlobalTx.remove(xid);
                activeIndexersInGlobalTx.put(xid, suspended);
                return;
            }
            throw new XAException("Trying to rejoin transaction in an invalid state");
        }
        if (flag == 0) {
            if (active == null && suspended == null) {
                return;
            }
            throw new XAException("Trying to start an existing or suspended transaction");
        }
        throw new XAException("Unkown flags for start " + flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws IndexerException {
        try {
            Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
            if (indexers == null) return;
            for (LuceneIndexer2 indexer : indexers.values()) {
                try {
                    indexer.commit();
                }
                catch (IndexerException e) {
                    this.rollback();
                    throw e;
                    return;
                }
            }
        }
        finally {
            if (threadLocalIndexers.get() != null) {
                threadLocalIndexers.get().clear();
                threadLocalIndexers.set(null);
            }
        }
    }

    public int prepare() throws IndexerException {
        boolean isPrepared = true;
        boolean isModified = false;
        Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
        if (indexers != null) {
            for (LuceneIndexer2 indexer : indexers.values()) {
                try {
                    isModified |= indexer.isModified();
                    indexer.prepare();
                }
                catch (IndexerException e) {
                    isPrepared = false;
                    throw new IndexerException("Failed to prepare: requires rollback", (Throwable)((Object)e));
                }
            }
        }
        if (isPrepared) {
            if (isModified) {
                return 0;
            }
            return 3;
        }
        throw new IndexerException("Failed to prepare: requires rollback");
    }

    public void rollback() {
        Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
        if (indexers != null) {
            for (LuceneIndexer2 indexer : indexers.values()) {
                try {
                    indexer.rollback();
                }
                catch (IndexerException e) {}
            }
        }
        if (threadLocalIndexers.get() != null) {
            threadLocalIndexers.get().clear();
            threadLocalIndexers.set(null);
        }
    }

    public void flush() {
        Map<StoreRef, LuceneIndexer2> indexers = threadLocalIndexers.get();
        if (indexers != null) {
            for (LuceneIndexer2 indexer : indexers.values()) {
                indexer.flushPending();
            }
        }
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public String getIndexRootLocation() {
        return this.indexRootLocation;
    }

    public int getIndexerBatchSize() {
        return this.indexerBatchSize;
    }

    public void setIndexerBatchSize(int indexerBatchSize) {
        this.indexerBatchSize = indexerBatchSize;
    }

    public int getIndexerMaxMergeDocs() {
        return this.indexerMaxMergeDocs;
    }

    public void setIndexerMaxMergeDocs(int indexerMaxMergeDocs) {
        this.indexerMaxMergeDocs = indexerMaxMergeDocs;
    }

    public int getIndexerMergeFactor() {
        return this.indexerMergeFactor;
    }

    public void setIndexerMergeFactor(int indexerMergeFactor) {
        this.indexerMergeFactor = indexerMergeFactor;
    }

    public int getIndexerMinMergeDocs() {
        return this.indexerMinMergeDocs;
    }

    public void setIndexerMinMergeDocs(int indexerMinMergeDocs) {
        this.indexerMinMergeDocs = indexerMinMergeDocs;
    }

    public String getLockDirectory() {
        return this.lockDirectory;
    }

    public void setLockDirectory(String lockDirectory) {
        File[] children;
        this.lockDirectory = lockDirectory;
        System.setProperty("org.apache.lucene.lockdir", lockDirectory);
        File lockDir = new File(lockDirectory);
        if (!lockDir.exists()) {
            lockDir.mkdirs();
        }
        if ((children = lockDir.listFiles()) != null) {
            for (int i = 0; i < children.length; ++i) {
                File child = children[i];
                if (!child.isFile() || !child.exists() || child.delete() || !child.exists()) continue;
                throw new IllegalStateException("Failed to delete " + child);
            }
        }
    }

    public int getQueryMaxClauses() {
        return this.queryMaxClauses;
    }

    public void setQueryMaxClauses(int queryMaxClauses) {
        this.queryMaxClauses = queryMaxClauses;
        BooleanQuery.setMaxClauseCount((int)this.queryMaxClauses);
    }

    public void setWriteLockTimeout(long timeout) {
        IndexWriter.WRITE_LOCK_TIMEOUT = timeout;
    }

    public void setCommitLockTimeout(long timeout) {
        IndexWriter.COMMIT_LOCK_TIMEOUT = timeout;
    }

    public void setLockPollInterval(long time) {
        Lock.LOCK_POLL_INTERVAL = time;
    }

    public int getIndexerMaxFieldLength() {
        return this.indexerMaxFieldLength;
    }

    public void setIndexerMaxFieldLength(int indexerMaxFieldLength) {
        this.indexerMaxFieldLength = indexerMaxFieldLength;
        System.setProperty("org.apache.lucene.maxFieldLength", "" + indexerMaxFieldLength);
    }

    public static class LuceneIndexBackupJob
    implements Job {
        public static final String KEY_LUCENE_INDEX_BACKUP_COMPONENT = "luceneIndexBackupComponent";

        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap jobData = context.getJobDetail().getJobDataMap();
            LuceneIndexBackupComponent backupComponent = (LuceneIndexBackupComponent)jobData.get((Object)KEY_LUCENE_INDEX_BACKUP_COMPONENT);
            if (backupComponent == null) {
                throw new JobExecutionException("Missing job data: luceneIndexBackupComponent");
            }
            backupComponent.backup();
        }
    }

    public static class LuceneIndexBackupComponent {
        private static Log logger = LogFactory.getLog(LuceneIndexerAndSearcherFactory2.class);
        private TransactionService transactionService;
        private LuceneIndexerAndSearcherFactory2 factory;
        private NodeService nodeService;
        private String targetLocation;

        public void setTransactionService(TransactionService transactionService) {
            this.transactionService = transactionService;
        }

        public void setFactory(LuceneIndexerAndSearcherFactory2 factory) {
            this.factory = factory;
        }

        public void setNodeService(NodeService nodeService) {
            this.nodeService = nodeService;
        }

        public void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        public void backup() {
            TransactionUtil.TransactionWork<Object> backupWork = new TransactionUtil.TransactionWork<Object>(){

                @Override
                public Object doWork() throws Exception {
                    LuceneIndexBackupComponent.this.backupImpl();
                    return null;
                }
            };
            TransactionUtil.executeInUserTransaction(this.transactionService, backupWork);
        }

        private void backupImpl() {
            File targetDir = new File(this.targetLocation);
            if (targetDir.exists() && !targetDir.isDirectory()) {
                throw new AlfrescoRuntimeException("Target location is a file and not a directory: " + targetDir);
            }
            File targetParentDir = targetDir.getParentFile();
            if (targetParentDir == null) {
                throw new AlfrescoRuntimeException("Target location may not be a root directory: " + targetDir);
            }
            File tempDir = new File(targetParentDir, "indexbackup_temp");
            List<StoreRef> storeRefs = this.nodeService.getStores();
            ArrayList<StoreRef> lockedStores = new ArrayList<StoreRef>(storeRefs.size());
            try {
                for (StoreRef storeRef : storeRefs) {
                    this.factory.luceneIndexLock.getWriteLock(storeRef);
                    lockedStores.add(storeRef);
                }
                File indexRootDir = new File(this.factory.indexRootLocation);
                this.backupDirectory(indexRootDir, tempDir, targetDir);
            }
            catch (Throwable e) {
                try {
                    throw new AlfrescoRuntimeException("Failed to copy Lucene index root: \n   Index root: " + this.factory.indexRootLocation + "\n" + "   Target: " + targetDir, e);
                }
                catch (Throwable throwable) {
                    for (StoreRef storeRef : lockedStores) {
                        try {
                            this.factory.luceneIndexLock.releaseWriteLock(storeRef);
                        }
                        catch (Throwable e2) {
                            logger.error((Object)("Failed to release index lock for store " + storeRef), e2);
                        }
                    }
                    throw throwable;
                }
            }
            for (StoreRef storeRef : lockedStores) {
                try {
                    this.factory.luceneIndexLock.releaseWriteLock(storeRef);
                }
                catch (Throwable e) {
                    logger.error((Object)("Failed to release index lock for store " + storeRef), e);
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Backed up Lucene indexes: \n   Target directory: " + targetDir));
            }
        }

        private void backupDirectory(File sourceDir, File tempDir, File targetDir) throws Exception {
            if (!sourceDir.exists()) {
                return;
            }
            if (tempDir.exists()) {
                FileUtils.deleteDirectory((File)tempDir);
                if (tempDir.exists()) {
                    throw new AlfrescoRuntimeException("Temp directory exists and cannot be deleted: " + tempDir);
                }
            }
            FileUtils.copyDirectory((File)sourceDir, (File)tempDir, (boolean)true);
            if (!tempDir.exists()) {
                throw new AlfrescoRuntimeException("Copy to temp location failed");
            }
            FileUtils.deleteDirectory((File)targetDir);
            if (targetDir.exists()) {
                throw new AlfrescoRuntimeException("Failed to delete older files from target location");
            }
            tempDir.renameTo(targetDir);
            if (!targetDir.exists()) {
                throw new AlfrescoRuntimeException("Failed to rename temporary directory to target backup directory");
            }
        }
    }
}

