/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.LuceneBase2;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer2;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRow;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.ISO9075;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.TermQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneIndexerImpl2
extends LuceneBase2
implements LuceneIndexer2 {
    public static final String NOT_INDEXED_NO_TRANSFORMATION = "nint";
    public static final String NOT_INDEXED_TRANSFORMATION_FAILED = "nitf";
    public static final String NOT_INDEXED_CONTENT_MISSING = "nicm";
    private static Logger s_logger = Logger.getLogger(LuceneIndexerImpl2.class);
    private NodeService nodeService;
    private ContentService contentService;
    private long maxAtomicTransformationTime = 20L;
    private Set<NodeRef> deletions = new LinkedHashSet<NodeRef>();
    private long docs;
    private int status = 5;
    private boolean isModified = false;
    private Boolean isFTSUpdate = null;
    private List<Command> commandList = new ArrayList<Command>(10000);
    private FTSIndexerAware callBack;
    private int remainingCount = 0;
    private ArrayList<Helper> toFTSIndex = new ArrayList();
    private FullTextSearchIndexer luceneFullTextSearchIndexer;

    LuceneIndexerImpl2() {
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        super.setDictionaryService(dictionaryService);
    }

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setMaxAtomicTransformationTime(long maxAtomicTransformationTime) {
        this.maxAtomicTransformationTime = maxAtomicTransformationTime;
    }

    private void checkAbleToDoWork(boolean isFTS, boolean isModified) {
        if (this.isFTSUpdate == null) {
            this.isFTSUpdate = isFTS;
        } else if (isFTS != this.isFTSUpdate) {
            throw new IndexerException("Can not mix FTS and transactional updates");
        }
        switch (this.status) {
            case 5: {
                this.status = 0;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new IndexerException(this.buildErrorString());
            }
        }
        this.isModified = isModified;
    }

    private String buildErrorString() {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("The indexer is unable to accept more work: ");
        switch (this.status) {
            case 3: {
                buffer.append("The indexer has been committed");
                break;
            }
            case 8: {
                buffer.append("The indexer is committing");
                break;
            }
            case 1: {
                buffer.append("The indexer is marked for rollback");
                break;
            }
            case 2: {
                buffer.append("The indexer is prepared to commit");
                break;
            }
            case 7: {
                buffer.append("The indexer is preparing to commit");
                break;
            }
            case 4: {
                buffer.append("The indexer has been rolled back");
                break;
            }
            case 9: {
                buffer.append("The indexer is rolling back");
                break;
            }
            case 5: {
                buffer.append("The indexer is in an unknown state");
                break;
            }
        }
        return buffer.toString();
    }

    @Override
    public void createNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(false, true);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            if (relationshipRef.getParentRef() == null && childRef.equals(this.nodeService.getRootNode(childRef.getStoreRef()))) {
                this.addRootNodesToDeletionList();
                s_logger.warn((Object)"Detected root node addition: deleting all nodes from the index");
            }
            this.index(childRef);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Create node failed", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRootNodesToDeletionList() {
        IndexReader mainReader = null;
        try {
            try {
                mainReader = this.getReader();
                TermDocs td = mainReader.termDocs(new Term("ISROOT", "T"));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = mainReader.document(doc);
                    String id = document.get("ID");
                    NodeRef ref = new NodeRef(id);
                    this.deleteImpl(ref, false, true, mainReader);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete all primary nodes", e);
            }
        }
        finally {
            if (mainReader != null) {
                try {
                    mainReader.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
            }
        }
    }

    @Override
    public void updateNode(NodeRef nodeRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update node " + nodeRef));
        }
        this.checkAbleToDoWork(false, true);
        try {
            this.reindex(nodeRef, false);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Update node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteNode(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(false, true);
        try {
            this.delete(relationshipRef.getChildRef());
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Delete node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void createChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create child " + relationshipRef));
        }
        this.checkAbleToDoWork(false, true);
        try {
            this.reindex(relationshipRef.getChildRef(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to create child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void updateChildRelationship(ChildAssociationRef relationshipBeforeRef, ChildAssociationRef relationshipAfterRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update child " + relationshipBeforeRef + " to " + relationshipAfterRef));
        }
        this.checkAbleToDoWork(false, true);
        try {
            if (relationshipBeforeRef.getParentRef() != null) {
                // empty if block
            }
            this.reindex(relationshipBeforeRef.getChildRef(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to update child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteChildRelationship(ChildAssociationRef relationshipRef) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete child " + relationshipRef));
        }
        this.checkAbleToDoWork(false, true);
        try {
            if (relationshipRef.getParentRef() != null) {
                // empty if block
            }
            this.reindex(relationshipRef.getChildRef(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to delete child relationship", (Throwable)((Object)e));
        }
    }

    public static LuceneIndexerImpl2 getUpdateIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        LuceneIndexerImpl2 indexer = new LuceneIndexerImpl2();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId, false, true);
        return indexer;
    }

    @Override
    public void commit() throws LuceneIndexException {
        switch (this.status) {
            case 8: {
                throw new LuceneIndexException("Unable to commit: Transaction is committing");
            }
            case 3: {
                throw new LuceneIndexException("Unable to commit: Transaction is commited ");
            }
            case 9: {
                throw new LuceneIndexException("Unable to commit: Transaction is rolling back");
            }
            case 4: {
                throw new LuceneIndexException("Unable to commit: Transaction is aleady rolled back");
            }
            case 1: {
                throw new LuceneIndexException("Unable to commit: Transaction is marked for roll back");
            }
            case 7: {
                throw new LuceneIndexException("Unable to commit: Transaction is preparing");
            }
            case 0: {
                this.prepare();
            }
        }
        if (this.status != 2) {
            throw new LuceneIndexException("Index must be prepared to commit");
        }
        this.status = 8;
        try {
            this.setStatus(TransactionStatus.COMMITTING);
            if (this.isModified()) {
                if (this.isFTSUpdate.booleanValue()) {
                    this.doFTSIndexCommit();
                } else {
                    this.setInfo(this.docs, this.deletions, false);
                    this.luceneFullTextSearchIndexer.requiresIndex(this.store);
                }
            }
            this.status = 3;
            if (this.callBack != null) {
                this.callBack.indexCompleted(this.store, this.remainingCount, null);
            }
            this.setStatus(TransactionStatus.COMMITTED);
        }
        catch (IOException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", e);
        }
        catch (LuceneIndexException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFTSIndexCommit() throws LuceneIndexException {
        IndexReader mainReader = null;
        IndexReader deltaReader = null;
        IndexSearcher mainSearcher = null;
        IndexSearcher deltaSearcher = null;
        try {
            Object e22;
            block25: {
                try {
                    mainReader = this.getReader();
                    deltaReader = this.getDeltaReader();
                    mainSearcher = new IndexSearcher(mainReader);
                    deltaSearcher = new IndexSearcher(deltaReader);
                    for (Helper helper : this.toFTSIndex) {
                        this.deletions.add(helper.nodeRef);
                    }
                    Object var8_9 = null;
                    if (deltaSearcher == null) break block25;
                }
                catch (Throwable throwable) {
                    Object e22;
                    Object var8_10 = null;
                    if (deltaSearcher != null) {
                        try {
                            deltaSearcher.close();
                        }
                        catch (IOException e22) {
                            s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                        }
                    }
                    if (mainSearcher != null) {
                        try {
                            mainSearcher.close();
                        }
                        catch (IOException e22) {
                            s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                        }
                    }
                    try {
                        this.closeDeltaReader();
                    }
                    catch (LuceneIndexException e22) {
                        s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
                    }
                    if (mainReader != null) {
                        try {
                            mainReader.close();
                        }
                        catch (IOException e22) {
                            s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                        }
                    }
                    throw throwable;
                }
                try {
                    deltaSearcher.close();
                }
                catch (IOException e22) {
                    s_logger.warn((Object)"Failed to close delta searcher", (Throwable)e22);
                }
            }
            if (mainSearcher != null) {
                try {
                    mainSearcher.close();
                }
                catch (IOException e22) {
                    s_logger.warn((Object)"Failed to close main searcher", (Throwable)e22);
                }
            }
            try {
                this.closeDeltaReader();
            }
            catch (LuceneIndexException e22) {
                s_logger.warn((Object)"Failed to close delta reader", (Throwable)e22);
            }
            if (mainReader != null) {
                try {
                    mainReader.close();
                }
                catch (IOException e22) {
                    s_logger.warn((Object)"Failed to close main reader", (Throwable)e22);
                }
            }
            this.setInfo(this.docs, this.deletions, true);
        }
        catch (IOException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", e);
        }
        catch (LuceneIndexException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", (Throwable)((Object)e));
        }
    }

    @Override
    public int prepare() throws LuceneIndexException {
        switch (this.status) {
            case 8: {
                throw new IndexerException("Unable to prepare: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to prepare: Transaction is commited ");
            }
            case 9: {
                throw new IndexerException("Unable to prepare: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to prepare: Transaction is aleady rolled back");
            }
            case 1: {
                throw new IndexerException("Unable to prepare: Transaction is marked for roll back");
            }
            case 7: {
                throw new IndexerException("Unable to prepare: Transaction is already preparing");
            }
            case 2: {
                throw new IndexerException("Unable to prepare: Transaction is already prepared");
            }
        }
        this.status = 7;
        try {
            this.setStatus(TransactionStatus.PREPARING);
            if (this.isModified()) {
                this.saveDelta();
                this.flushPending();
            }
            this.status = 2;
            this.setStatus(TransactionStatus.PREPARED);
            return this.isModified ? 0 : 3;
        }
        catch (IOException e) {
            this.rollback();
            throw new LuceneIndexException("Commit failed", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Index failed to prepare", (Throwable)((Object)e));
        }
    }

    @Override
    public boolean isModified() {
        return this.isModified;
    }

    public int getStatus() {
        return this.status;
    }

    @Override
    public void rollback() throws LuceneIndexException {
        switch (this.status) {
            case 3: {
                throw new IndexerException("Unable to roll back: Transaction is committed ");
            }
            case 9: {
                throw new IndexerException("Unable to roll back: Transaction is rolling back");
            }
            case 4: {
                throw new IndexerException("Unable to roll back: Transaction is already rolled back");
            }
        }
        this.status = 9;
        try {
            this.setStatus(TransactionStatus.ROLLINGBACK);
            this.setStatus(TransactionStatus.ROLLEDBACK);
        }
        catch (IOException e) {
            throw new LuceneIndexException("roolback failed ", e);
        }
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, 0, null);
        }
    }

    public void setRollbackOnly() {
        switch (this.status) {
            case 8: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committing");
            }
            case 3: {
                throw new IndexerException("Unable to mark for rollback: Transaction is committed");
            }
        }
        this.status = 1;
    }

    private void index(NodeRef nodeRef) throws LuceneIndexException {
        this.addCommand(new Command(nodeRef, Action.INDEX));
    }

    private void reindex(NodeRef nodeRef, boolean cascadeReindexDirectories) throws LuceneIndexException {
        this.addCommand(new Command(nodeRef, cascadeReindexDirectories ? Action.CASCADEREINDEX : Action.REINDEX));
    }

    private void delete(NodeRef nodeRef) throws LuceneIndexException {
        this.addCommand(new Command(nodeRef, Action.DELETE));
    }

    private void addCommand(Command command) {
        if (this.commandList.size() > 0) {
            Command last = this.commandList.get(this.commandList.size() - 1);
            if (last.action == command.action && last.nodeRef.equals(command.nodeRef)) {
                return;
            }
        }
        this.purgeCommandList(command);
        this.commandList.add(command);
        if (this.commandList.size() > this.getLuceneConfig().getIndexerBatchSize()) {
            this.flushPending();
        }
    }

    private void purgeCommandList(Command command) {
        if (command.action == Action.DELETE) {
            this.removeFromCommandList(command, false);
        } else if (command.action == Action.REINDEX) {
            this.removeFromCommandList(command, true);
        } else if (command.action == Action.INDEX) {
            this.removeFromCommandList(command, true);
        } else if (command.action == Action.CASCADEREINDEX) {
            this.removeFromCommandList(command, true);
        }
    }

    private void removeFromCommandList(Command command, boolean matchExact) {
        ListIterator<Command> it = this.commandList.listIterator(this.commandList.size());
        while (it.hasPrevious()) {
            Command current = it.previous();
            if (matchExact) {
                if (current.action != command.action || !current.nodeRef.equals(command.nodeRef)) continue;
                it.remove();
                return;
            }
            if (!current.nodeRef.equals(command.nodeRef)) continue;
            it.remove();
        }
    }

    @Override
    public void flushPending() throws LuceneIndexException {
        IndexReader mainReader = null;
        try {
            mainReader = this.getReader();
            LinkedHashSet<NodeRef> forIndex = new LinkedHashSet<NodeRef>();
            for (Command command : this.commandList) {
                Set<NodeRef> set;
                if (command.action == Action.INDEX) {
                    forIndex.add(command.nodeRef);
                    continue;
                }
                if (command.action == Action.REINDEX) {
                    set = this.deleteImpl(command.nodeRef, true, false, mainReader);
                    forIndex.removeAll(set);
                    forIndex.addAll(set);
                    continue;
                }
                if (command.action == Action.CASCADEREINDEX) {
                    set = this.deleteImpl(command.nodeRef, true, true, mainReader);
                    forIndex.removeAll(set);
                    forIndex.addAll(set);
                    continue;
                }
                if (command.action != Action.DELETE) continue;
                set = this.deleteImpl(command.nodeRef, false, true, mainReader);
                forIndex.removeAll(set);
            }
            this.commandList.clear();
            this.indexImpl(forIndex, false);
            this.docs = this.getDeltaWriter().docCount();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to flush index", e);
        }
        finally {
            if (mainReader != null) {
                try {
                    mainReader.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
            }
            try {
                this.closeDeltaReader();
            }
            catch (IOException e) {}
            try {
                this.closeDeltaWriter();
            }
            catch (IOException e) {}
        }
    }

    private Set<NodeRef> deleteImpl(NodeRef nodeRef, boolean forReindex, boolean cascade, IndexReader mainReader) throws LuceneIndexException, IOException {
        this.getDeltaReader();
        LinkedHashSet<NodeRef> refs = new LinkedHashSet<NodeRef>();
        refs.addAll(this.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade));
        refs.addAll(this.deleteContainerAndBelow(nodeRef, mainReader, false, cascade));
        if (!forReindex) {
            LinkedHashSet<NodeRef> leafrefs = new LinkedHashSet<NodeRef>();
            leafrefs.addAll(this.deletePrimary(refs, this.getDeltaReader(), true));
            leafrefs.addAll(this.deletePrimary(refs, mainReader, false));
            leafrefs.addAll(this.deleteReference(refs, this.getDeltaReader(), true));
            leafrefs.addAll(this.deleteReference(refs, mainReader, false));
            refs.addAll(leafrefs);
        }
        this.deletions.addAll(refs);
        return refs;
    }

    private Set<NodeRef> deletePrimary(Collection<NodeRef> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<NodeRef> refs = new LinkedHashSet<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PRIMARYPARENT", nodeRef.toString()));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String id = document.get("ID");
                    NodeRef ref = new NodeRef(id);
                    refs.add(ref);
                    if (!delete) continue;
                    reader.delete(doc);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by primary parent for " + nodeRef.toString(), e);
            }
        }
        return refs;
    }

    private Set<NodeRef> deleteReference(Collection<NodeRef> nodeRefs, IndexReader reader, boolean delete) throws LuceneIndexException {
        LinkedHashSet<NodeRef> refs = new LinkedHashSet<NodeRef>();
        for (NodeRef nodeRef : nodeRefs) {
            try {
                TermDocs td = reader.termDocs(new Term("PARENT", nodeRef.toString()));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String id = document.get("ID");
                    NodeRef ref = new NodeRef(id);
                    refs.add(ref);
                    if (!delete) continue;
                    reader.delete(doc);
                }
            }
            catch (IOException e) {
                throw new LuceneIndexException("Failed to delete node by parent for " + nodeRef.toString(), e);
            }
        }
        return refs;
    }

    private Set<NodeRef> deleteContainerAndBelow(NodeRef nodeRef, IndexReader reader, boolean delete, boolean cascade) throws LuceneIndexException {
        LinkedHashSet<NodeRef> refs = new LinkedHashSet<NodeRef>();
        try {
            if (delete) {
                reader.delete(new Term("ID", nodeRef.toString()));
            }
            refs.add(nodeRef);
            if (cascade) {
                TermDocs td = reader.termDocs(new Term("ANCESTOR", nodeRef.toString()));
                while (td.next()) {
                    int doc = td.doc();
                    Document document = reader.document(doc);
                    String id = document.get("ID");
                    NodeRef ref = new NodeRef(id);
                    refs.add(ref);
                    if (!delete) continue;
                    reader.delete(doc);
                }
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete container and below for " + nodeRef.toString(), e);
        }
        return refs;
    }

    private void indexImpl(Set<NodeRef> nodeRefs, boolean isNew) throws LuceneIndexException, IOException {
        for (NodeRef ref : nodeRefs) {
            this.indexImpl(ref, isNew);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexImpl(NodeRef nodeRef, boolean isNew) throws LuceneIndexException, IOException {
        IndexWriter writer = this.getDeltaWriter();
        try {
            List<Document> docs = this.createDocuments(nodeRef, isNew, false, true);
            for (Document doc : docs) {
                try {
                    writer.addDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to add document to index", e);
                    return;
                }
            }
        }
        catch (InvalidNodeRefException e) {
            return;
        }
    }

    private List<Document> createDocuments(NodeRef nodeRef, boolean isNew, boolean indexAllProperties, boolean includeDirectoryDocuments) {
        Map<ChildAssociationRef, Counter> nodeCounts = this.getNodeCounts(nodeRef);
        ArrayList<Document> docs = new ArrayList<Document>();
        ChildAssociationRef qNameRef = null;
        Map<QName, Serializable> properties = this.nodeService.getProperties(nodeRef);
        NodeRef.Status nodeStatus = this.nodeService.getNodeStatus(nodeRef);
        List<Path> directPaths = this.nodeService.getPaths(nodeRef, false);
        Collection<Pair<Path, QName>> categoryPaths = this.getCategoryPaths(nodeRef, properties);
        ArrayList<Pair<Path, Object>> paths = new ArrayList<Pair<Path, Object>>(directPaths.size() + categoryPaths.size());
        for (Path path : directPaths) {
            paths.add(new Pair<Path, Object>(path, null));
        }
        paths.addAll(categoryPaths);
        Document xdoc = new Document();
        xdoc.add(new Field("ID", nodeRef.toString(), true, true, false));
        xdoc.add(new Field("TX", nodeStatus.getChangeTxnId(), true, true, false));
        boolean isAtomic = true;
        for (QName propertyName : properties.keySet()) {
            Serializable value = properties.get(propertyName);
            if (indexAllProperties) {
                this.indexProperty(nodeRef, propertyName, value, xdoc, false);
                continue;
            }
            isAtomic &= this.indexProperty(nodeRef, propertyName, value, xdoc, true);
        }
        boolean isRoot = nodeRef.equals(this.nodeService.getRootNode(nodeRef.getStoreRef()));
        StringBuilder qNameBuffer = new StringBuilder(64);
        for (Pair pair : paths) {
            qNameRef = this.getLastRefOrNull((Path)pair.getFirst());
            String pathString = ((Path)pair.getFirst()).toString();
            if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                pathString = pathString.substring(1);
            }
            if (isRoot || ((Path)pair.getFirst()).size() == 1) continue;
            Counter counter = nodeCounts.get(qNameRef);
            if ((counter == null || counter.getRepeat() < counter.getCountInParent()) && qNameRef != null && qNameRef.getParentRef() != null && qNameRef.getQName() != null) {
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName(qNameRef.getQName()));
                xdoc.add(new Field("PARENT", qNameRef.getParentRef().toString(), true, true, false));
                xdoc.add(new Field("ASSOCTYPEQNAME", ISO9075.getXPathName(qNameRef.getTypeQName()), true, false, false));
                xdoc.add(new Field("LINKASPECT", pair.getSecond() == null ? "" : ISO9075.getXPathName((QName)pair.getSecond()), true, true, false));
            }
            if (counter != null) {
                counter.increment();
            }
            QName nodeTypeRef = this.nodeService.getType(nodeRef);
            TypeDefinition nodeTypeDef = this.getDictionaryService().getType(nodeTypeRef);
            if (!includeDirectoryDocuments || nodeTypeDef.getChildAssociations().size() <= 0 || !directPaths.contains(pair.getFirst())) continue;
            Document directoryEntry = new Document();
            directoryEntry.add(new Field("ID", nodeRef.toString(), true, true, false));
            directoryEntry.add(new Field("PATH", pathString, true, true, true));
            for (NodeRef parent : this.getParents((Path)pair.getFirst())) {
                directoryEntry.add(new Field("ANCESTOR", parent.toString(), false, true, false));
            }
            directoryEntry.add(new Field("ISCONTAINER", "T", true, true, false));
            if (this.isCategory(this.getDictionaryService().getType(this.nodeService.getType(nodeRef)))) {
                directoryEntry.add(new Field("ISCATEGORY", "T", true, true, false));
            }
            docs.add(directoryEntry);
        }
        if (isRoot) {
            xdoc.add(new Field("ISCONTAINER", "T", true, true, false));
            xdoc.add(new Field("PATH", "", true, true, true));
            xdoc.add(new Field("QNAME", "", true, true, true));
            xdoc.add(new Field("ISROOT", "T", false, true, false));
            xdoc.add(new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName(ContentModel.ASSOC_CHILDREN), true, false, false));
            xdoc.add(new Field("ISNODE", "T", false, true, false));
            docs.add(xdoc);
        } else {
            xdoc.add(new Field("QNAME", qNameBuffer.toString(), true, true, true));
            ChildAssociationRef primary = this.nodeService.getPrimaryParent(nodeRef);
            xdoc.add(new Field("PRIMARYPARENT", primary.getParentRef().toString(), true, true, false));
            xdoc.add(new Field("PRIMARYASSOCTYPEQNAME", ISO9075.getXPathName(primary.getTypeQName()), true, false, false));
            QName qName = this.nodeService.getType(nodeRef);
            xdoc.add(new Field("TYPE", ISO9075.getXPathName(qName), true, true, false));
            for (QName classRef : this.nodeService.getAspects(nodeRef)) {
                xdoc.add(new Field("ASPECT", ISO9075.getXPathName(classRef), true, true, false));
            }
            xdoc.add(new Field("ISROOT", "F", false, true, false));
            xdoc.add(new Field("ISNODE", "T", false, true, false));
            if (isAtomic || indexAllProperties) {
                xdoc.add(new Field("FTSSTATUS", "Clean", false, true, false));
            } else if (isNew) {
                xdoc.add(new Field("FTSSTATUS", "New", false, true, false));
            } else {
                xdoc.add(new Field("FTSSTATUS", "Dirty", false, true, false));
            }
            docs.add(xdoc);
        }
        return docs;
    }

    private ArrayList<NodeRef> getParents(Path path) {
        ArrayList<NodeRef> parentsInDepthOrderStartingWithSelf = new ArrayList<NodeRef>(8);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            parentsInDepthOrderStartingWithSelf.add(0, cae.getRef().getChildRef());
        }
        return parentsInDepthOrderStartingWithSelf;
    }

    private ChildAssociationRef getLastRefOrNull(Path path) {
        if (path.last() instanceof Path.ChildAssocElement) {
            Path.ChildAssocElement cae = (Path.ChildAssocElement)path.last();
            return cae.getRef();
        }
        return null;
    }

    private boolean indexProperty(NodeRef nodeRef, QName propertyName, Serializable value, Document doc, boolean indexAtomicPropertiesOnly) {
        String attributeName = "@" + QName.createQName(propertyName.getNamespaceURI(), ISO9075.encode(propertyName.getLocalName()));
        boolean store = true;
        boolean index = true;
        boolean tokenise = true;
        boolean atomic = true;
        boolean isContent = false;
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null) {
            index = propertyDef.isIndexed();
            store = propertyDef.isStoredInIndex();
            tokenise = propertyDef.isTokenisedInIndex();
            atomic = propertyDef.isIndexedAtomically();
            isContent = propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT);
        }
        if (value == null) {
            return true;
        }
        if (indexAtomicPropertiesOnly && !atomic) {
            return false;
        }
        if (!indexAtomicPropertiesOnly) {
            doc.removeFields(propertyName.toString());
        }
        boolean wereAllAtomic = true;
        for (String strValue : DefaultTypeConverter.INSTANCE.getCollection(String.class, value)) {
            if (strValue == null) continue;
            if (isContent) {
                ContentData contentData = DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
                if (!index || contentData.getMimetype() == null) continue;
                doc.add(new Field(attributeName + ".mimetype", contentData.getMimetype(), false, true, false));
                ContentReader reader = this.contentService.getReader(nodeRef, propertyName);
                if (reader != null && reader.exists()) {
                    boolean readerReady = true;
                    if (!EqualsHelper.nullSafeEquals((Object)reader.getMimetype(), (Object)"text/plain") || !EqualsHelper.nullSafeEquals((Object)reader.getEncoding(), (Object)"UTF-8")) {
                        ContentTransformer transformer = this.contentService.getTransformer(reader.getMimetype(), "text/plain");
                        if (transformer == null) {
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("Not indexed: No transformation: \n   source: " + reader + "\n" + "   target: " + "text/plain"));
                            }
                            readerReady = false;
                            doc.add(Field.Text((String)"TEXT", (String)NOT_INDEXED_NO_TRANSFORMATION));
                            doc.add(Field.Text((String)attributeName, (String)NOT_INDEXED_NO_TRANSFORMATION));
                        } else if (indexAtomicPropertiesOnly && transformer.getTransformationTime() > this.maxAtomicTransformationTime) {
                            wereAllAtomic = false;
                        } else {
                            ContentWriter writer = this.contentService.getTempWriter();
                            writer.setMimetype("text/plain");
                            writer.setEncoding("UTF-8");
                            try {
                                transformer.transform(reader, writer);
                                reader = writer.getReader();
                            }
                            catch (ContentIOException e) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)"Not indexed: Transformation failed", (Throwable)((Object)e));
                                }
                                readerReady = false;
                                doc.add(Field.Text((String)"TEXT", (String)NOT_INDEXED_TRANSFORMATION_FAILED));
                                doc.add(Field.Text((String)attributeName, (String)NOT_INDEXED_TRANSFORMATION_FAILED));
                            }
                        }
                    }
                    if (!readerReady) continue;
                    InputStreamReader isr = null;
                    InputStream ris = reader.getContentInputStream();
                    try {
                        isr = new InputStreamReader(ris, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        isr = new InputStreamReader(ris);
                    }
                    doc.add(Field.Text((String)"TEXT", (Reader)isr));
                    ris = reader.getReader().getContentInputStream();
                    try {
                        isr = new InputStreamReader(ris, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        isr = new InputStreamReader(ris);
                    }
                    doc.add(Field.Text((String)("@" + QName.createQName(propertyName.getNamespaceURI(), ISO9075.encode(propertyName.getLocalName()))), (Reader)isr));
                    continue;
                }
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Not indexed: Content Missing \n   node: " + nodeRef + "\n" + "   reader: " + reader + "\n" + "   content exists: " + (reader == null ? " --- " : Boolean.toString(reader.exists()))));
                }
                doc.add(Field.Text((String)"TEXT", (String)NOT_INDEXED_CONTENT_MISSING));
                doc.add(Field.Text((String)attributeName, (String)NOT_INDEXED_CONTENT_MISSING));
                continue;
            }
            doc.add(new Field(attributeName, strValue, store, index, tokenise));
        }
        return wereAllAtomic;
    }

    private Map<ChildAssociationRef, Counter> getNodeCounts(NodeRef nodeRef) {
        HashMap<ChildAssociationRef, Counter> nodeCounts = new HashMap<ChildAssociationRef, Counter>(5);
        List<ChildAssociationRef> parentAssocs = this.nodeService.getParentAssocs(nodeRef);
        for (ChildAssociationRef assoc : parentAssocs) {
            Counter counter = (Counter)nodeCounts.get(assoc);
            if (counter == null) {
                counter = new Counter();
                nodeCounts.put(assoc, counter);
            }
            counter.incrementParentCount();
        }
        return nodeCounts;
    }

    private Collection<Pair<Path, QName>> getCategoryPaths(NodeRef nodeRef, Map<QName, Serializable> properties) {
        ArrayList<Pair<Path, QName>> categoryPaths = new ArrayList<Pair<Path, QName>>();
        Set<QName> aspects = this.nodeService.getAspects(nodeRef);
        for (QName qName : aspects) {
            AspectDefinition aspDef = this.getDictionaryService().getAspect(qName);
            if (!this.isCategorised(aspDef)) continue;
            LinkedList<Pair<Path, QName>> aspectPaths = new LinkedList<Pair<Path, QName>>();
            for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                if (!propDef.getDataType().getName().equals(DataTypeDefinition.CATEGORY)) continue;
                for (NodeRef catRef : DefaultTypeConverter.INSTANCE.getCollection(NodeRef.class, properties.get(propDef.getName()))) {
                    if (catRef == null) continue;
                    for (Path path : this.nodeService.getPaths(catRef, false)) {
                        if (path.size() <= 1 || !(path.get(1) instanceof Path.ChildAssocElement)) continue;
                        Path.ChildAssocElement cae = (Path.ChildAssocElement)path.get(1);
                        boolean isFakeRoot = true;
                        for (ChildAssociationRef car : this.nodeService.getParentAssocs(cae.getRef().getChildRef())) {
                            if (!cae.getRef().equals(car)) continue;
                            isFakeRoot = false;
                            break;
                        }
                        if (!isFakeRoot || path.toString().indexOf(aspDef.getName().toString()) == -1) continue;
                        aspectPaths.add(new Pair<Path, QName>(path, aspDef.getName()));
                    }
                }
            }
            categoryPaths.addAll(aspectPaths);
        }
        for (Pair pair : categoryPaths) {
            if (!(((Path)pair.getFirst()).last() instanceof Path.ChildAssocElement)) continue;
            Path.ChildAssocElement cae = (Path.ChildAssocElement)((Path)pair.getFirst()).last();
            ChildAssociationRef assocRef = cae.getRef();
            ((Path)pair.getFirst()).append(new Path.ChildAssocElement(new ChildAssociationRef(assocRef.getTypeQName(), assocRef.getChildRef(), QName.createQName("member"), nodeRef)));
        }
        return categoryPaths;
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals(ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getAspect(parentName);
        }
        return false;
    }

    private boolean isCategory(TypeDefinition typeDef) {
        if (typeDef == null) {
            return false;
        }
        TypeDefinition current = typeDef;
        while (current != null) {
            if (current.getName().equals(ContentModel.TYPE_CATEGORY)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.getDictionaryService().getType(parentName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFullTextSearch(int size) throws LuceneIndexException {
        this.checkAbleToDoWork(true, false);
        try {
            NodeRef lastId = null;
            this.toFTSIndex = new ArrayList(size);
            BooleanQuery booleanQuery = new BooleanQuery();
            booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "Dirty")), false, false);
            booleanQuery.add((Query)new TermQuery(new Term("FTSSTATUS", "New")), false, false);
            int count = 0;
            Searcher searcher = null;
            LuceneResultSet results = null;
            try {
                Hits hits;
                searcher = this.getSearcher(null);
                if (searcher == null) {
                    this.remainingCount = size;
                    return;
                }
                try {
                    hits = searcher.search((Query)booleanQuery);
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to execute query to find content which needs updating in the index", e);
                }
                results = new LuceneResultSet(hits, searcher, this.nodeService, null, new SearchParameters());
                for (ResultSetRow row : results) {
                    LuceneResultSetRow lrow = (LuceneResultSetRow)row;
                    Helper helper = new Helper(lrow.getNodeRef(), lrow.getDocument().getField("TX").stringValue());
                    this.toFTSIndex.add(helper);
                    if (++count < size) continue;
                    break;
                }
                count = results.length();
            }
            finally {
                if (results != null) {
                    results.close();
                } else if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (IOException e) {
                        throw new LuceneIndexException("Failed to close searcher", e);
                    }
                }
            }
            if (this.toFTSIndex.size() > 0) {
                this.checkAbleToDoWork(true, true);
                IndexWriter writer = null;
                try {
                    writer = this.getDeltaWriter();
                    for (Helper helper : this.toFTSIndex) {
                        NodeRef ref = helper.nodeRef;
                        if (!this.nodeService.exists(ref)) continue;
                        List<Document> docs = this.createDocuments(ref, false, true, false);
                        for (Document doc : docs) {
                            try {
                                writer.addDocument(doc);
                            }
                            catch (IOException e) {
                                throw new LuceneIndexException("Failed to add document while updating fts index", e);
                            }
                        }
                        if (writer.docCount() <= size) continue;
                        if (lastId == null) {
                            lastId = ref;
                        }
                        if (lastId.equals(ref)) continue;
                        break;
                    }
                    this.remainingCount = count - writer.docCount();
                }
                catch (LuceneIndexException e) {
                    if (writer != null) {
                        this.closeDeltaWriter();
                    }
                }
            }
        }
        catch (IOException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", (Throwable)((Object)e));
        }
    }

    @Override
    public void registerCallBack(FTSIndexerAware callBack) {
        this.callBack = callBack;
    }

    @Override
    public void setLuceneFullTextSearchIndexer(FullTextSearchIndexer luceneFullTextSearchIndexer) {
        this.luceneFullTextSearchIndexer = luceneFullTextSearchIndexer;
    }

    @Override
    public Set<NodeRef> getDeletions() {
        return Collections.unmodifiableSet(this.deletions);
    }

    @Override
    public boolean getDeleteOnlyNodes() {
        if (this.isFTSUpdate != null) {
            return this.isFTSUpdate;
        }
        return false;
    }

    private static class Command {
        NodeRef nodeRef;
        Action action;

        Command(NodeRef nodeRef, Action action) {
            this.nodeRef = nodeRef;
            this.action = action;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            if (this.action == Action.INDEX) {
                buffer.append("Index ");
            } else if (this.action == Action.DELETE) {
                buffer.append("Delete ");
            } else if (this.action == Action.REINDEX) {
                buffer.append("Reindex ");
            } else {
                buffer.append("Unknown ... ");
            }
            buffer.append(this.nodeRef);
            return buffer.toString();
        }
    }

    private static class Helper {
        NodeRef nodeRef;
        String tx;

        Helper(NodeRef nodeRef, String tx) {
            this.nodeRef = nodeRef;
            this.tx = tx;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Pair<F, S> {
        private F first;
        private S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }

        public F getFirst() {
            return this.first;
        }

        public S getSecond() {
            return this.second;
        }
    }

    static class Counter {
        int countInParent = 0;
        int count = -1;

        Counter() {
        }

        int getCountInParent() {
            return this.countInParent;
        }

        int getRepeat() {
            return this.count / this.countInParent + 1;
        }

        void incrementParentCount() {
            ++this.countInParent;
        }

        void increment() {
            ++this.count;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Action {
        INDEX,
        REINDEX,
        DELETE,
        CASCADEREINDEX;

    }
}

