/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import com.werken.saxpath.XPathReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashSet;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.CharStream;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.ParseException;
import org.alfresco.repo.search.impl.lucene.QueryParser;
import org.alfresco.repo.search.impl.lucene.QueryParserTokenManager;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RangeQuery;
import org.apache.lucene.search.TermQuery;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;

public class LuceneQueryParser
extends QueryParser {
    private static Logger s_logger = Logger.getLogger(LuceneQueryParser.class);
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;

    public static Query parse(String query, String field, Analyzer analyzer, NamespacePrefixResolver namespacePrefixResolver, DictionaryService dictionaryService, int defaultOperator) throws ParseException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Using Alfresco Lucene Query Parser for query: " + query));
        }
        LuceneQueryParser parser = new LuceneQueryParser(field, analyzer);
        parser.setOperator(defaultOperator);
        parser.setNamespacePrefixResolver(namespacePrefixResolver);
        parser.setDictionaryService(dictionaryService);
        return parser.parse(query);
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public LuceneQueryParser(String arg0, Analyzer arg1) {
        super(arg0, arg1);
    }

    public LuceneQueryParser(CharStream arg0) {
        super(arg0);
    }

    public LuceneQueryParser(QueryParserTokenManager arg0) {
        super(arg0);
    }

    protected Query getFieldQuery(String field, String queryText) throws ParseException {
        try {
            if (field.equals("PATH")) {
                XPathReader reader = new XPathReader();
                LuceneXPathHandler handler = new LuceneXPathHandler();
                handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
                handler.setDictionaryService(this.dictionaryService);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse(queryText);
                PathQuery pathQuery = handler.getQuery();
                pathQuery.setRepeats(false);
                return pathQuery;
            }
            if (field.equals("PATH_WITH_REPEATS")) {
                XPathReader reader = new XPathReader();
                LuceneXPathHandler handler = new LuceneXPathHandler();
                handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
                handler.setDictionaryService(this.dictionaryService);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse(queryText);
                PathQuery pathQuery = handler.getQuery();
                pathQuery.setRepeats(true);
                return pathQuery;
            }
            if (field.equals("ID")) {
                TermQuery termQuery = new TermQuery(new Term(field, queryText));
                return termQuery;
            }
            if (field.equals("TX")) {
                TermQuery termQuery = new TermQuery(new Term(field, queryText));
                return termQuery;
            }
            if (field.equals("PARENT")) {
                TermQuery termQuery = new TermQuery(new Term(field, queryText));
                return termQuery;
            }
            if (field.equals("PRIMARYPARENT")) {
                TermQuery termQuery = new TermQuery(new Term(field, queryText));
                return termQuery;
            }
            if (field.equals("QNAME")) {
                XPathReader reader = new XPathReader();
                LuceneXPathHandler handler = new LuceneXPathHandler();
                handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
                handler.setDictionaryService(this.dictionaryService);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse("//" + queryText);
                return handler.getQuery();
            }
            if (field.equals("TYPE")) {
                TypeDefinition target = this.dictionaryService.getType(QName.createQName(queryText));
                if (target == null) {
                    throw new SearcherException("Invalid type: " + queryText);
                }
                QName targetQName = target.getName();
                HashSet<QName> subclasses = new HashSet<QName>();
                for (QName classRef : this.dictionaryService.getAllTypes()) {
                    TypeDefinition current = this.dictionaryService.getType(classRef);
                    while (current != null && !current.getName().equals(targetQName)) {
                        current = current.getParentName() == null ? null : this.dictionaryService.getType(current.getParentName());
                    }
                    if (current == null) continue;
                    subclasses.add(classRef);
                }
                BooleanQuery booleanQuery = new BooleanQuery();
                for (QName qname : subclasses) {
                    TermQuery termQuery = new TermQuery(new Term(field, qname.toString()));
                    booleanQuery.add((Query)termQuery, false, false);
                }
                return booleanQuery;
            }
            if (field.equals("ASPECT")) {
                AspectDefinition target = this.dictionaryService.getAspect(QName.createQName(queryText));
                QName targetQName = target.getName();
                HashSet<QName> subclasses = new HashSet<QName>();
                for (QName classRef : this.dictionaryService.getAllAspects()) {
                    AspectDefinition current = this.dictionaryService.getAspect(classRef);
                    while (current != null && !current.getName().equals(targetQName)) {
                        current = current.getParentName() == null ? null : this.dictionaryService.getAspect(current.getParentName());
                    }
                    if (current == null) continue;
                    subclasses.add(classRef);
                }
                BooleanQuery booleanQuery = new BooleanQuery();
                for (QName qname : subclasses) {
                    TermQuery termQuery = new TermQuery(new Term(field, qname.toString()));
                    booleanQuery.add((Query)termQuery, false, false);
                }
                return booleanQuery;
            }
            if (field.startsWith("@")) {
                QName propertyQName;
                PropertyDefinition propertyDef;
                String expandedFieldName = field;
                if (field.charAt(1) != '{') {
                    int colonPosition = field.indexOf(58);
                    expandedFieldName = colonPosition == -1 ? "@{" + this.namespacePrefixResolver.getNamespaceURI("") + "}" + field.substring(1) : "@{" + this.namespacePrefixResolver.getNamespaceURI(field.substring(1, colonPosition)) + "}" + field.substring(colonPosition + 1);
                }
                if (expandedFieldName.endsWith(".mimetype") && (propertyDef = this.dictionaryService.getProperty(propertyQName = QName.createQName(expandedFieldName.substring(1, expandedFieldName.length() - 9)))) != null && propertyDef.getDataType().getName().equals(DataTypeDefinition.CONTENT)) {
                    TermQuery termQuery = new TermQuery(new Term(expandedFieldName, queryText));
                    return termQuery;
                }
                return super.getFieldQuery(expandedFieldName, queryText);
            }
            return super.getFieldQuery(field, queryText);
        }
        catch (SAXPathException e) {
            throw new ParseException("Failed to parse XPath...\n" + e.getMessage());
        }
    }

    protected Query getRangeQuery(String field, String part1, String part2, boolean inclusive) throws ParseException {
        if (field.startsWith("@")) {
            String fieldName = field;
            if (field.charAt(1) != '{') {
                int colonPosition = field.indexOf(58);
                fieldName = colonPosition == -1 ? "@{" + this.namespacePrefixResolver.getNamespaceURI("") + "}" + field.substring(1) : "@{" + this.namespacePrefixResolver.getNamespaceURI(field.substring(1, colonPosition)) + "}" + field.substring(colonPosition + 1);
            }
            return new RangeQuery(new Term(fieldName, this.getToken(fieldName, part1)), new Term(fieldName, this.getToken(fieldName, part2)), inclusive);
        }
        return super.getRangeQuery(field, part1, part2, inclusive);
    }

    private String getToken(String field, String value) {
        TokenStream source = this.analyzer.tokenStream(field, (Reader)new StringReader(value));
        String tokenised = null;
        while (true) {
            Token t;
            try {
                t = source.next();
            }
            catch (IOException e) {
                t = null;
            }
            if (t == null) break;
            tokenised = t.termText();
        }
        try {
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return tokenised;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }
}

