/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.ResultSetRowIterator;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRow;
import org.alfresco.repo.search.impl.lucene.LuceneResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;

public class LuceneResultSet
extends AbstractResultSet {
    Hits hits;
    private Searcher searcher;
    private NodeService nodeService;
    SearchParameters searchParameters;

    public LuceneResultSet(Hits hits, Searcher searcher, NodeService nodeService, Path[] propertyPaths, SearchParameters searchParameters) {
        super(propertyPaths);
        this.hits = hits;
        this.searcher = searcher;
        this.nodeService = nodeService;
        this.searchParameters = searchParameters;
    }

    public ResultSetRowIterator iterator() {
        return new LuceneResultSetRowIterator(this);
    }

    public int length() {
        return this.hits.length();
    }

    public NodeRef getNodeRef(int n) {
        try {
            Document doc = this.hits.doc(n);
            String id = doc.get("ID");
            return new NodeRef(id);
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading reading node ref from the result set", e);
        }
    }

    public float getScore(int n) throws SearcherException {
        try {
            return this.hits.score(n);
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading score from the result set", e);
        }
    }

    public Document getDocument(int n) {
        try {
            Document doc = this.hits.doc(n);
            return doc;
        }
        catch (IOException e) {
            throw new SearcherException("IO Error reading reading document from the result set", e);
        }
    }

    public void close() {
        try {
            this.searcher.close();
        }
        catch (IOException e) {
            throw new SearcherException(e);
        }
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    public ResultSetRow getRow(int i) {
        if (i < this.length()) {
            return new LuceneResultSetRow(this, i);
        }
        throw new SearcherException("Invalid row");
    }

    public ChildAssociationRef getChildAssocRef(int n) {
        return this.getRow(n).getChildAssocRef();
    }

    public ResultSetMetaData getResultSetMetaData() {
        return new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, this.searchParameters);
    }
}

