/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.AbstractResultSetRow;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneResultSetRow
extends AbstractResultSetRow {
    private Document document;

    public LuceneResultSetRow(LuceneResultSet resultSet, int index) {
        super(resultSet, index);
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = ((LuceneResultSet)this.getResultSet()).getDocument(this.getIndex());
        }
        return this.document;
    }

    @Override
    protected Map<QName, Serializable> getDirectProperties() {
        LuceneResultSet lrs = (LuceneResultSet)this.getResultSet();
        return lrs.getNodeService().getProperties(lrs.getNodeRef(this.getIndex()));
    }

    @Override
    public Serializable getValue(Path path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public QName getQName() {
        Field field = this.getDocument().getField("QNAME");
        if (field != null) {
            String qname = field.stringValue();
            if (qname == null || qname.length() == 0) {
                return null;
            }
            return QName.createQName(qname);
        }
        return null;
    }

    public QName getPrimaryAssocTypeQName() {
        Field field = this.getDocument().getField("PRIMARYASSOCTYPEQNAME");
        if (field != null) {
            String qname = field.stringValue();
            return QName.createQName(qname);
        }
        return ContentModel.ASSOC_CHILDREN;
    }

    @Override
    public ChildAssociationRef getChildAssocRef() {
        Field field = this.getDocument().getField("PRIMARYPARENT");
        String primaryParent = null;
        if (field != null) {
            primaryParent = field.stringValue();
        }
        NodeRef childNodeRef = this.getNodeRef();
        NodeRef parentNodeRef = primaryParent == null ? null : new NodeRef(primaryParent);
        return new ChildAssociationRef(this.getPrimaryAssocTypeQName(), parentNodeRef, this.getQName(), childNodeRef);
    }
}

