/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import com.werken.saxpath.XPathReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.EmptyResultSet;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.NodeSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneAnalyser;
import org.alfresco.repo.search.impl.lucene.LuceneBase;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexer;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneXPathHandler;
import org.alfresco.repo.search.impl.lucene.ParseException;
import org.alfresco.repo.search.impl.lucene.QueryParameterisationException;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.alfresco.util.SearchLanguageConversion;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.saxpath.SAXPathException;
import org.saxpath.XPathHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearcherImpl
extends LuceneBase
implements LuceneSearcher {
    private static final String DEFAULT_FIELD = "TEXT";
    private NamespacePrefixResolver namespacePrefixResolver;
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private QueryRegisterComponent queryRegister;
    private LuceneIndexer indexer;

    public static LuceneSearcherImpl getSearcher(StoreRef storeRef, LuceneIndexer indexer, LuceneConfig config) {
        LuceneSearcherImpl searcher = new LuceneSearcherImpl();
        searcher.setLuceneConfig(config);
        try {
            searcher.initialise(storeRef, indexer == null ? null : indexer.getDeltaId(), false, false);
            searcher.indexer = indexer;
        }
        catch (LuceneIndexException e) {
            throw new SearcherException((Throwable)((Object)e));
        }
        return searcher;
    }

    public static LuceneSearcherImpl getSearcher(StoreRef storeRef, LuceneConfig config) {
        return LuceneSearcherImpl.getSearcher(storeRef, null, config);
    }

    @Override
    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    @Override
    public boolean indexExists() {
        return this.mainIndexExists();
    }

    @Override
    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @Override
    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setQueryRegister(QueryRegisterComponent queryRegister) {
        this.queryRegister = queryRegister;
    }

    @Override
    public ResultSet query(StoreRef store, String language, String queryString, Path[] queryOptions, QueryParameterDefinition[] queryParameterDefinitions) throws SearcherException {
        SearchParameters sp = new SearchParameters();
        sp.addStore(store);
        sp.setLanguage(language);
        sp.setQuery(queryString);
        if (queryOptions != null) {
            for (Path path : queryOptions) {
                sp.addAttrbutePath(path);
            }
        }
        if (queryParameterDefinitions != null) {
            for (QueryParameterDefinition qpd : queryParameterDefinitions) {
                sp.addQueryParameterDefinition(qpd);
            }
        }
        sp.excludeDataInTheCurrentTransaction(true);
        return this.query(sp);
    }

    @Override
    public ResultSet query(SearchParameters searchParameters) {
        String parameterisedQueryString;
        if (searchParameters.getStores().size() != 1) {
            throw new IllegalStateException("Only one store can be searched at present");
        }
        if (searchParameters.getQueryParameterDefinitions().size() > 0) {
            HashMap<QName, QueryParameterDefinition> map = new HashMap<QName, QueryParameterDefinition>();
            for (QueryParameterDefinition qpd : searchParameters.getQueryParameterDefinitions()) {
                map.put(qpd.getQName(), qpd);
            }
            parameterisedQueryString = this.parameterise(searchParameters.getQuery(), map, null, this.namespacePrefixResolver);
        } else {
            parameterisedQueryString = searchParameters.getQuery();
        }
        if (searchParameters.getLanguage().equalsIgnoreCase("lucene")) {
            try {
                Hits hits;
                int defaultOperator = searchParameters.getDefaultOperator() == SearchParameters.AND ? 1 : 0;
                Query query = LuceneQueryParser.parse(parameterisedQueryString, DEFAULT_FIELD, new LuceneAnalyser(this.dictionaryService), this.namespacePrefixResolver, this.dictionaryService, defaultOperator);
                Searcher searcher = this.getSearcher(this.indexer);
                if (searcher == null) {
                    return new EmptyResultSet();
                }
                if (searchParameters.getSortDefinitions().size() > 0) {
                    int index = 0;
                    SortField[] fields = new SortField[searchParameters.getSortDefinitions().size()];
                    for (SearchParameters.SortDefinition sd : searchParameters.getSortDefinitions()) {
                        switch (sd.getSortType()) {
                            case FIELD: {
                                fields[index++] = new SortField(sd.getField(), !sd.isAscending());
                                break;
                            }
                            case DOCUMENT: {
                                fields[index++] = new SortField(null, 1, !sd.isAscending());
                                break;
                            }
                            case SCORE: {
                                fields[index++] = new SortField(null, 0, !sd.isAscending());
                            }
                        }
                    }
                    hits = searcher.search(query, new Sort(fields));
                } else {
                    hits = searcher.search(query);
                }
                return new LuceneResultSet(hits, searcher, this.nodeService, searchParameters.getAttributePaths().toArray(new Path[0]), searchParameters);
            }
            catch (ParseException e) {
                throw new SearcherException("Failed to parse query: " + parameterisedQueryString, e);
            }
            catch (IOException e) {
                throw new SearcherException("IO exception during search", e);
            }
        }
        if (searchParameters.getLanguage().equalsIgnoreCase("xpath")) {
            try {
                XPathReader reader = new XPathReader();
                LuceneXPathHandler handler = new LuceneXPathHandler();
                handler.setNamespacePrefixResolver(this.namespacePrefixResolver);
                handler.setDictionaryService(this.dictionaryService);
                reader.setXPathHandler((XPathHandler)handler);
                reader.parse(parameterisedQueryString);
                PathQuery query = handler.getQuery();
                Searcher searcher = this.getSearcher(null);
                if (searcher == null) {
                    return new EmptyResultSet();
                }
                Hits hits = searcher.search((Query)query);
                return new LuceneResultSet(hits, searcher, this.nodeService, searchParameters.getAttributePaths().toArray(new Path[0]), searchParameters);
            }
            catch (SAXPathException e) {
                throw new SearcherException("Failed to parse query: " + searchParameters.getQuery(), e);
            }
            catch (IOException e) {
                throw new SearcherException("IO exception during search", e);
            }
        }
        throw new SearcherException("Unknown query language: " + searchParameters.getLanguage());
    }

    @Override
    public ResultSet query(StoreRef store, String language, String query) {
        return this.query(store, language, query, null, null);
    }

    @Override
    public ResultSet query(StoreRef store, String language, String query, QueryParameterDefinition[] queryParameterDefintions) {
        return this.query(store, language, query, null, queryParameterDefintions);
    }

    @Override
    public ResultSet query(StoreRef store, String language, String query, Path[] attributePaths) {
        return this.query(store, language, query, attributePaths, null);
    }

    @Override
    public ResultSet query(StoreRef store, QName queryId, QueryParameter[] queryParameters) {
        CannedQueryDef definition = this.queryRegister.getQueryDefinition(queryId);
        this.checkParameters(definition, queryParameters);
        String queryString = this.parameterise(definition.getQuery(), definition.getQueryParameterMap(), queryParameters, definition.getNamespacePrefixResolver());
        return this.query(store, definition.getLanguage(), queryString, null, null);
    }

    private void checkParameters(CannedQueryDef definition, QueryParameter[] queryParameters) throws QueryParameterisationException {
        ArrayList<QName> missing = new ArrayList<QName>();
        HashSet<QName> parameterQNameSet = new HashSet<QName>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                parameterQNameSet.add(parameter.getQName());
            }
        }
        for (QueryParameterDefinition parameterDefinition : definition.getQueryParameterDefs()) {
            if (parameterDefinition.hasDefaultValue() || parameterQNameSet.contains(parameterDefinition.getQName())) continue;
            missing.add(parameterDefinition.getQName());
        }
        if (missing.size() > 0) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append("The query is missing values for the following parameters: ");
            for (QName qName : missing) {
                buffer.append(qName);
                buffer.append(", ");
            }
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            buffer.delete(buffer.length() - 1, buffer.length() - 1);
            throw new QueryParameterisationException(buffer.toString());
        }
    }

    private String parameterise(String unparameterised, Map<QName, QueryParameterDefinition> map, QueryParameter[] queryParameters, NamespacePrefixResolver nspr) throws QueryParameterisationException {
        HashMap<QName, ArrayList<Serializable>> valueMap = new HashMap<QName, ArrayList<Serializable>>();
        if (queryParameters != null) {
            for (QueryParameter parameter : queryParameters) {
                ArrayList<Serializable> list = (ArrayList<Serializable>)valueMap.get(parameter.getQName());
                if (list == null) {
                    list = new ArrayList<Serializable>();
                    valueMap.put(parameter.getQName(), list);
                }
                list.add(parameter.getValue());
            }
        }
        HashMap iteratorMap = new HashMap();
        ArrayList<QName> missing = new ArrayList<QName>(1);
        StringBuilder buffer = new StringBuilder(unparameterised);
        int index = 0;
        while ((index = buffer.indexOf("${", index)) != -1) {
            int endIndex = buffer.indexOf("}", index);
            String qNameString = buffer.substring(index + 2, endIndex);
            QName key = QName.createQName(qNameString, nspr);
            QueryParameterDefinition parameterDefinition = map.get(key);
            if (parameterDefinition == null) {
                missing.add(key);
                buffer.replace(index, endIndex + 1, "");
                continue;
            }
            ListIterator it = (ListIterator)iteratorMap.get(key);
            if (it == null || !it.hasNext()) {
                List list = (List)valueMap.get(key);
                if (list != null && list.size() > 0) {
                    it = list.listIterator();
                }
                if (it != null) {
                    iteratorMap.put(key, it);
                }
            }
            String value = it == null ? parameterDefinition.getDefault() : DefaultTypeConverter.INSTANCE.convert(String.class, it.next());
            buffer.replace(index, endIndex + 1, value);
        }
        if (missing.size() > 0) {
            StringBuilder error = new StringBuilder();
            error.append("The query uses the following parameters which are not defined: ");
            for (QName qName : missing) {
                error.append(qName);
                error.append(", ");
            }
            error.delete(error.length() - 1, error.length() - 1);
            error.delete(error.length() - 1, error.length() - 1);
            throw new QueryParameterisationException(error.toString());
        }
        return buffer.toString();
    }

    @Override
    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    @Override
    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) throws InvalidNodeRefException, XPathException {
        NodeSearcher nodeSearcher = new NodeSearcher(this.nodeService, this.dictionaryService, this);
        return nodeSearcher.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, language);
    }

    @Override
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern) {
        return this.contains(nodeRef, propertyQName, googleLikePattern, SearchParameters.Operator.OR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(NodeRef nodeRef, QName propertyQName, String googleLikePattern, SearchParameters.Operator defaultOperator) {
        ResultSet resultSet = null;
        try {
            boolean answer;
            StringBuilder sb = new StringBuilder();
            sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(TEXT:(").append(googleLikePattern.toLowerCase()).append(") ");
            if (propertyQName != null) {
                sb.append(" OR @").append(LuceneQueryParser.escape(QName.createQName(propertyQName.getNamespaceURI(), ISO9075.encode(propertyQName.getLocalName())).toString()));
                sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
            } else {
                for (QName key : this.nodeService.getProperties(nodeRef).keySet()) {
                    sb.append(" OR @").append(LuceneQueryParser.escape(QName.createQName(key.getNamespaceURI(), ISO9075.encode(key.getLocalName())).toString()));
                    sb.append(":(").append(googleLikePattern.toLowerCase()).append(")");
                }
            }
            sb.append(")");
            SearchParameters sp = new SearchParameters();
            sp.setLanguage("lucene");
            sp.setQuery(sb.toString());
            sp.setDefaultOperator(defaultOperator);
            sp.addStore(nodeRef.getStoreRef());
            resultSet = this.query(sp);
            boolean bl = answer = resultSet.length() > 0;
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean like(NodeRef nodeRef, QName propertyQName, String sqlLikePattern, boolean includeFTS) {
        if (propertyQName == null) {
            throw new IllegalArgumentException("Property QName is mandatory for the like expression");
        }
        StringBuilder sb = new StringBuilder(sqlLikePattern.length() * 3);
        if (includeFTS) {
            String pattern = SearchLanguageConversion.convertXPathLikeToLucene(sqlLikePattern.toLowerCase());
            sb = new StringBuilder();
            sb.append("+ID:\"").append(nodeRef.toString()).append("\" +(");
            if (includeFTS) {
                sb.append("TEXT:(").append(pattern).append(") ");
            }
            if (propertyQName != null) {
                sb.append(" @").append(LuceneQueryParser.escape(QName.createQName(propertyQName.getNamespaceURI(), ISO9075.encode(propertyQName.getLocalName())).toString())).append(":(").append(pattern).append(")");
            }
            sb.append(")");
            ResultSet resultSet = null;
            try {
                boolean answer;
                resultSet = this.query(nodeRef.getStoreRef(), "lucene", sb.toString());
                boolean bl = answer = resultSet.length() > 0;
                return bl;
            }
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
        }
        String pattern = SearchLanguageConversion.convertXPathLikeToRegex(sqlLikePattern.toLowerCase());
        Serializable property = this.nodeService.getProperty(nodeRef, propertyQName);
        if (property == null) {
            return false;
        }
        String propertyString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, propertyQName));
        return propertyString.toLowerCase().matches(pattern);
    }

    @Override
    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectNodes(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }

    @Override
    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] parameters, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks) throws InvalidNodeRefException, XPathException {
        return this.selectProperties(contextNodeRef, xpath, parameters, namespacePrefixResolver, followAllParentLinks, "xpath");
    }
}

