/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.search.QueryRegisterComponent;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.LuceneQueryParser;
import org.alfresco.repo.search.impl.lucene.LuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.search.results.ChildAssocRefResultSet;
import org.alfresco.repo.search.results.DetachedResultSet;
import org.alfresco.repo.search.transaction.LuceneIndexLock;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.ISO9075;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;

public class LuceneTest
extends TestCase {
    private static final String TEST_NAMESPACE = "http://www.alfresco.org/test/lucenetest";
    private static final QName ASSOC_TYPE_QNAME = QName.createQName("http://www.alfresco.org/test/lucenetest", "assoc");
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private static Log logger = LogFactory.getLog(LuceneTest.class);
    TransactionService transactionService;
    NodeService nodeService;
    DictionaryService dictionaryService;
    LuceneIndexLock luceneIndexLock;
    private NodeRef rootNodeRef;
    private NodeRef n1;
    private NodeRef n2;
    private NodeRef n3;
    private NodeRef n4;
    private NodeRef n5;
    private NodeRef n6;
    private NodeRef n7;
    private NodeRef n8;
    private NodeRef n9;
    private NodeRef n10;
    private NodeRef n11;
    private NodeRef n12;
    private NodeRef n13;
    private NodeRef n14;
    private DictionaryDAO dictionaryDAO;
    private FullTextSearchIndexer luceneFTS;
    private QName testType = QName.createQName("http://www.alfresco.org/test/lucenetest", "testType");
    private QName testSuperType = QName.createQName("http://www.alfresco.org/test/lucenetest", "testSuperType");
    private QName testAspect = QName.createQName("http://www.alfresco.org/test/lucenetest", "testAspect");
    private QName testSuperAspect = QName.createQName("http://www.alfresco.org/test/lucenetest", "testSuperAspect");
    private ContentService contentService;
    private QueryRegisterComponent queryRegisterComponent;
    private NamespacePrefixResolver namespacePrefixResolver;
    private LuceneIndexerAndSearcher indexerAndSearcher;
    private ServiceRegistry serviceRegistry;
    private UserTransaction testTX;
    private AuthenticationComponent authenticationComponent;
    private NodeRef[] documentOrder;

    public LuceneTest() {
    }

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.luceneIndexLock = (LuceneIndexLock)ctx.getBean("luceneIndexLock");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.dictionaryDAO = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.contentService = (ContentService)ctx.getBean("contentService");
        this.queryRegisterComponent = (QueryRegisterComponent)ctx.getBean("queryRegisterComponent");
        this.namespacePrefixResolver = (NamespacePrefixResolver)ctx.getBean("namespaceService");
        this.indexerAndSearcher = (LuceneIndexerAndSearcher)ctx.getBean("luceneIndexerAndSearcherFactory");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.queryRegisterComponent.loadQueryCollection("testQueryRegister.xml");
        LuceneTest.assertEquals((boolean)true, (boolean)ctx.isSingleton("luceneIndexLock"));
        LuceneTest.assertEquals((boolean)true, (boolean)ctx.isSingleton("LuceneFullTextSearchIndexer"));
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/search/impl/lucene/LuceneTest_model.xml");
        LuceneTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel(modelStream);
        this.dictionaryDAO.putModel(model);
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.n1 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}one"), this.testSuperType).getChildRef();
        this.nodeService.setProperty(this.n1, QName.createQName("{namespace}property-1"), (Serializable)((Object)"ValueOne"));
        this.n2 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}two"), this.testSuperType).getChildRef();
        this.nodeService.setProperty(this.n2, QName.createQName("{namespace}property-1"), (Serializable)((Object)"valueone"));
        this.nodeService.setProperty(this.n2, QName.createQName("{namespace}property-2"), (Serializable)((Object)"valuetwo"));
        this.n3 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}three"), this.testSuperType).getChildRef();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(this.n3);
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(baos.toByteArray()));
            Object o = ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        HashMap<QName, Serializable> testProperties = new HashMap<QName, Serializable>();
        testProperties.put(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-atomic"), (Serializable)((Object)"TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYONE"));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "text-indexed-unstored-tokenised-atomic"), (Serializable)((Object)"TEXT THAT IS INDEXED STORED AND TOKENISED ATOMICALLY KEYUNSTORED"));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-nonatomic"), (Serializable)((Object)"TEXT THAT IS INDEXED STORED AND TOKENISED BUT NOT ATOMICALLY KEYTWO"));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "int-ista"), Integer.valueOf(1));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "long-ista"), Long.valueOf(2L));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "float-ista"), Float.valueOf(3.4f));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "double-ista"), Double.valueOf(5.6));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "date-ista"), new Date());
        testProperties.put(QName.createQName(TEST_NAMESPACE, "datetime-ista"), new Date());
        testProperties.put(QName.createQName(TEST_NAMESPACE, "boolean-ista"), Boolean.valueOf(true));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "qname-ista"), QName.createQName("{wibble}wobble"));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "category-ista"), new NodeRef(storeRef, "CategoryId"));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "noderef-ista"), this.n1);
        testProperties.put(QName.createQName(TEST_NAMESPACE, "path-ista"), this.nodeService.getPath(this.n3));
        testProperties.put(QName.createQName(TEST_NAMESPACE, "null"), null);
        testProperties.put(QName.createQName(TEST_NAMESPACE, "list"), new ArrayList());
        ArrayList<Object> testList = new ArrayList<Object>();
        testList.add(null);
        testProperties.put(QName.createQName(TEST_NAMESPACE, "nullList"), testList);
        ArrayList<String> testList2 = new ArrayList<String>();
        testList2.add("woof");
        testList2.add(null);
        this.n4 = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}four"), this.testType, testProperties).getChildRef();
        this.nodeService.getProperties(this.n1);
        this.nodeService.getProperties(this.n2);
        this.nodeService.getProperties(this.n3);
        this.nodeService.getProperties(this.n4);
        this.n5 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName("{namespace}five"), this.testSuperType).getChildRef();
        this.n6 = this.nodeService.createNode(this.n1, ASSOC_TYPE_QNAME, QName.createQName("{namespace}six"), this.testSuperType).getChildRef();
        this.n7 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName("{namespace}seven"), this.testSuperType).getChildRef();
        this.n8 = this.nodeService.createNode(this.n2, ASSOC_TYPE_QNAME, QName.createQName("{namespace}eight-2"), this.testSuperType).getChildRef();
        this.n9 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName("{namespace}nine"), this.testSuperType).getChildRef();
        this.n10 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName("{namespace}ten"), this.testSuperType).getChildRef();
        this.n11 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName("{namespace}eleven"), this.testSuperType).getChildRef();
        this.n12 = this.nodeService.createNode(this.n5, ASSOC_TYPE_QNAME, QName.createQName("{namespace}twelve"), this.testSuperType).getChildRef();
        this.n13 = this.nodeService.createNode(this.n12, ASSOC_TYPE_QNAME, QName.createQName("{namespace}thirteen"), this.testSuperType).getChildRef();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_CONTENT, new ContentData(null, "text/plain", 0L, "UTF-16"));
        this.n14 = this.nodeService.createNode(this.n13, ASSOC_TYPE_QNAME, QName.createQName("{namespace}fourteen"), ContentModel.TYPE_CONTENT, properties).getChildRef();
        ContentWriter writer = this.contentService.getWriter(this.n14, ContentModel.PROP_CONTENT, true);
        writer.putContent("The quick brown fox jumped over the lazy dog");
        this.nodeService.addChild(this.rootNodeRef, this.n8, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}eight-0"));
        this.nodeService.addChild(this.n1, this.n8, ASSOC_TYPE_QNAME, QName.createQName("{namespace}eight-1"));
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName("{namespace}link"));
        this.nodeService.addChild(this.n1, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n2, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n5, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n6, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n12, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.nodeService.addChild(this.n13, this.n14, ASSOC_TYPE_QNAME, QName.createQName("{namespace}common"));
        this.documentOrder = new NodeRef[]{this.rootNodeRef, this.n1, this.n2, this.n3, this.n4, this.n5, this.n6, this.n7, this.n8, this.n9, this.n10, this.n11, this.n12, this.n13, this.n14};
    }

    protected void tearDown() throws Exception {
        if (this.testTX.getStatus() == 0) {
            this.testTX.rollback();
        }
        AuthenticationUtil.clearCurrentSecurityContext();
        super.tearDown();
    }

    public LuceneTest(String arg0) {
        super(arg0);
    }

    public void test0() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testDeleteIssue() throws Exception {
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}testFind"), this.testSuperType);
        tx.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        UserTransaction tx1 = this.transactionService.getUserTransaction();
        tx1.begin();
        for (int i = 0; i < 100; ++i) {
            HashSet<ChildAssociationRef> refs = new HashSet<ChildAssociationRef>();
            for (int j = 0; j < i; ++j) {
                ChildAssociationRef test = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}test"), this.testSuperType);
                refs.add(test);
            }
            for (ChildAssociationRef car : refs) {
                this.nodeService.deleteNode(car.getChildRef());
            }
        }
        tx1.commit();
        UserTransaction tx3 = this.transactionService.getUserTransaction();
        tx3.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx3.commit();
    }

    public void testMTDeleteIssue() throws Exception {
        this.luceneFTS.pause();
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}testFind"), this.testSuperType);
        tx.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        Thread runner = null;
        for (int i = 0; i < 20; ++i) {
            runner = new Nester("Concurrent-" + i, runner);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        UserTransaction tx3 = this.transactionService.getUserTransaction();
        tx3.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx3.commit();
    }

    public void testDeltaIssue() throws Exception {
        this.luceneFTS.pause();
        final NodeService pns = (NodeService)ctx.getBean("NodeService");
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        tx.commit();
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    LuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    UserTransaction tx = LuceneTest.this.transactionService.getUserTransaction();
                    tx = LuceneTest.this.transactionService.getUserTransaction();
                    tx.begin();
                    SearchParameters sp = new SearchParameters();
                    sp.addStore(LuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    ResultSet results = LuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    sp = new SearchParameters();
                    sp.addStore(LuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    results = LuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
                    props.put(ContentModel.PROP_TITLE, (Serializable)((Object)"woof"));
                    pns.addAspect(LuceneTest.this.n1, ContentModel.ASPECT_TITLED, props);
                    sp = new SearchParameters();
                    sp.addStore(LuceneTest.this.rootNodeRef.getStoreRef());
                    sp.setLanguage("lucene");
                    sp.setQuery("PATH:\"//.\"");
                    sp.excludeDataInTheCurrentTransaction(false);
                    results = LuceneTest.this.serviceRegistry.getSearchService().query(sp);
                    Assert.assertEquals((int)15, (int)results.length());
                    results.close();
                    tx.rollback();
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }
        });
        thread.start();
        thread.join();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        this.runBaseTests();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_TITLE, (Serializable)((Object)"woof"));
        pns.addAspect(this.n1, ContentModel.ASPECT_TITLED, props);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        pns.setProperty(this.n1, ContentModel.PROP_TITLE, (Serializable)((Object)"cube"));
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        tx.rollback();
    }

    public void testRepeatPerformance() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        String query = "ID:\"" + this.rootNodeRef + "\"";
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery(query);
        ResultSet results = searcher.query(sp);
        LuceneTest.assertEquals((String)"No results found from query", (int)1, (int)results.length());
        long start = System.nanoTime();
        int count = 1000;
        for (int i = 0; i < count; ++i) {
            sp.setLanguage("lucene");
            sp.setQuery(query);
            results = searcher.query(sp);
        }
        long end = System.nanoTime();
        double duration = (double)(end - start) / 1000000.0;
        double average = duration / (double)count;
        System.out.println("Searched for identifier: \n   count: " + count + "\n" + "   average: " + average + " ms/search \n" + "   a million searches could take: " + 1000000.0 * average / 1000.0 / 60.0 + " minutes");
        if (average > 10.0) {
            logger.error((Object)("Search taking longer than 10ms: " + query));
        }
    }

    public void testSort() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        ResultSet results = searcher.query(sp);
        String current = null;
        for (ResultSetRow row : results) {
            String id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) > 0) {
                LuceneTest.fail();
            }
            current = id;
        }
        results.close();
        SearchParameters sp2 = new SearchParameters();
        sp2.addStore(this.rootNodeRef.getStoreRef());
        sp2.setLanguage("lucene");
        sp2.setQuery("PATH:\"//.\"");
        sp2.addSort("ID", false);
        results = searcher.query(sp2);
        current = null;
        for (ResultSetRow row : results) {
            String id = row.getNodeRef().getId();
            if (current != null && current.compareTo(id) < 0) {
                LuceneTest.fail();
            }
            current = id;
        }
        results.close();
        this.luceneFTS.resume();
        SearchParameters sp3 = new SearchParameters();
        sp3.addStore(this.rootNodeRef.getStoreRef());
        sp3.setLanguage("lucene");
        sp3.setQuery("PATH:\"//.\"");
        sp3.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_ASCENDING);
        results = searcher.query(sp3);
        int count = 0;
        for (ResultSetRow row : results) {
            LuceneTest.assertEquals((Object)this.documentOrder[count++], (Object)row.getNodeRef());
        }
        results.close();
        SearchParameters sp4 = new SearchParameters();
        sp4.addStore(this.rootNodeRef.getStoreRef());
        sp4.setLanguage("lucene");
        sp4.setQuery("PATH:\"//.\"");
        sp4.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_DESCENDING);
        results = searcher.query(sp4);
        count = 1;
        for (ResultSetRow row : results) {
            LuceneTest.assertEquals((Object)this.documentOrder[this.documentOrder.length - count++], (Object)row.getNodeRef());
        }
        results.close();
        SearchParameters sp5 = new SearchParameters();
        sp5.addStore(this.rootNodeRef.getStoreRef());
        sp5.setLanguage("lucene");
        sp5.setQuery("PATH:\"//.\"");
        sp5.addSort(SearchParameters.SORT_IN_SCORE_ORDER_ASCENDING);
        results = searcher.query(sp5);
        float score = 0.0f;
        for (ResultSetRow row : results) {
            LuceneTest.assertTrue((score <= row.getScore() ? 1 : 0) != 0);
            score = row.getScore();
        }
        results.close();
        SearchParameters sp6 = new SearchParameters();
        sp6.addStore(this.rootNodeRef.getStoreRef());
        sp6.setLanguage("lucene");
        sp6.setQuery("PATH:\"//.\"");
        sp6.addSort(SearchParameters.SORT_IN_SCORE_ORDER_DESCENDING);
        results = searcher.query(sp6);
        score = 1.0f;
        for (ResultSetRow row : results) {
            LuceneTest.assertTrue((score >= row.getScore() ? 1 : 0) != 0);
            score = row.getScore();
        }
        results.close();
        this.luceneFTS.resume();
    }

    public void test1() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test2() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test3() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test4() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setDictionaryService(this.dictionaryService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-2:\"valuetwo\"", null, null);
        results.close();
        this.luceneFTS.resume();
    }

    public void test5() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void test6() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testNoOp() throws Exception {
        this.luceneFTS.pause();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_1", this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.prepare();
        indexer.commit();
        this.luceneFTS.resume();
    }

    public void testStandAloneIndexerCommit() throws Exception {
        this.luceneFTS.pause();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_1", this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}two"), this.n2));
        indexer.updateNode(this.n1);
        indexer.prepare();
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-2:\"valuetwo\"", null, null);
        this.simpleResultSetTest(results);
        ChildAssocRefResultSet r2 = new ChildAssocRefResultSet(this.nodeService, results.getNodeRefs(), null, false);
        this.simpleResultSetTest(r2);
        ChildAssocRefResultSet r3 = new ChildAssocRefResultSet(this.nodeService, results.getNodeRefs(), null, true);
        this.simpleResultSetTest(r3);
        ChildAssocRefResultSet r4 = new ChildAssocRefResultSet(this.nodeService, results.getChildAssocRefs(), null);
        this.simpleResultSetTest(r4);
        DetachedResultSet r5 = new DetachedResultSet(results, null);
        this.simpleResultSetTest(r5);
        DetachedResultSet r6 = new DetachedResultSet(r2, null);
        this.simpleResultSetTest(r6);
        DetachedResultSet r7 = new DetachedResultSet(r3, null);
        this.simpleResultSetTest(r7);
        DetachedResultSet r8 = new DetachedResultSet(r4, null);
        this.simpleResultSetTest(r8);
        DetachedResultSet r9 = new DetachedResultSet(r5, null);
        this.simpleResultSetTest(r9);
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@\\{namespace\\}property\\-1:\"valueone\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@namespace\\:property\\-1:\"valueone\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@property\\-1:\"valueone\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@property\\-1:\"Valueone\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@property\\-1:ValueOne", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@property\\-1:valueone", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(1).getId());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(0)));
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getScore(1)));
        results.close();
        QName qname = QName.createQName("", "property-1");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.n1.toString() + "\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    private void simpleResultSetTest(ResultSet results) {
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(0).getId());
        LuceneTest.assertEquals((Object)this.n2, (Object)results.getNodeRef(0));
        LuceneTest.assertEquals((Object)new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}two"), this.n2), (Object)results.getChildAssocRef(0));
        LuceneTest.assertEquals((int)1, (int)results.getChildAssocRefs().size());
        LuceneTest.assertNotNull(results.getChildAssocRefs());
        LuceneTest.assertEquals((int)0, (int)results.getRow(0).getIndex());
        LuceneTest.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(results.getRow(0).getScore()));
        LuceneTest.assertEquals((Object)new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}two"), this.n2), (Object)results.getRow(0).getChildAssocRef());
        LuceneTest.assertEquals((Object)this.n2, (Object)results.getRow(0).getNodeRef());
        LuceneTest.assertEquals((Object)QName.createQName("{namespace}two"), (Object)results.getRow(0).getQName());
        LuceneTest.assertEquals((Object)"valuetwo", (Object)results.getRow(0).getValue(QName.createQName("{namespace}property-2")));
        for (ResultSetRow row : results) {
            LuceneTest.assertNotNull((Object)row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStandAlonePathIndexer() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@\\{namespace\\}property-1:valueone", null, null);
        try {
            LuceneTest.assertEquals((int)2, (int)results.length());
            LuceneTest.assertEquals((String)this.n1.getId(), (String)results.getNodeRef(0).getId());
            LuceneTest.assertEquals((String)this.n2.getId(), (String)results.getNodeRef(1).getId());
            QName qName = QName.createQName("", "property-1");
        }
        finally {
            results.close();
        }
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+ID:\"" + this.n1.toString() + "\"", null, null);
        try {
            LuceneTest.assertEquals((int)2, (int)results.length());
        }
        finally {
            results.close();
        }
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ID:\"" + this.rootNodeRef.toString() + "\"", null, null);
        try {
            LuceneTest.assertEquals((int)1, (int)results.length());
        }
        finally {
            results.close();
        }
        this.luceneFTS.resume();
    }

    private void buildBaseIndex() {
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}one"), this.n1));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}two"), this.n2));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}three"), this.n3));
        indexer.createNode(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.rootNodeRef, QName.createQName("{namespace}four"), this.n4));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n1, QName.createQName("{namespace}five"), this.n5));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n1, QName.createQName("{namespace}six"), this.n6));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("{namespace}seven"), this.n7));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("{namespace}eight"), this.n8));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName("{namespace}nine"), this.n9));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName("{namespace}ten"), this.n10));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName("{namespace}eleven"), this.n11));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n5, QName.createQName("{namespace}twelve"), this.n12));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n12, QName.createQName("{namespace}thirteen"), this.n13));
        indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n13, QName.createQName("{namespace}fourteen"), this.n14));
        indexer.prepare();
        indexer.commit();
    }

    public void testAllPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    private void runBaseTests() {
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/.\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)8, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null, null);
        LuceneTest.assertEquals((int)26, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null, null);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null, null);
        LuceneTest.assertEquals((int)25, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)25, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)25, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)25, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)25, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen//.\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen//.//.\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        QName qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"1\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":1", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"01\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":01", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + this.escapeQName(qname) + ":\"001\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@test\\:int\\-ista:\"0001\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO 2]", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO 1}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{1 TO 2}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"2\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"02\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"002\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"0002\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[0 TO 2]", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{0 TO 2}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "long-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{2 TO 3}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"3.4\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3 TO 4]", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[3.3 TO 3.4]", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{3.3 TO 3.4}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"3.40\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"03.4\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "float-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"03.40\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "double-ista")) + ":\"5.6\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "double-ista")) + ":\"05.6\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "double-ista")) + ":\"5.60\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "double-ista")) + ":\"05.60\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":[5.5 TO 5.7]", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.5 TO 5.6}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        qname = QName.createQName(TEST_NAMESPACE, "double-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":{5.6 TO 5.7}", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        Date date = new Date();
        String sDate = CachingDateFormat.getDateFormat().format(date);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "date-ista")) + ":\"" + sDate + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "datetime-ista")) + ":\"" + sDate + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "boolean-ista")) + ":\"true\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "qname-ista")) + ":\"{wibble}wobble\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "category-ista")) + ":\"" + DefaultTypeConverter.INSTANCE.convert(String.class, (Object)new NodeRef(this.rootNodeRef.getStoreRef(), "CategoryId")) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "noderef-ista")) + ":\"" + this.n1 + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "path-ista")) + ":\"" + this.nodeService.getPath(this.n3) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(QName.createQName(TEST_NAMESPACE, "path-ista")));
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testType.toString() + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TYPE:\"" + this.testSuperType.toString() + "\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + ISO9075.getXPathName(this.testAspect) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "ASPECT:\"" + ISO9075.getXPathName(this.testSuperAspect) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"fox\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape(ContentModel.PROP_CONTENT.toString()) + ":\"fox\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "@" + LuceneQueryParser.escape(ContentModel.PROP_CONTENT.toString()) + ".mimetype:\"text/plain\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        QName queryQName = QName.createQName("alf:test1", this.namespacePrefixResolver);
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        queryQName = QName.createQName("alf:test2", this.namespacePrefixResolver);
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        queryQName = QName.createQName("alf:test2", this.namespacePrefixResolver);
        QueryParameter qp = new QueryParameter(QName.createQName("alf:banana", this.namespacePrefixResolver), (Serializable)((Object)"woof"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, new QueryParameter[]{qp});
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        queryQName = QName.createQName("alf:test3", this.namespacePrefixResolver);
        qp = new QueryParameter(QName.createQName("alf:banana", this.namespacePrefixResolver), (Serializable)((Object)"/one/five//*"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), queryQName, new QueryParameter[]{qp});
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        QueryParameterDefImpl paramDef = new QueryParameterDefImpl(QName.createQName("alf:lemur", this.namespacePrefixResolver), (DataTypeDefinition)null, true, "fox");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "TEXT:\"${alf:lemur}\"", null, new QueryParameterDefinition[]{paramDef});
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        paramDef = new QueryParameterDefImpl(QName.createQName("alf:intvalue", this.namespacePrefixResolver), (DataTypeDefinition)null, true, "1");
        qname = QName.createQName(TEST_NAMESPACE, "int-ista");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(qname) + ":\"${alf:intvalue}\"", null, new QueryParameterDefinition[]{paramDef});
        LuceneTest.assertEquals((int)1, (int)results.length());
        LuceneTest.assertNotNull((Object)results.getRow(0).getValue(qname));
        results.close();
    }

    public void testPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testXPathSearch() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "xpath", "//./*", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        this.luceneFTS.resume();
        QueryParameterDefImpl paramDef = new QueryParameterDefImpl(QName.createQName("alf:query", this.namespacePrefixResolver), (DataTypeDefinition)null, true, "//./*");
        results = searcher.query(this.rootNodeRef.getStoreRef(), "xpath", "${alf:query}", null, new QueryParameterDefinition[]{paramDef});
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
    }

    public void testMissingIndex() throws Exception {
        this.luceneFTS.pause();
        StoreRef storeRef = new StoreRef("workspace", "_missing_");
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(storeRef, this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(storeRef, "xpath", "//./*", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        this.luceneFTS.resume();
    }

    public void testUpdateIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateNode(this.rootNodeRef);
        indexer.updateNode(this.n1);
        indexer.updateNode(this.n2);
        indexer.updateNode(this.n3);
        indexer.updateNode(this.n4);
        indexer.updateNode(this.n5);
        indexer.updateNode(this.n6);
        indexer.updateNode(this.n7);
        indexer.updateNode(this.n8);
        indexer.updateNode(this.n9);
        indexer.updateNode(this.n10);
        indexer.updateNode(this.n11);
        indexer.updateNode(this.n12);
        indexer.updateNode(this.n13);
        indexer.updateNode(this.n14);
        indexer.commit();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testDeleteLeaf() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.deleteNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n13, QName.createQName("{namespace}fourteen"), this.n14));
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null, null);
        LuceneTest.assertEquals((int)17, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null, null);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testAddEscapedChild() throws Exception {
        String COMPLEX_LOCAL_NAME = " `\u00c2\u00ac\u00c2\u00a6!\"\u00c2\u00a3$%^&*()-_=+\t\n\\\u0000[]{};'#:@~,./<>?\\|\u0123\u4567\u8900\uabcd\uefff_xT65A_";
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        ChildAssociationRef car = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}" + COMPLEX_LOCAL_NAME), this.testSuperType);
        indexer.createNode(car);
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:" + ISO9075.encode(COMPLEX_LOCAL_NAME) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
    }

    public void testNumericInPath() throws Exception {
        String COMPLEX_LOCAL_NAME = "Woof12";
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        ChildAssociationRef car = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}" + COMPLEX_LOCAL_NAME), this.testSuperType);
        indexer.createNode(car);
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:" + ISO9075.encode(COMPLEX_LOCAL_NAME) + "\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
    }

    public void testDeleteContainer() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.deleteNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n12, QName.createQName("{namespace}thirteen"), this.n13));
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null, null);
        LuceneTest.assertEquals((int)13, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null, null);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null, null);
        LuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)12, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDeleteAndAddReference() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.removeChild(this.n2, this.n13);
        indexer.deleteChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("{namespace}link"), this.n13));
        indexer.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:three\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:four\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:one\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:two\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:six\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:seven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-2\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-1\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:two/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:eight-0\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:ten\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:eleven\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:five/namespace:twelve/namespace:thirteen/namespace:fourteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/namespace:*/namespace:*/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:*/namespace:five/namespace:*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/namespace:*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/*/*/*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*\"", null, null);
        LuceneTest.assertEquals((int)4, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*/namespace:five/*\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/namespace:one/*/namespace:nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//.\"", null, null);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//.\"", null, null);
        LuceneTest.assertEquals((int)23, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*\"", null, null);
        LuceneTest.assertEquals((int)22, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/.\"", null, null);
        LuceneTest.assertEquals((int)22, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//*/./.\"", null, null);
        LuceneTest.assertEquals((int)22, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//./*\"", null, null);
        LuceneTest.assertEquals((int)22, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)14, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//././*/././.\"", null, null);
        LuceneTest.assertEquals((int)22, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//common\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one//common\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//*\"", null, null);
        LuceneTest.assertEquals((int)9, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)7, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"/one/five//.\"", null, null);
        LuceneTest.assertEquals((int)10, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//five/nine\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/one//thirteen/fourteen\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName("{namespace}link"));
        indexer.createChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("{namespace}link"), this.n13));
        indexer.commit();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testRenameReference() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:link//.\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//namespace:link//.\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:renamed_link//.\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        this.nodeService.removeChild(this.n2, this.n13);
        this.nodeService.addChild(this.n2, this.n13, ASSOC_TYPE_QNAME, QName.createQName("{namespace}renamed_link"));
        indexer.updateChildRelationship(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("namespace", "link"), this.n13), new ChildAssociationRef(ASSOC_TYPE_QNAME, this.n2, QName.createQName("namespace", "renamed_link"), this.n13));
        indexer.commit();
        this.runBaseTests();
        searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setDictionaryService(this.dictionaryService);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:link//.\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"//namespace:renamed_link//.\"", null, null);
        LuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH_WITH_REPEATS:\"//namespace:renamed_link//.\"", null, null);
        LuceneTest.assertEquals((int)3, (int)results.length());
        results.close();
        this.luceneFTS.resume();
    }

    public void testDelayIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-atomic")) + ":\"KEYONE\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-nonatomic")) + ":\"KEYTWO\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateFullTextSearch(1000);
        indexer.prepare();
        indexer.commit();
        searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setDictionaryService(this.dictionaryService);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-atomic")) + ":\"keyone\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-nonatomic")) + ":\"keytwo\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-unstored-tokenised-atomic")) + ":\"keyunstored\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.runBaseTests();
        this.luceneFTS.resume();
    }

    public void testWaitForIndex() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-atomic")) + ":\"KEYONE\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-nonatomic")) + ":\"KEYTWO\"", null, null);
        LuceneTest.assertEquals((int)0, (int)results.length());
        results.close();
        searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-atomic")) + ":\"keyone\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        indexer.updateFullTextSearch(1000);
        indexer.prepare();
        indexer.commit();
        this.luceneFTS.resume();
        Thread.sleep(35000L);
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-stored-tokenised-nonatomic")) + ":\"keytwo\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "\\@" + this.escapeQName(QName.createQName(TEST_NAMESPACE, "text-indexed-unstored-tokenised-atomic")) + ":\"KEYUNSTORED\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        this.runBaseTests();
    }

    private String escapeQName(QName qname) {
        return LuceneQueryParser.escape(qname.toString());
    }

    public void testForKev() throws Exception {
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PARENT:\"" + this.rootNodeRef.toString() + "\"", null, null);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "+PARENT:\"" + this.rootNodeRef.toString() + "\" +QNAME:\"one\"", null, null);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "( +TYPE:\"{http://www.alfresco.org/model/content/1.0}content\" +@\\{http\\://www.alfresco.org/model/content/1.0\\}name:\"content woof\") OR  TEXT:\"content\"", null, null);
        this.luceneFTS.resume();
    }

    public void testIssueAR47() throws Exception {
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        ChildAssociationRef testFind = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}testFind"), this.testSuperType);
        tx.commit();
        LuceneSearcherImpl searcher = LuceneSearcherImpl.getSearcher(this.rootNodeRef.getStoreRef(), this.indexerAndSearcher);
        searcher.setNodeService(this.nodeService);
        searcher.setDictionaryService(this.dictionaryService);
        searcher.setNamespacePrefixResolver(this.getNamespacePrefixReolsver("namespace"));
        searcher.setQueryRegister(this.queryRegisterComponent);
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        for (int i = 0; i < 100; ++i) {
            UserTransaction tx1 = this.transactionService.getUserTransaction();
            tx1.begin();
            ChildAssociationRef test = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}test"), this.testSuperType);
            tx1.commit();
            UserTransaction tx2 = this.transactionService.getUserTransaction();
            tx2.begin();
            this.nodeService.deleteNode(test.getChildRef());
            tx2.commit();
        }
        UserTransaction tx3 = this.transactionService.getUserTransaction();
        tx3.begin();
        results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "QNAME:\"namespace:testFind\"");
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx3.commit();
    }

    public void testReadAgainstDelta() throws Exception {
        this.testTX.commit();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.luceneFTS.pause();
        this.buildBaseIndex();
        this.runBaseTests();
        tx.commit();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.runBaseTests();
        this.serviceRegistry.getNodeService().deleteNode(this.n1);
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        tx.rollback();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.runBaseTests();
        LuceneTest.assertEquals((int)5, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}texas"), this.testSuperType).getChildRef();
        LuceneTest.assertEquals((int)6, (int)this.serviceRegistry.getNodeService().getChildAssocs(this.rootNodeRef).size());
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)16, (int)results.length());
        results.close();
        tx.rollback();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.runBaseTests();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        this.nodeService.setProperty(this.n1, QName.createQName("{namespace}property-1"), (Serializable)((Object)"Different"));
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)1, (int)results.length());
        results.close();
        tx.rollback();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("\\@\\{namespace\\}property\\-1:\"valueone\"");
        sp.excludeDataInTheCurrentTransaction(false);
        sp.addSort("ID", true);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)2, (int)results.length());
        results.close();
        tx = this.transactionService.getUserTransaction();
        tx.begin();
        this.runBaseTests();
        this.serviceRegistry.getNodeService().deleteNode(this.n1);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        NodeRef created = this.serviceRegistry.getNodeService().createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}texas"), this.testSuperType).getChildRef();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)6, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        this.serviceRegistry.getNodeService().deleteNode(created);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)5, (int)results.length());
        results.close();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.excludeDataInTheCurrentTransaction(true);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
        tx.rollback();
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"//.\"");
        sp.addSort("ID", true);
        sp.excludeDataInTheCurrentTransaction(false);
        results = this.serviceRegistry.getSearchService().query(sp);
        LuceneTest.assertEquals((int)15, (int)results.length());
        results.close();
    }

    private void runPerformanceTest(double time, boolean clear) {
        LuceneIndexerImpl indexer = LuceneIndexerImpl.getUpdateIndexer(this.rootNodeRef.getStoreRef(), "delta" + System.currentTimeMillis() + "_" + new Random().nextInt(), this.indexerAndSearcher);
        indexer.setNodeService(this.nodeService);
        indexer.setLuceneIndexLock(this.luceneIndexLock);
        indexer.setDictionaryService(this.dictionaryService);
        indexer.setLuceneFullTextSearchIndexer(this.luceneFTS);
        indexer.setContentService(this.contentService);
        if (clear) {
            // empty if block
        }
        indexer.createNode(new ChildAssociationRef(null, null, null, this.rootNodeRef));
        long startTime = System.currentTimeMillis();
        int count = 0;
        for (int i = 0; i < 10000000; ++i) {
            if (i % 10 == 0 && (double)(System.currentTimeMillis() - startTime) > time) {
                count = i;
                break;
            }
            QName qname = QName.createQName("{namespace}a_" + i);
            NodeRef ref = this.nodeService.createNode(this.rootNodeRef, ASSOC_TYPE_QNAME, qname, ContentModel.TYPE_CONTAINER).getChildRef();
            indexer.createNode(new ChildAssociationRef(ASSOC_TYPE_QNAME, this.rootNodeRef, qname, ref));
        }
        indexer.commit();
        float delta = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("alf", "http://www.alfresco.org");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("test", TEST_NAMESPACE);
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    public static void main(String[] args) throws Exception {
        LuceneTest test = new LuceneTest();
        test.setUp();
        NodeRef targetNode = test.rootNodeRef;
        Path path = test.serviceRegistry.getNodeService().getPath(targetNode);
        SearchParameters sp = new SearchParameters();
        sp.addStore(test.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("PATH:\"" + path + "//." + "\"");
        ResultSet results = test.serviceRegistry.getSearchService().query(sp);
        results.close();
    }

    class Nester
    extends Thread {
        Thread waiter;

        Nester(String name, Thread waiter) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            LuceneTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            if (this.waiter != null) {
                this.waiter.start();
            }
            try {
                System.out.println("Start " + this.getName());
                UserTransaction tx1 = LuceneTest.this.transactionService.getUserTransaction();
                tx1.begin();
                for (int i = 0; i < 20; ++i) {
                    HashSet<ChildAssociationRef> refs = new HashSet<ChildAssociationRef>();
                    for (int j = 0; j < i; ++j) {
                        ChildAssociationRef test = LuceneTest.this.nodeService.createNode(LuceneTest.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName("{namespace}test"), LuceneTest.this.testSuperType);
                        refs.add(test);
                    }
                    for (ChildAssociationRef car : refs) {
                        LuceneTest.this.nodeService.deleteNode(car.getChildRef());
                    }
                }
                tx1.commit();
                System.out.println("End " + this.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(12);
            }
            finally {
                LuceneTest.this.authenticationComponent.clearCurrentSecurityContext();
            }
            if (this.waiter != null) {
                try {
                    this.waiter.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

