/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.alfresco.util.CachingDateFormat;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.WhitespaceTokenizer;

public class DateTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;

    public DateTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new WhitespaceTokenizer(in);
    }

    public Token next() throws IOException {
        Token candidate;
        SimpleDateFormat df = CachingDateFormat.getDateFormat();
        SimpleDateFormat dof = CachingDateFormat.getDateOnlyFormat();
        while ((candidate = this.baseTokeniser.next()) != null) {
            Date date;
            try {
                date = df.parse(candidate.termText());
            }
            catch (ParseException e) {
                continue;
            }
            String valueString = dof.format(date);
            Token integerToken = new Token(valueString, candidate.startOffset(), candidate.startOffset(), candidate.type());
            return integerToken;
        }
        return null;
    }
}

