/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.alfresco.repo.search.impl.lucene.analysis.NumericEncoder;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.StandardTokenizer;

public class DoubleTokenFilter
extends Tokenizer {
    Tokenizer baseTokeniser;

    public DoubleTokenFilter(Reader in) {
        super(in);
        this.baseTokeniser = new StandardTokenizer(in);
    }

    public Token next() throws IOException {
        Token candidate;
        while ((candidate = this.baseTokeniser.next()) != null) {
            try {
                Double d = Double.valueOf(candidate.termText());
                String valueString = NumericEncoder.encode(d);
                Token doubleToken = new Token(valueString, candidate.startOffset(), candidate.startOffset(), candidate.type());
                return doubleToken;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
        return null;
    }
}

