/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.fts;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.alfresco.repo.search.IndexerSPI;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerException;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.service.cmr.repository.StoreRef;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FullTextSearchIndexerImpl
implements FTSIndexerAware,
FullTextSearchIndexer {
    private static Set<StoreRef> requiresIndex = new LinkedHashSet<StoreRef>();
    private static Set<StoreRef> indexing = new HashSet<StoreRef>();
    LuceneIndexerAndSearcher luceneIndexerAndSearcherFactory;
    private int pauseCount = 0;
    private boolean paused = false;

    public synchronized void requiresIndex(StoreRef storeRef) {
        requiresIndex.add(storeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void indexCompleted(StoreRef storeRef, int remaining, Exception e) {
        try {
            indexing.remove(storeRef);
            if (remaining > 0 || e != null) {
                this.requiresIndex(storeRef);
            }
            if (e != null) {
                throw new FTSIndexerException(e);
            }
        }
        finally {
            this.notifyAll();
        }
    }

    public synchronized void pause() throws InterruptedException {
        ++this.pauseCount;
        while (indexing.size() > 0) {
            this.wait();
        }
        --this.pauseCount;
        if (this.pauseCount == 0) {
            this.paused = true;
            this.notifyAll();
        }
    }

    public synchronized void resume() throws InterruptedException {
        if (this.pauseCount == 0) {
            this.paused = false;
        } else {
            while (this.pauseCount > 0) {
                this.wait();
            }
            this.paused = false;
        }
    }

    private synchronized boolean isPaused() throws InterruptedException {
        if (this.pauseCount == 0) {
            return this.paused;
        }
        while (this.pauseCount > 0) {
            this.wait();
        }
        return this.paused;
    }

    public void index() {
        StoreRef toIndex = this.getNextRef();
        if (toIndex != null) {
            IndexerSPI indexer = this.luceneIndexerAndSearcherFactory.getIndexer(toIndex);
            indexer.registerCallBack(this);
            indexer.updateFullTextSearch(1000);
        }
    }

    private synchronized StoreRef getNextRef() {
        if (this.paused || this.pauseCount > 0) {
            return null;
        }
        StoreRef nextStoreRef = null;
        for (StoreRef ref : requiresIndex) {
            if (indexing.contains(ref)) continue;
            nextStoreRef = ref;
        }
        if (nextStoreRef != null) {
            requiresIndex.remove(nextStoreRef);
            indexing.add(nextStoreRef);
        }
        return nextStoreRef;
    }

    public void setLuceneIndexerAndSearcherFactory(LuceneIndexerAndSearcher luceneIndexerAndSearcherFactory) {
        this.luceneIndexerAndSearcherFactory = luceneIndexerAndSearcherFactory;
    }

    public static void main(String[] args) throws InterruptedException {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:alfresco/application-context.xml");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        ACTIVE,
        PAUSING,
        PAUSED;

    }
}

