/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.zip.CRC32;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.FilterIndexReaderByNodeRefs2;
import org.alfresco.repo.search.impl.lucene.index.IndexEntry;
import org.alfresco.repo.search.impl.lucene.index.IndexType;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCounting;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCountingReadOnlyIndexReaderFactory;
import org.alfresco.repo.search.impl.lucene.index.TransactionStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.util.GUID;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexInfo {
    private static Logger s_logger = Logger.getLogger(IndexInfo.class);
    private static final boolean useNIOMemoryMapping = true;
    private static String INDEX_INFO = "IndexInfo";
    private static String INDEX_INFO_BACKUP = "IndexInfoBackup";
    private static String INDEX_INFO_DELETIONS = "IndexInfoDeletions";
    private static String OLD_INDEX = "index";
    private boolean indexIsShared = false;
    private File indexDirectory;
    private RandomAccessFile indexInfoRAF;
    private FileChannel indexInfoChannel;
    private RandomAccessFile indexInfoBackupRAF;
    private FileChannel indexInfoBackupChannel;
    private long version = -1L;
    private LinkedHashMap<String, IndexEntry> indexEntries = new LinkedHashMap();
    private ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private HashMap<String, IndexReader> referenceCountingReadOnlyIndexReaders = new HashMap();
    private IndexReader mainIndexReader;
    private Map<String, IndexWriter> indexWriters = Collections.synchronizedMap(new HashMap());
    private Map<String, IndexReader> indexReaders = Collections.synchronizedMap(new HashMap());
    private EnumMap<TransactionStatus, Transition> transitions = new EnumMap(TransactionStatus.class);
    private ConcurrentLinkedQueue<String> deleteQueue = new ConcurrentLinkedQueue();
    private Cleaner cleaner = new Cleaner();
    private Thread cleanerThread;
    private Merger merger = new Merger();
    private Thread mergerThread;
    private Directory emptyIndex = new RAMDirectory();
    private static HashMap<File, IndexInfo> indexInfos = new HashMap();

    public static synchronized IndexInfo getIndexInfo(File file) {
        IndexInfo indexInfo = indexInfos.get(file);
        if (indexInfo == null) {
            indexInfo = new IndexInfo(file);
            indexInfos.put(file, indexInfo);
        }
        return indexInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexInfo(File indexDirectory) {
        this.initialiseTransitions();
        this.indexDirectory = indexDirectory;
        if (!this.indexDirectory.exists() && !this.indexDirectory.mkdirs()) {
            throw new AlfrescoRuntimeException("Failed to create index directory");
        }
        if (!this.indexDirectory.isDirectory()) {
            throw new AlfrescoRuntimeException("The index must be held in a directory");
        }
        File indexInfoFile = new File(this.indexDirectory, INDEX_INFO);
        File indexInfoBackupFile = new File(this.indexDirectory, INDEX_INFO_BACKUP);
        if (IndexInfo.createFile(indexInfoFile) && IndexInfo.createFile(indexInfoBackupFile)) {
            this.version = 0L;
        }
        this.indexInfoRAF = IndexInfo.openFile(indexInfoFile);
        this.indexInfoChannel = this.indexInfoRAF.getChannel();
        this.indexInfoBackupRAF = IndexInfo.openFile(indexInfoBackupFile);
        this.indexInfoBackupChannel = this.indexInfoBackupRAF.getChannel();
        if (this.version == 0L) {
            final File oldIndex = new File(this.indexDirectory, OLD_INDEX);
            if (IndexReader.indexExists((File)oldIndex)) {
                this.getWriteLock();
                try {
                    this.doWithFileLock(new LockWork<Object>(){

                        @Override
                        public Object doWork() throws Exception {
                            try {
                                IndexWriter writer = new IndexWriter(oldIndex, (Analyzer)new StandardAnalyzer(), false);
                                writer.optimize();
                                long docs = writer.docCount();
                                writer.close();
                                IndexInfo.this.indexEntries.put(OLD_INDEX, new IndexEntry(IndexType.INDEX, OLD_INDEX, "", TransactionStatus.COMMITTED, "", docs, 0L, false));
                                IndexInfo.this.writeStatus();
                            }
                            catch (IOException e) {
                                throw new IndexerException("Failed to optimise old index");
                            }
                            return null;
                        }
                    });
                }
                finally {
                    this.releaseWriteLock();
                }
            }
        } else if (this.version == -1L) {
            this.getWriteLock();
            try {
                this.doWithFileLock(new LockWork<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object doWork() throws Exception {
                        IndexInfo.this.setStatusFromFile();
                        if (!IndexInfo.this.indexIsShared) {
                            HashSet<String> deletable = new HashSet<String>();
                            for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                                switch (entry.getStatus()) {
                                    case ACTIVE: 
                                    case MARKED_ROLLBACK: 
                                    case NO_TRANSACTION: 
                                    case PREPARING: 
                                    case ROLLEDBACK: 
                                    case ROLLINGBACK: 
                                    case MERGE_TARGET: 
                                    case UNKNOWN: 
                                    case PREPARED: 
                                    case DELETABLE: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Deleting index entry " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.DELETABLE);
                                        deletable.add(entry.getName());
                                        break;
                                    }
                                    case COMMITTED_DELETING: 
                                    case MERGE: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Resetting merge to committed " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.COMMITTED);
                                        break;
                                    }
                                    case COMMITTING: {
                                        if (s_logger.isInfoEnabled()) {
                                            s_logger.info((Object)("Committing " + entry));
                                        }
                                        entry.setStatus(TransactionStatus.COMMITTED);
                                        IndexInfo.this.mainIndexReader = null;
                                        break;
                                    }
                                }
                            }
                            for (String id : deletable) {
                                IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.remove(id);
                                IndexInfo.this.deleteQueue.add(id);
                            }
                            Runnable runnable = IndexInfo.this.cleaner;
                            synchronized (runnable) {
                                IndexInfo.this.cleaner.notify();
                            }
                            runnable = IndexInfo.this.merger;
                            synchronized (runnable) {
                                IndexInfo.this.merger.notify();
                            }
                            IndexInfo.this.writeStatus();
                        }
                        return null;
                    }
                });
            }
            finally {
                this.releaseWriteLock();
            }
        }
        this.cleanerThread = new Thread(this.cleaner);
        this.cleanerThread.setDaemon(true);
        this.cleanerThread.setName("Index cleaner thread");
        this.cleanerThread.start();
        this.mergerThread = new Thread(this.merger);
        this.mergerThread.setDaemon(true);
        this.mergerThread.setName("Index merger thread");
        this.mergerThread.start();
        try {
            IndexWriter writer = new IndexWriter(this.emptyIndex, (Analyzer)new StandardAnalyzer(), true);
            writer.setUseCompoundFile(true);
            writer.minMergeDocs = 1000;
            writer.mergeFactor = 5;
            writer.maxMergeDocs = 1000000;
        }
        catch (IOException e) {
            throw new IndexerException("Failed to create an empty in memory index!");
        }
    }

    public IndexReader getDeltaIndexReader(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexReader reader = this.indexReaders.get(id);
        if (reader == null) {
            this.closeDeltaIndexWriter(id);
            File location = this.ensureDeltaIsRegistered(id);
            reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)this.emptyIndex);
            this.indexReaders.put(id, reader);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File ensureDeltaIsRegistered(String id) throws IOException {
        File location;
        block8: {
            if (id == null) {
                throw new IndexerException("\"null\" is not a valid identifier for a transaction");
            }
            location = new File(this.indexDirectory, id);
            this.getReadLock();
            try {
                if (this.indexEntries.containsKey(id)) break block8;
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (!this.indexEntries.containsKey(id)) {
                        this.indexEntries.put(id, new IndexEntry(IndexType.DELTA, id, "", TransactionStatus.ACTIVE, "", 0L, 0L, false));
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            finally {
                this.releaseReadLock();
            }
        }
        return location;
    }

    private IndexWriter makeDeltaIndexWriter(File location, Analyzer analyzer) throws IOException {
        if (!IndexReader.indexExists((File)location)) {
            IndexWriter creator = new IndexWriter(location, analyzer, true);
            creator.setUseCompoundFile(true);
            creator.minMergeDocs = 1000;
            creator.mergeFactor = 5;
            creator.maxMergeDocs = 1000000;
            return creator;
        }
        return null;
    }

    public IndexWriter getDeltaIndexWriter(String id, Analyzer analyzer) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexWriter writer = this.indexWriters.get(id);
        if (writer == null) {
            this.closeDeltaIndexReader(id);
            File location = this.ensureDeltaIsRegistered(id);
            writer = this.makeDeltaIndexWriter(location, analyzer);
            if (writer == null) {
                writer = new IndexWriter(location, analyzer, false);
                writer.setUseCompoundFile(true);
                writer.minMergeDocs = 1000;
                writer.mergeFactor = 5;
                writer.maxMergeDocs = 1000000;
            }
            this.indexWriters.put(id, writer);
        }
        return writer;
    }

    public void closeDeltaIndexReader(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexReader reader = this.indexReaders.remove(id);
        if (reader != null) {
            reader.close();
        }
    }

    public void closeDeltaIndexWriter(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        IndexWriter writer = this.indexWriters.remove(id);
        if (writer != null) {
            writer.close();
        }
    }

    public void closeDelta(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        this.closeDeltaIndexReader(id);
        this.closeDeltaIndexWriter(id);
    }

    public Set<NodeRef> getDeletions(String id) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        HashSet<NodeRef> deletions = new HashSet<NodeRef>();
        File location = new File(this.indexDirectory, id);
        File file = new File(location, INDEX_INFO_DELETIONS);
        if (!file.exists()) {
            return Collections.emptySet();
        }
        DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        int size = is.readInt();
        for (int i = 0; i < size; ++i) {
            String ref = is.readUTF();
            deletions.add(new NodeRef(ref));
        }
        is.close();
        return deletions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreparedState(String id, Set<NodeRef> toDelete, long documents, boolean deleteNodesOnly) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        if (toDelete.size() > 0) {
            File location = new File(this.indexDirectory, id);
            if (!location.exists() && !location.mkdirs()) {
                throw new IndexerException("Failed to make index directory " + location);
            }
            DataOutputStream os = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(new File(location, INDEX_INFO_DELETIONS))));
            os.writeInt(toDelete.size());
            for (NodeRef ref : toDelete) {
                os.writeUTF(ref.toString());
            }
            os.flush();
            os.close();
        }
        this.getWriteLock();
        try {
            IndexEntry entry = this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Invalid index delta id " + id);
            }
            if (entry.getStatus() != TransactionStatus.PREPARING && entry.getStatus() != TransactionStatus.COMMITTING) {
                throw new IndexerException("Deletes and doc count can only be set on a preparing index");
            }
            entry.setDocumentCount(documents);
            entry.setDeletions(toDelete.size());
            entry.setDeletOnlyNodes(deleteNodesOnly);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getMainIndexReferenceCountingReadOnlyIndexReader() throws IOException {
        this.getReadLock();
        try {
            if (this.indexIsShared && !this.checkVersion()) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    this.mainIndexReader = null;
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            if (this.mainIndexReader == null) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (this.mainIndexReader == null) {
                        this.doWithFileLock(new LockWork<Object>(){

                            @Override
                            public Object doWork() throws Exception {
                                return null;
                            }
                        });
                        this.mainIndexReader = this.createMainIndexReader();
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            ReferenceCounting refCount = (ReferenceCounting)this.mainIndexReader;
            refCount.incrementReferenceCount();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Main index reader references = " + refCount.getReferenceCount()));
            }
            IndexReader indexReader = this.mainIndexReader;
            return indexReader;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexReader getMainIndexReferenceCountingReadOnlyIndexReader(String id, Set<NodeRef> deletions, boolean deleteOnlyNodes) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        this.getReadLock();
        try {
            MultiReader reader;
            if (this.indexIsShared && !this.checkVersion()) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    this.mainIndexReader = null;
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            if (this.mainIndexReader == null) {
                this.releaseReadLock();
                this.getWriteLock();
                try {
                    if (this.mainIndexReader == null) {
                        this.doWithFileLock(new LockWork<Object>(){

                            @Override
                            public Object doWork() throws Exception {
                                return null;
                            }
                        });
                        this.mainIndexReader = this.createMainIndexReader();
                    }
                }
                finally {
                    this.getReadLock();
                    this.releaseWriteLock();
                }
            }
            ReferenceCounting refCount = (ReferenceCounting)this.mainIndexReader;
            refCount.incrementReferenceCount();
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Main index reader references = " + refCount.getReferenceCount()));
            }
            IndexReader deltaReader = ReferenceCountingReadOnlyIndexReaderFactory.createReader(id, this.getDeltaIndexReader(id));
            ReferenceCounting deltaRefCount = (ReferenceCounting)deltaReader;
            deltaRefCount.incrementReferenceCount();
            MultiReader multiReader = reader = new MultiReader(new IndexReader[]{new FilterIndexReaderByNodeRefs2(this.mainIndexReader, deletions, deleteOnlyNodes), deltaReader});
            return multiReader;
        }
        finally {
            this.releaseReadLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(final String id, final TransactionStatus state, final Set<Term> toDelete, final Set<Term> read) throws IOException {
        if (id == null) {
            throw new IndexerException("\"null\" is not a valid identifier for a transaction");
        }
        final Transition transition = this.getTransition(state);
        this.getWriteLock();
        try {
            if (transition.requiresFileLock()) {
                this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("Start Index " + id + " state = " + (Object)((Object)state)));
                        }
                        IndexInfo.this.dumpInfo();
                        transition.transition(id, toDelete, read);
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("End Index " + id + " state = " + (Object)((Object)state)));
                        }
                        IndexInfo.this.dumpInfo();
                        return null;
                    }
                });
            } else {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Start Index " + id + " state = " + (Object)((Object)state)));
                }
                this.dumpInfo();
                transition.transition(id, toDelete, read);
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("End Index " + id + " state = " + (Object)((Object)state)));
                }
                this.dumpInfo();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private Transition getTransition(TransactionStatus state) {
        Transition transition = this.transitions.get((Object)state);
        if (transition != null) {
            return transition;
        }
        throw new IndexerException("Invalid state " + (Object)((Object)state));
    }

    private void initialiseTransitions() {
        this.transitions.put(TransactionStatus.PREPARING, new PreparingTransition());
        this.transitions.put(TransactionStatus.PREPARED, new PreparedTransition());
        this.transitions.put(TransactionStatus.COMMITTING, new CommittingTransition());
        this.transitions.put(TransactionStatus.COMMITTED, new CommittedTransition());
        this.transitions.put(TransactionStatus.ROLLINGBACK, new RollingBackTransition());
        this.transitions.put(TransactionStatus.ROLLEDBACK, new RolledBackTransition());
        this.transitions.put(TransactionStatus.DELETABLE, new DeletableTransition());
        this.transitions.put(TransactionStatus.ACTIVE, new ActiveTransition());
    }

    private static boolean createFile(File file) {
        if (!file.exists()) {
            try {
                file.createNewFile();
                return true;
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("Failed to create info file", (Throwable)e);
            }
        }
        return false;
    }

    private static RandomAccessFile openFile(File file) {
        try {
            return new RandomAccessFile(file, "rw");
        }
        catch (FileNotFoundException e) {
            throw new AlfrescoRuntimeException("Failed to open index info file", (Throwable)e);
        }
    }

    private void setStatusFromFile() throws IOException {
        try {
            this.setStatusFromFile(this.indexInfoChannel);
        }
        catch (IOException e) {
            this.setStatusFromFile(this.indexInfoBackupChannel);
        }
        this.clearOldReaders();
    }

    private void clearOldReaders() throws IOException {
        HashSet<String> valid = new HashSet<String>();
        for (String id : this.indexEntries.keySet()) {
            IndexEntry entry = this.indexEntries.get(id);
            if (!entry.getStatus().isCommitted()) continue;
            valid.add(id);
        }
        HashSet<String> inValid = new HashSet<String>();
        for (String id : this.referenceCountingReadOnlyIndexReaders.keySet()) {
            if (valid.contains(id)) continue;
            inValid.add(id);
        }
        boolean hasInvalid = false;
        for (String id : inValid) {
            IndexReader reader = this.referenceCountingReadOnlyIndexReaders.remove(id);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("... invalidating sub reader " + id));
            }
            ReferenceCounting referenceCounting = (ReferenceCounting)reader;
            referenceCounting.setInvalidForReuse();
            hasInvalid = true;
        }
        if (hasInvalid) {
            if (this.mainIndexReader != null) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)"... invalidating main index reader");
                }
                ((ReferenceCounting)this.mainIndexReader).setInvalidForReuse();
            }
            this.mainIndexReader = null;
        }
    }

    private IndexReader createMainIndexReader() throws IOException {
        IndexReader reader = null;
        for (String id : this.indexEntries.keySet()) {
            IndexEntry entry = this.indexEntries.get(id);
            if (!entry.getStatus().isCommitted()) continue;
            IndexReader subReader = this.getReferenceCountingIndexReader(id);
            if (reader == null) {
                reader = subReader;
                continue;
            }
            if (entry.getType() == IndexType.INDEX) {
                reader = new MultiReader(new IndexReader[]{reader, subReader});
                continue;
            }
            if (entry.getType() != IndexType.DELTA) continue;
            reader = new MultiReader(new IndexReader[]{new FilterIndexReaderByNodeRefs2(reader, this.getDeletions(entry.getName()), entry.isDeletOnlyNodes()), subReader});
        }
        if (reader == null) {
            reader = IndexReader.open((Directory)this.emptyIndex);
        }
        reader = ReferenceCountingReadOnlyIndexReaderFactory.createReader("MainReader", reader);
        return reader;
    }

    private IndexReader getReferenceCountingIndexReader(String id) throws IOException {
        IndexReader reader = this.referenceCountingReadOnlyIndexReaders.get(id);
        if (reader == null) {
            File location = new File(this.indexDirectory, id);
            reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)this.emptyIndex);
            reader = ReferenceCountingReadOnlyIndexReaderFactory.createReader(id, reader);
            this.referenceCountingReadOnlyIndexReaders.put(id, reader);
        }
        ReferenceCounting referenceCounting = (ReferenceCounting)reader;
        referenceCounting.incrementReferenceCount();
        return reader;
    }

    private boolean checkVersion() throws IOException {
        try {
            return this.checkVersion(this.indexInfoChannel);
        }
        catch (IOException e) {
            try {
                return this.checkVersion(this.indexInfoBackupChannel);
            }
            catch (IOException ee) {
                return false;
            }
        }
    }

    private boolean checkVersion(FileChannel channel) throws IOException {
        if (channel.size() > 0L) {
            channel.position(0L);
            MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, 8L);
            mbb.load();
            MappedByteBuffer buffer = mbb;
            ((ByteBuffer)buffer).position(0);
            long onDiskVersion = buffer.getLong();
            return this.version == onDiskVersion;
        }
        return this.version == 0L;
    }

    private void setStatusFromFile(FileChannel channel) throws IOException {
        if (channel.size() > 0L) {
            channel.position(0L);
            MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            mbb.load();
            MappedByteBuffer buffer = mbb;
            ((ByteBuffer)buffer).position(0);
            long onDiskVersion = buffer.getLong();
            if (this.version != onDiskVersion) {
                CRC32 crc32 = new CRC32();
                crc32.update((int)(onDiskVersion >>> 32) & 0xFFFFFFFF);
                crc32.update((int)(onDiskVersion >>> 0) & 0xFFFFFFFF);
                int size = buffer.getInt();
                crc32.update(size);
                LinkedHashMap<String, IndexEntry> newIndexEntries = new LinkedHashMap<String, IndexEntry>();
                for (int i = 0; i < size; ++i) {
                    boolean isDeletOnlyNodes;
                    TransactionStatus status;
                    IndexType indexType;
                    String indexTypeString = this.readString(buffer, crc32);
                    try {
                        indexType = IndexType.valueOf(indexTypeString);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Invalid type " + indexTypeString);
                    }
                    String name = this.readString(buffer, crc32);
                    String parentName = this.readString(buffer, crc32);
                    String txStatus = this.readString(buffer, crc32);
                    try {
                        status = TransactionStatus.valueOf(txStatus);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Invalid status " + txStatus);
                    }
                    String mergeId = this.readString(buffer, crc32);
                    long documentCount = buffer.getLong();
                    crc32.update((int)(documentCount >>> 32) & 0xFFFFFFFF);
                    crc32.update((int)(documentCount >>> 0) & 0xFFFFFFFF);
                    long deletions = buffer.getLong();
                    crc32.update((int)(deletions >>> 32) & 0xFFFFFFFF);
                    crc32.update((int)(deletions >>> 0) & 0xFFFFFFFF);
                    byte deleteOnlyNodesFlag = buffer.get();
                    crc32.update(deleteOnlyNodesFlag);
                    boolean bl = isDeletOnlyNodes = deleteOnlyNodesFlag == 1;
                    if (status.isTransient()) continue;
                    newIndexEntries.put(name, new IndexEntry(indexType, name, parentName, status, mergeId, documentCount, deletions, isDeletOnlyNodes));
                }
                long onDiskCRC32 = buffer.getLong();
                if (crc32.getValue() == onDiskCRC32) {
                    for (IndexEntry entry : this.indexEntries.values()) {
                        if (!entry.getStatus().isTransient()) continue;
                        newIndexEntries.put(entry.getName(), entry);
                    }
                    this.version = onDiskVersion;
                    this.indexEntries = newIndexEntries;
                } else {
                    throw new IOException("Invalid file check sum");
                }
            }
        }
    }

    private String readString(ByteBuffer buffer, CRC32 crc32) throws UnsupportedEncodingException {
        int size = buffer.getInt();
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        char[] chars = new char[size];
        for (int i = 0; i < size; ++i) {
            chars[i] = (char)bytes[i];
        }
        crc32.update(bytes);
        return new String(chars);
    }

    private void writeString(ByteBuffer buffer, CRC32 crc32, String string) throws UnsupportedEncodingException {
        char[] chars = string.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] > '\u00ff') {
                throw new UnsupportedEncodingException();
            }
            bytes[i] = (byte)chars[i];
        }
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        crc32.update(bytes);
    }

    private void writeStatus() throws IOException {
        ++this.version;
        this.writeStatusToFile(this.indexInfoChannel);
        this.writeStatusToFile(this.indexInfoBackupChannel);
    }

    private void writeStatusToFile(FileChannel channel) throws IOException {
        long size = this.getBufferSize();
        MappedByteBuffer mbb = channel.map(FileChannel.MapMode.READ_WRITE, 0L, size);
        mbb.load();
        MappedByteBuffer buffer = mbb;
        ((ByteBuffer)buffer).position(0);
        buffer.putLong(this.version);
        CRC32 crc32 = new CRC32();
        crc32.update((int)(this.version >>> 32) & 0xFFFFFFFF);
        crc32.update((int)(this.version >>> 0) & 0xFFFFFFFF);
        buffer.putInt(this.indexEntries.size());
        crc32.update(this.indexEntries.size());
        for (IndexEntry entry : this.indexEntries.values()) {
            byte[] byArray;
            String entryType = entry.getType().toString();
            this.writeString(buffer, crc32, entryType);
            this.writeString(buffer, crc32, entry.getName());
            this.writeString(buffer, crc32, entry.getParentName());
            String entryStatus = entry.getStatus().toString();
            this.writeString(buffer, crc32, entryStatus);
            this.writeString(buffer, crc32, entry.getMergeId());
            buffer.putLong(entry.getDocumentCount());
            crc32.update((int)(entry.getDocumentCount() >>> 32) & 0xFFFFFFFF);
            crc32.update((int)(entry.getDocumentCount() >>> 0) & 0xFFFFFFFF);
            buffer.putLong(entry.getDeletions());
            crc32.update((int)(entry.getDeletions() >>> 32) & 0xFFFFFFFF);
            crc32.update((int)(entry.getDeletions() >>> 0) & 0xFFFFFFFF);
            buffer.put(entry.isDeletOnlyNodes() ? (byte)1 : 0);
            if (entry.isDeletOnlyNodes()) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 1;
            } else {
                byte[] byArray3 = new byte[1];
                byArray = byArray3;
                byArray3[0] = 0;
            }
            crc32.update(byArray);
        }
        buffer.putLong(crc32.getValue());
        buffer.force();
    }

    private long getBufferSize() throws IOException {
        long size = 0L;
        size += 8L;
        size += 4L;
        for (IndexEntry entry : this.indexEntries.values()) {
            String entryType = entry.getType().toString();
            size += (long)(entryType.length() + 4);
            size += (long)(entry.getName().length() + 4);
            size += (long)(entry.getParentName().length() + 4);
            String entryStatus = entry.getStatus().toString();
            size += (long)(entryStatus.length() + 4);
            size += (long)(entry.getMergeId().length() + 4);
            size += 8L;
            size += 8L;
            ++size;
        }
        return size += 8L;
    }

    private <R> R doWithFileLock(LockWork<R> lockWork) {
        R r;
        FileLock fileLock = null;
        R result = null;
        try {
            if (this.indexIsShared) {
                fileLock = this.indexInfoChannel.lock();
                if (!this.checkVersion()) {
                    this.setStatusFromFile();
                }
            }
            r = result = (R)lockWork.doWork();
        }
        catch (Throwable exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during run with lock.", exception);
        }
        finally {
            if (fileLock != null) {
                try {
                    fileLock.release();
                }
                catch (IOException e) {}
            }
        }
        return r;
    }

    public static void main(String[] args) throws IOException {
        System.setProperty("disableLuceneLocks", "true");
        HashSet<NodeRef> deletions = new HashSet<NodeRef>();
        for (int i = 0; i < 0; ++i) {
            deletions.add(new NodeRef(new StoreRef("woof", "bingle"), GUID.generate()));
        }
        int repeat = 100;
        int docs = 1;
        IndexInfo ii = new IndexInfo(new File("c:\\indexTest"));
        long totalTimeA = 0L;
        long countA = 0L;
        while (true) {
            long start = System.nanoTime();
            for (int i = 0; i < repeat; ++i) {
                int j;
                String guid = GUID.generate();
                ii.setStatus(guid, TransactionStatus.ACTIVE, null, null);
                IndexWriter writer = ii.getDeltaIndexWriter(guid, (Analyzer)new StandardAnalyzer());
                for (j = 0; j < docs; ++j) {
                    Document doc = new Document();
                    for (int k = 0; k < 15; ++k) {
                        doc.add(new Field("ID" + k, guid + " " + j + " " + k, false, true, false));
                    }
                    writer.addDocument(doc);
                }
                ii.closeDeltaIndexWriter(guid);
                ii.setStatus(guid, TransactionStatus.PREPARING, null, null);
                ii.setPreparedState(guid, deletions, docs, false);
                ii.getDeletions(guid);
                ii.setStatus(guid, TransactionStatus.PREPARED, null, null);
                ii.setStatus(guid, TransactionStatus.COMMITTING, null, null);
                ii.setStatus(guid, TransactionStatus.COMMITTED, null, null);
                for (j = 0; j < 0; ++j) {
                    ii.getMainIndexReferenceCountingReadOnlyIndexReader();
                }
            }
            long end = System.nanoTime();
            float average = (float)(countA += (long)repeat) * 1.0E9f / (float)(totalTimeA += end - start);
            System.out.println("Repeated " + repeat + " in " + (double)(end - start) / 1.0E9 + "    average = " + average);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpInfo() {
        this.readWriteLock.writeLock().lock();
        try {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"");
                s_logger.debug((Object)"Entry List");
                for (IndexEntry entry : this.indexEntries.values()) {
                    s_logger.debug((Object)("        " + entry.toString()));
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void getWriteLock() {
        this.readWriteLock.writeLock().lock();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("GOT WRITE LOCK  - " + Thread.currentThread().getName()));
        }
    }

    private void releaseWriteLock() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("RELEASES WRITE LOCK  - " + Thread.currentThread().getName()));
        }
        this.readWriteLock.writeLock().unlock();
    }

    private void getReadLock() {
        this.readWriteLock.readLock().lock();
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("GOT READ LOCK  - " + Thread.currentThread().getName()));
        }
    }

    private void releaseReadLock() {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("RELEASES READ LOCK  - " + Thread.currentThread().getName()));
        }
        this.readWriteLock.readLock().unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Merger
    implements Runnable {
        private Merger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean running = true;
            while (running) {
                MergeAction action = MergeAction.NONE;
                IndexInfo.this.getReadLock();
                try {
                    if (IndexInfo.this.indexIsShared && !IndexInfo.this.checkVersion()) {
                        IndexInfo.this.releaseReadLock();
                        IndexInfo.this.getWriteLock();
                        try {
                            IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                                @Override
                                public Object doWork() throws Exception {
                                    return null;
                                }
                            });
                        }
                        finally {
                            IndexInfo.this.getReadLock();
                            IndexInfo.this.releaseWriteLock();
                        }
                    }
                    int indexes = 0;
                    boolean mergingIndexes = false;
                    int deltas = 0;
                    boolean applyingDeletions = false;
                    for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                        if (entry.getType() == IndexType.INDEX) {
                            ++indexes;
                            if (entry.getStatus() != TransactionStatus.MERGE) continue;
                            mergingIndexes = true;
                            continue;
                        }
                        if (entry.getType() != IndexType.DELTA) continue;
                        if (entry.getStatus() == TransactionStatus.COMMITTED) {
                            ++deltas;
                        }
                        if (entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                        applyingDeletions = true;
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Indexes = " + indexes));
                        s_logger.debug((Object)("Merging = " + mergingIndexes));
                        s_logger.debug((Object)("Deltas = " + deltas));
                        s_logger.debug((Object)("Deleting = " + applyingDeletions));
                    }
                    if (!(mergingIndexes || applyingDeletions || indexes <= 5 && deltas <= 5)) {
                        action = indexes > deltas ? MergeAction.MERGE_INDEX : MergeAction.APPLY_DELTA_DELETION;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    IndexInfo.this.releaseReadLock();
                }
                if (action == MergeAction.APPLY_DELTA_DELETION) {
                    this.mergeDeletions();
                } else if (action == MergeAction.MERGE_INDEX) {
                    this.mergeIndexes();
                }
                Merger merger = this;
                synchronized (merger) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        running = false;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void mergeDeletions() {
            LinkedHashMap toDelete;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Deleting ...");
            }
            IndexInfo.this.getWriteLock();
            try {
                toDelete = (LinkedHashMap)IndexInfo.this.doWithFileLock(new LockWork<LinkedHashMap<String, IndexEntry>>(){

                    @Override
                    public LinkedHashMap<String, IndexEntry> doWork() throws Exception {
                        LinkedHashMap<String, IndexEntry> set = new LinkedHashMap<String, IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE) {
                                return set;
                            }
                            if (entry.getType() != IndexType.DELTA || entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                            return set;
                        }
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() != IndexType.DELTA) continue;
                            if (entry.getStatus() == TransactionStatus.COMMITTED) {
                                entry.setStatus(TransactionStatus.COMMITTED_DELETING);
                                set.put(entry.getName(), entry);
                                continue;
                            }
                            if (entry.getStatus() != TransactionStatus.PREPARED) continue;
                            break;
                        }
                        if (set.size() > 0) {
                            IndexInfo.this.writeStatus();
                        }
                        return set;
                    }
                });
            }
            finally {
                IndexInfo.this.getReadLock();
                IndexInfo.this.releaseWriteLock();
            }
            LinkedHashMap<String, IndexEntry> indexes = new LinkedHashMap<String, IndexEntry>();
            try {
                for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                    if (entry.getStatus() == TransactionStatus.COMMITTED_DELETING) {
                        break;
                    }
                    indexes.put(entry.getName(), entry);
                }
            }
            finally {
                IndexInfo.this.releaseReadLock();
            }
            boolean fail = false;
            final HashSet<String> invalidIndexes = new HashSet<String>();
            final HashMap<String, Long> newIndexCounts = new HashMap<String, Long>();
            try {
                LinkedHashMap<String, IndexReader> readers = new LinkedHashMap<String, IndexReader>();
                for (IndexEntry entry : indexes.values()) {
                    File location = new File(IndexInfo.this.indexDirectory, entry.getName());
                    IndexReader reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                    readers.put(entry.getName(), reader);
                }
                for (IndexEntry currentDelete : toDelete.values()) {
                    Set<NodeRef> deletions = IndexInfo.this.getDeletions(currentDelete.getName());
                    for (String key : readers.keySet()) {
                        IndexReader reader = (IndexReader)readers.get(key);
                        for (NodeRef nodeRef : deletions) {
                            if (currentDelete.isDeletOnlyNodes()) {
                                IndexSearcher searcher = new IndexSearcher(reader);
                                BooleanQuery query = new BooleanQuery();
                                query.add((Query)new TermQuery(new Term("ID", nodeRef.toString())), true, false);
                                query.add((Query)new TermQuery(new Term("ISNODE", "T")), false, false);
                                Hits hits = searcher.search((Query)query);
                                if (hits.length() > 0) {
                                    for (int i = 0; i < hits.length(); ++i) {
                                        reader.delete(hits.id(i));
                                        invalidIndexes.add(key);
                                    }
                                }
                                searcher.close();
                                continue;
                            }
                            if (reader.delete(new Term("ID", nodeRef.toString())) <= 0) continue;
                            invalidIndexes.add(key);
                        }
                    }
                    File location = new File(IndexInfo.this.indexDirectory, currentDelete.getName());
                    IndexReader reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                    readers.put(currentDelete.getName(), reader);
                }
                for (String key : readers.keySet()) {
                    IndexReader reader = (IndexReader)readers.get(key);
                    newIndexCounts.put(key, new Long(reader.numDocs()));
                    reader.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                fail = true;
            }
            final boolean wasDeleted = !fail;
            IndexInfo.this.getWriteLock();
            try {
                IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                    @Override
                    public Object doWork() throws Exception {
                        for (IndexEntry entry : toDelete.values()) {
                            entry.setStatus(TransactionStatus.COMMITTED);
                            if (!wasDeleted) continue;
                            entry.setType(IndexType.INDEX);
                            entry.setDeletions(0L);
                        }
                        for (String key : newIndexCounts.keySet()) {
                            Long newCount = (Long)newIndexCounts.get(key);
                            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(key);
                            entry.setDocumentCount(newCount);
                        }
                        IndexInfo.this.writeStatus();
                        for (String id : invalidIndexes) {
                            IndexReader reader = (IndexReader)IndexInfo.this.referenceCountingReadOnlyIndexReaders.remove(id);
                            if (reader == null) continue;
                            ReferenceCounting referenceCounting = (ReferenceCounting)reader;
                            referenceCounting.setInvalidForReuse();
                            if (!s_logger.isDebugEnabled()) continue;
                            s_logger.debug((Object)("... invalidating sub reader after merge" + id));
                        }
                        if (invalidIndexes.size() > 0) {
                            if (IndexInfo.this.mainIndexReader != null) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)"... invalidating main index reader after merge");
                                }
                                ((ReferenceCounting)IndexInfo.this.mainIndexReader).setInvalidForReuse();
                            }
                            IndexInfo.this.mainIndexReader = null;
                        }
                        if (s_logger.isDebugEnabled()) {
                            for (String id : toDelete.keySet()) {
                                s_logger.debug((Object)("...applied deletion for " + id));
                            }
                            for (String id : invalidIndexes) {
                                s_logger.debug((Object)("...invalidated index " + id));
                            }
                            s_logger.debug((Object)"...deleting done");
                        }
                        IndexInfo.this.dumpInfo();
                        return null;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void mergeIndexes() {
            LinkedHashMap toMerge;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"Merging...");
            }
            IndexInfo.this.getWriteLock();
            try {
                toMerge = (LinkedHashMap)IndexInfo.this.doWithFileLock(new LockWork<LinkedHashMap<String, IndexEntry>>(){

                    @Override
                    public LinkedHashMap<String, IndexEntry> doWork() throws Exception {
                        LinkedHashMap<String, IndexEntry> set = new LinkedHashMap<String, IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() == IndexType.INDEX && entry.getStatus() == TransactionStatus.MERGE) {
                                return set;
                            }
                            if (entry.getType() != IndexType.DELTA || entry.getStatus() != TransactionStatus.COMMITTED_DELETING) continue;
                            return set;
                        }
                        ArrayList<IndexEntry> mergeList = new ArrayList<IndexEntry>();
                        for (IndexEntry entry : IndexInfo.this.indexEntries.values()) {
                            if (entry.getType() != IndexType.INDEX || entry.getStatus() != TransactionStatus.COMMITTED) continue;
                            mergeList.add(entry);
                        }
                        int position = Merger.this.findMergeIndex(1L, 1000000L, 5, mergeList);
                        String firstMergeId = ((IndexEntry)mergeList.get(position)).getName();
                        long count = 0L;
                        String guid = null;
                        if (position >= 0) {
                            guid = GUID.generate();
                            for (int i = position; i < mergeList.size(); ++i) {
                                IndexEntry entry = (IndexEntry)mergeList.get(i);
                                count += entry.getDocumentCount();
                                set.put(entry.getName(), entry);
                                entry.setStatus(TransactionStatus.MERGE);
                                entry.setMergeId(guid);
                            }
                        }
                        if (set.size() > 0) {
                            IndexEntry target = new IndexEntry(IndexType.INDEX, guid, "", TransactionStatus.MERGE_TARGET, guid, count, 0L, false);
                            set.put(guid, target);
                            LinkedHashMap<String, IndexEntry> reordered = new LinkedHashMap<String, IndexEntry>();
                            for (IndexEntry current : IndexInfo.this.indexEntries.values()) {
                                if (current.getName().equals(firstMergeId)) {
                                    reordered.put(target.getName(), target);
                                }
                                reordered.put(current.getName(), current);
                            }
                            IndexInfo.this.indexEntries = reordered;
                            IndexInfo.this.writeStatus();
                        }
                        return set;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("....Merging..." + (toMerge.size() - 1)));
            }
            boolean fail = false;
            try {
                if (toMerge.size() > 0) {
                    int count = 0;
                    IndexReader[] readers = new IndexReader[toMerge.size() - 1];
                    IndexWriter writer = null;
                    for (IndexEntry entry : toMerge.values()) {
                        File location = new File(IndexInfo.this.indexDirectory, entry.getName());
                        if (entry.getStatus() == TransactionStatus.MERGE) {
                            IndexReader reader = IndexReader.indexExists((File)location) ? IndexReader.open((File)location) : IndexReader.open((Directory)IndexInfo.this.emptyIndex);
                            readers[count++] = reader;
                            continue;
                        }
                        if (entry.getStatus() != TransactionStatus.MERGE_TARGET) continue;
                        writer = new IndexWriter(location, (Analyzer)new StandardAnalyzer(), true);
                        writer.setUseCompoundFile(true);
                        writer.minMergeDocs = 1000;
                        writer.mergeFactor = 5;
                        writer.maxMergeDocs = 1000000;
                    }
                    writer.addIndexes(readers);
                    writer.close();
                    for (IndexReader reader : readers) {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                fail = true;
            }
            final boolean wasMerged = !fail;
            IndexInfo.this.getWriteLock();
            try {
                IndexInfo.this.doWithFileLock(new LockWork<Object>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public Object doWork() throws Exception {
                        HashSet<String> toDelete = new HashSet<String>();
                        for (IndexEntry entry : toMerge.values()) {
                            if (entry.getStatus() == TransactionStatus.MERGE) {
                                if (wasMerged) {
                                    if (s_logger.isDebugEnabled()) {
                                        s_logger.debug((Object)("... deleting as merged " + entry.getName()));
                                    }
                                    toDelete.add(entry.getName());
                                    continue;
                                }
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)("... committing as merge failed " + entry.getName()));
                                }
                                entry.setStatus(TransactionStatus.COMMITTED);
                                continue;
                            }
                            if (entry.getStatus() != TransactionStatus.MERGE_TARGET) continue;
                            if (wasMerged) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)("... committing merge target " + entry.getName()));
                                }
                                entry.setStatus(TransactionStatus.COMMITTED);
                                continue;
                            }
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("... deleting merge target as merge failed " + entry.getName()));
                            }
                            toDelete.add(entry.getName());
                        }
                        for (String id : toDelete) {
                            IndexInfo.this.indexEntries.remove(id);
                            IndexInfo.this.deleteQueue.add(id);
                        }
                        Cleaner cleaner = IndexInfo.this.cleaner;
                        synchronized (cleaner) {
                            IndexInfo.this.cleaner.notify();
                        }
                        IndexInfo.this.dumpInfo();
                        IndexInfo.this.writeStatus();
                        IndexInfo.this.clearOldReaders();
                        return null;
                    }
                });
            }
            finally {
                IndexInfo.this.releaseWriteLock();
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)"..done merging");
            }
        }

        private final int findMergeIndex(long min, long max, int factor, List<IndexEntry> entries) throws IOException {
            int i;
            if (entries.size() <= factor) {
                return -1;
            }
            int total = 0;
            for (i = factor; i < entries.size(); ++i) {
                total = (int)((long)total + entries.get(i).getDocumentCount());
            }
            for (i = factor - 1; i > 0; --i) {
                if ((long)(total = (int)((long)total + entries.get(i).getDocumentCount())) >= entries.get(i - 1).getDocumentCount()) continue;
                return i;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MergeAction {
        NONE,
        MERGE_INDEX,
        APPLY_DELTA_DELETION,
        MERGE_DELTA;

    }

    private class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean runnable = true;
            while (runnable) {
                String id = null;
                while ((id = (String)IndexInfo.this.deleteQueue.poll()) != null) {
                    File location;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Expunging " + id + " remaining " + IndexInfo.this.deleteQueue.size()));
                    }
                    if (this.deleteDirectory(location = new File(IndexInfo.this.indexDirectory, id))) continue;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)"DELETE FAILED");
                    }
                    IndexInfo.this.deleteQueue.add(id);
                }
                Cleaner cleaner = this;
                synchronized (cleaner) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        runnable = false;
                    }
                }
            }
        }

        private boolean deleteDirectory(File file) {
            File[] children = file.listFiles();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    File child = children[i];
                    if (child.isDirectory()) {
                        this.deleteDirectory(child);
                        continue;
                    }
                    if (!child.exists() || child.delete() || !child.exists()) continue;
                    return false;
                }
            }
            return !file.exists() || file.delete() || !file.exists();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface LockWork<Result> {
        public Result doWork() throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActiveTransition
    implements Transition {
        private ActiveTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry != null && entry.getStatus() != TransactionStatus.ACTIVE) {
                throw new IndexerException("TX Already active " + id);
            }
            if (!TransactionStatus.ACTIVE.follows(null)) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ACTIVE));
            }
            IndexInfo.this.indexEntries.put(id, new IndexEntry(IndexType.DELTA, id, "", TransactionStatus.ACTIVE, "", 0L, 0L, false));
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ACTIVE.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DeletableTransition
    implements Transition {
        private DeletableTransition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (TransactionStatus.DELETABLE.follows(entry.getStatus())) {
                IndexInfo.this.indexEntries.remove(id);
                IndexInfo.this.deleteQueue.add(id);
                Cleaner cleaner = IndexInfo.this.cleaner;
                synchronized (cleaner) {
                    IndexInfo.this.cleaner.notify();
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.DELETABLE));
            }
            IndexInfo.this.writeStatus();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.DELETABLE.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RolledBackTransition
    implements Transition {
        private RolledBackTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.ROLLEDBACK.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ROLLEDBACK));
            }
            entry.setStatus(TransactionStatus.ROLLEDBACK);
            IndexInfo.this.writeStatus();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ROLLEDBACK.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RollingBackTransition
    implements Transition {
        private RollingBackTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.ROLLINGBACK.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.ROLLINGBACK));
            }
            entry.setStatus(TransactionStatus.ROLLINGBACK);
            IndexInfo.this.writeStatus();
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.ROLLINGBACK.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommittedTransition
    implements Transition {
        private CommittedTransition() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (TransactionStatus.COMMITTED.follows(entry.getStatus())) {
                if (entry.getDocumentCount() + entry.getDeletions() == 0L) {
                    IndexInfo.this.indexEntries.remove(id);
                } else {
                    entry.setStatus(TransactionStatus.COMMITTED);
                    IndexInfo.this.writeStatus();
                    if (IndexInfo.this.mainIndexReader != null) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"... invalidating main index reader");
                        }
                        ((ReferenceCounting)IndexInfo.this.mainIndexReader).setInvalidForReuse();
                        IndexInfo.this.mainIndexReader = null;
                    }
                    Merger merger = IndexInfo.this.merger;
                    synchronized (merger) {
                        IndexInfo.this.merger.notify();
                    }
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.COMMITTED));
            }
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.COMMITTED.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CommittingTransition
    implements Transition {
        private CommittingTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.COMMITTING.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.COMMITTING));
            }
            entry.setStatus(TransactionStatus.COMMITTING);
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.COMMITTING.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreparedTransition
    implements Transition {
        private PreparedTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (TransactionStatus.PREPARED.follows(entry.getStatus())) {
                if (entry.getDeletions() + entry.getDocumentCount() > 0L) {
                    LinkedHashMap<String, IndexEntry> reordered = new LinkedHashMap<String, IndexEntry>();
                    boolean addedPreparedEntry = false;
                    for (IndexEntry current : IndexInfo.this.indexEntries.values()) {
                        if (!current.getStatus().canBeReordered()) {
                            reordered.put(current.getName(), current);
                            continue;
                        }
                        if (!addedPreparedEntry) {
                            reordered.put(entry.getName(), entry);
                            reordered.put(current.getName(), current);
                            addedPreparedEntry = true;
                            continue;
                        }
                        if (current.getName().equals(entry.getName())) continue;
                        reordered.put(current.getName(), current);
                    }
                    if (IndexInfo.this.indexEntries.size() != reordered.size()) {
                        IndexInfo.this.indexEntries = reordered;
                        IndexInfo.this.dumpInfo();
                        throw new IndexerException("Concurrent modification error");
                    }
                    IndexInfo.this.indexEntries = reordered;
                }
                entry.setStatus(TransactionStatus.PREPARED);
                if (entry.getDeletions() + entry.getDocumentCount() > 0L) {
                    IndexInfo.this.writeStatus();
                }
            } else {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.PREPARED));
            }
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.PREPARED.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PreparingTransition
    implements Transition {
        private PreparingTransition() {
        }

        @Override
        public void transition(String id, Set<Term> toDelete, Set<Term> read) throws IOException {
            IndexEntry entry = (IndexEntry)IndexInfo.this.indexEntries.get(id);
            if (entry == null) {
                throw new IndexerException("Unknown transaction " + id);
            }
            if (!TransactionStatus.PREPARING.follows(entry.getStatus())) {
                throw new IndexerException("Invalid transition for " + id + " from " + (Object)((Object)entry.getStatus()) + " to " + (Object)((Object)TransactionStatus.PREPARING));
            }
            entry.setStatus(TransactionStatus.PREPARING);
        }

        @Override
        public boolean requiresFileLock() {
            return !TransactionStatus.PREPARING.isTransient();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Transition {
        public void transition(String var1, Set<Term> var2, Set<Term> var3) throws IOException;

        public boolean requiresFileLock();
    }
}

