/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

import java.io.IOException;
import org.alfresco.repo.search.impl.lucene.index.ReferenceCounting;
import org.apache.log4j.Logger;
import org.apache.lucene.index.FilterIndexReader;
import org.apache.lucene.index.IndexReader;

public class ReferenceCountingReadOnlyIndexReaderFactory {
    public static IndexReader createReader(String id, IndexReader indexReader) {
        return new ReferenceCountingReadOnlyIndexReader(id, indexReader);
    }

    public static class ReferenceCountingReadOnlyIndexReader
    extends FilterIndexReader
    implements ReferenceCounting {
        private static Logger s_logger = Logger.getLogger(ReferenceCountingReadOnlyIndexReader.class);
        private static final long serialVersionUID = 7693185658022810428L;
        String id;
        int refCount = 0;
        boolean invalidForReuse = false;

        ReferenceCountingReadOnlyIndexReader(String id, IndexReader indexReader) {
            super(indexReader);
            this.id = id;
        }

        public synchronized void incrementReferenceCount() {
            ++this.refCount;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " - increment - ref count is " + this.refCount));
            }
        }

        public synchronized void decrementReferenceCount() throws IOException {
            --this.refCount;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " - decrement - ref count is " + this.refCount));
            }
            this.closeIfRequired();
        }

        private void closeIfRequired() throws IOException {
            if (this.refCount == 0 && this.invalidForReuse) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " closed."));
                }
                this.in.close();
            } else if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " still open .... ref = " + this.refCount + " invalidForReuse = " + this.invalidForReuse));
            }
        }

        public synchronized int getReferenceCount() {
            return this.refCount;
        }

        public synchronized void setInvalidForReuse() throws IOException {
            this.invalidForReuse = true;
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " set invalid for reuse"));
            }
            this.closeIfRequired();
        }

        protected void doClose() throws IOException {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)(Thread.currentThread().getName() + ": Reader " + this.id + " closing"));
            }
            this.decrementReferenceCount();
        }

        protected void doDelete(int n) throws IOException {
            throw new UnsupportedOperationException("Delete is not supported by read only index readers");
        }
    }
}

