/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.index;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum TransactionStatus {
    ACTIVE{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == null;
        }
    }
    ,
    MARKED_ROLLBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous);
        }
    }
    ,
    PREPARED{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == PREPARING;
        }
    }
    ,
    COMMITTED{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == COMMITTING;
        }
    }
    ,
    ROLLEDBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == ROLLINGBACK;
        }
    }
    ,
    UNKNOWN{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return false;
        }
    }
    ,
    NO_TRANSACTION{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return false;
        }
    }
    ,
    PREPARING{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == ACTIVE;
        }
    }
    ,
    COMMITTING{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return previous == PREPARED;
        }
    }
    ,
    ROLLINGBACK{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return true;
        }

        public boolean canBeReordered() {
            return true;
        }

        public boolean follows(TransactionStatus previous) {
            return previous.allowsRollbackOrMark(previous);
        }
    }
    ,
    MERGE{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return false;
        }
    }
    ,
    MERGE_TARGET{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return false;
        }
    }
    ,
    COMMITTED_DELETING{

        public boolean isCommitted() {
            return true;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return false;
        }
    }
    ,
    DELETABLE{

        public boolean isCommitted() {
            return false;
        }

        public boolean isTransient() {
            return false;
        }

        public boolean canBeReordered() {
            return false;
        }

        public boolean follows(TransactionStatus previous) {
            return true;
        }
    };


    public abstract boolean isCommitted();

    public abstract boolean isTransient();

    public abstract boolean canBeReordered();

    public abstract boolean follows(TransactionStatus var1);

    private boolean allowsRollbackOrMark(TransactionStatus previous) {
        switch (previous) {
            case ACTIVE: 
            case MARKED_ROLLBACK: 
            case PREPARED: 
            case PREPARING: 
            case COMMITTING: {
                return true;
            }
        }
        return false;
    }
}

