/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import org.alfresco.repo.search.impl.lucene.query.CachingTermPositions;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;

public abstract class AbstractStructuredFieldPosition
implements StructuredFieldPosition {
    private String termText;
    private boolean isTerminal;
    private boolean isAbsolute;
    private CachingTermPositions tps;

    public AbstractStructuredFieldPosition(String termText, boolean isTerminal, boolean isAbsolute) {
        this.termText = termText;
        this.isTerminal = isTerminal;
        this.isAbsolute = isAbsolute;
    }

    public boolean isTerminal() {
        return this.isTerminal;
    }

    protected void setTerminal(boolean isTerminal) {
        this.isTerminal = isTerminal;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public boolean isRelative() {
        return !this.isAbsolute;
    }

    public String getTermText() {
        return this.termText;
    }

    public int getPosition() {
        return -1;
    }

    public void setCachingTermPositions(CachingTermPositions tps) {
        this.tps = tps;
    }

    public CachingTermPositions getCachingTermPositions() {
        return this.tps;
    }

    public boolean allowsLinkingBySelf() {
        return false;
    }

    public boolean allowslinkingByParent() {
        return true;
    }

    public boolean linkParent() {
        return true;
    }

    public boolean linkSelf() {
        return false;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getDescription());
        buffer.append("<" + this.getTermText() + "> at " + this.getPosition());
        buffer.append(" Terminal = " + this.isTerminal());
        buffer.append(" Absolute = " + this.isAbsolute());
        return buffer.toString();
    }

    public abstract String getDescription();

    public boolean isDescendant() {
        return false;
    }

    public boolean matchesAll() {
        return this.getCachingTermPositions() == null;
    }
}

