/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.index.TermPositions;

public class CachingTermPositions
implements TermPositions {
    int[] results;
    int position = -1;
    int last = -1;
    TermPositions delegate;

    CachingTermPositions(TermPositions delegate) {
        this.delegate = delegate;
    }

    public int nextPosition() throws IOException {
        if (this.results == null) {
            this.results = new int[this.freq()];
        }
        ++this.position;
        if (this.last < this.position) {
            this.results[this.position] = this.delegate.nextPosition();
            this.last = this.position;
        }
        return this.results[this.position];
    }

    public void reset() {
        this.position = -1;
    }

    private void clear() {
        this.position = -1;
        this.last = -1;
        this.results = null;
    }

    public void seek(Term term) throws IOException {
        this.delegate.seek(term);
        this.clear();
    }

    public void seek(TermEnum termEnum) throws IOException {
        this.delegate.seek(termEnum);
        this.clear();
    }

    public int doc() {
        return this.delegate.doc();
    }

    public int freq() {
        return this.delegate.freq();
    }

    public boolean next() throws IOException {
        if (this.delegate.next()) {
            this.clear();
            return true;
        }
        return false;
    }

    public int read(int[] docs, int[] freqs) throws IOException {
        int answer = this.delegate.read(docs, freqs);
        this.clear();
        return answer;
    }

    public boolean skipTo(int target) throws IOException {
        if (this.delegate.skipTo(target)) {
            this.clear();
            return true;
        }
        return false;
    }

    public void close() throws IOException {
        this.delegate.close();
        this.clear();
    }
}

