/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.query.ContainerScorer;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LeafScorer
extends Scorer {
    private int counter;
    private int countInCounter;
    int min = 0;
    int max = 0;
    boolean more = true;
    Scorer containerScorer;
    StructuredFieldPosition[] sfps;
    float freq = 0.0f;
    HashMap<String, Counter> parentIds = new HashMap();
    HashMap<String, List<String>> categories = new HashMap();
    HashMap<String, Counter> selfIds = null;
    boolean hasSelfScorer;
    IndexReader reader;
    private TermPositions allNodes;
    TermPositions level0;
    HashSet<String> selfLinks = new HashSet();
    BitSet selfDocs = new BitSet();
    private TermPositions root;
    private int rootDoc;
    private boolean repeat;
    private DictionaryService dictionaryService;
    private int[] parents;
    private int[] self;
    private int[] cats;
    private TermPositions tp;

    public LeafScorer(Weight weight, TermPositions root, TermPositions level0, ContainerScorer containerScorer, StructuredFieldPosition[] sfps, TermPositions allNodes, HashMap<String, Counter> selfIds, IndexReader reader, Similarity similarity, byte[] norms, DictionaryService dictionaryService, boolean repeat, TermPositions tp) {
        super(similarity);
        this.root = root;
        this.containerScorer = containerScorer;
        this.sfps = sfps;
        this.allNodes = allNodes;
        this.tp = tp;
        if (selfIds == null) {
            this.selfIds = new HashMap();
            this.hasSelfScorer = false;
        } else {
            this.selfIds = selfIds;
            this.hasSelfScorer = true;
        }
        this.reader = reader;
        this.level0 = level0;
        this.dictionaryService = dictionaryService;
        this.repeat = repeat;
        try {
            this.initialise();
        }
        catch (IOException e) {
            throw new SearcherException(e);
        }
    }

    private void initialise() throws IOException {
        Counter counter;
        Field id;
        Document document;
        int doc;
        if (this.containerScorer != null) {
            this.parentIds.clear();
            while (this.containerScorer.next()) {
                List<String> list;
                Field isCategory;
                doc = this.containerScorer.doc();
                document = this.reader.document(doc);
                id = document.getField("ID");
                counter = this.parentIds.get(id.stringValue());
                if (counter == null) {
                    counter = new Counter();
                    this.parentIds.put(id.stringValue(), counter);
                }
                ++counter.count;
                if (!this.hasSelfScorer) {
                    counter = this.selfIds.get(id.stringValue());
                    if (counter == null) {
                        counter = new Counter();
                        this.selfIds.put(id.stringValue(), counter);
                    }
                    ++counter.count;
                }
                if ((isCategory = document.getField("ISCATEGORY")) == null) continue;
                Field path = document.getField("PATH");
                String pathString = path.stringValue();
                if (pathString.length() > 0 && pathString.charAt(0) == '/') {
                    pathString = pathString.substring(1);
                }
                if ((list = this.categories.get(id.stringValue())) == null) {
                    list = new ArrayList<String>();
                    this.categories.put(id.stringValue(), list);
                }
                list.add(pathString);
            }
        } else if (this.level0 != null) {
            this.parentIds.clear();
            while (this.level0.next()) {
                doc = this.level0.doc();
                document = this.reader.document(doc);
                id = document.getField("ID");
                if (id == null) continue;
                counter = this.parentIds.get(id.stringValue());
                if (counter == null) {
                    counter = new Counter();
                    this.parentIds.put(id.stringValue(), counter);
                }
                ++counter.count;
                counter = this.selfIds.get(id.stringValue());
                if (counter == null) {
                    counter = new Counter();
                    this.selfIds.put(id.stringValue(), counter);
                }
                ++counter.count;
            }
            if (this.parentIds.size() > 1) {
                throw new SearcherException("More than one root node in index: " + this.parentIds.size());
            }
            if (this.parentIds.size() == 0) {
                throw new SearcherException("Index has no root node.  Check that the correct index locations are being used.");
            }
        }
        if (this.allNodes()) {
            int position = 0;
            this.parents = new int[10000];
            for (String parent : this.parentIds.keySet()) {
                counter = this.parentIds.get(parent);
                this.tp.seek(new Term("PARENT", parent));
                while (this.tp.next()) {
                    int l = this.tp.freq();
                    for (int i = 0; i < l; ++i) {
                        for (int j = 0; j < counter.count; ++j) {
                            this.parents[position++] = this.tp.doc();
                            if (position != this.parents.length) continue;
                            int[] old = this.parents;
                            this.parents = new int[old.length * 2];
                            System.arraycopy(old, 0, this.parents, 0, old.length);
                        }
                    }
                }
            }
            int[] old = this.parents;
            this.parents = new int[position];
            System.arraycopy(old, 0, this.parents, 0, position);
            Arrays.sort(this.parents);
            position = 0;
            this.self = new int[10000];
            for (String id2 : this.selfIds.keySet()) {
                this.tp.seek(new Term("ID", id2));
                while (this.tp.next()) {
                    Counter counter2 = this.selfIds.get(id2);
                    for (int i = 0; i < counter2.count; ++i) {
                        this.self[position++] = this.tp.doc();
                        if (position != this.self.length) continue;
                        old = this.self;
                        this.self = new int[old.length * 2];
                        System.arraycopy(old, 0, this.self, 0, old.length);
                    }
                }
            }
            old = this.self;
            this.self = new int[position];
            System.arraycopy(old, 0, this.self, 0, position);
            Arrays.sort(this.self);
            position = 0;
            this.cats = new int[10000];
            for (String catid : this.categories.keySet()) {
                for (QName apsectQName : this.dictionaryService.getAllAspects()) {
                    AspectDefinition aspDef = this.dictionaryService.getAspect(apsectQName);
                    if (!this.isCategorised(aspDef)) continue;
                    for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                        if (!propDef.getDataType().getName().equals(DataTypeDefinition.CATEGORY)) continue;
                        this.tp.seek(new Term("@" + propDef.getName().toString(), catid));
                        while (this.tp.next()) {
                            int l = this.tp.freq();
                            for (int i = 0; i < l; ++i) {
                                this.cats[position++] = this.tp.doc();
                                if (position != this.cats.length) continue;
                                old = this.cats;
                                this.cats = new int[old.length * 2];
                                System.arraycopy(old, 0, this.cats, 0, old.length);
                            }
                        }
                    }
                }
            }
            old = this.cats;
            this.cats = new int[position];
            System.arraycopy(old, 0, this.cats, 0, position);
            Arrays.sort(this.cats);
        }
    }

    public boolean next() throws IOException {
        if (this.repeat && this.countInCounter < this.counter) {
            ++this.countInCounter;
            return true;
        }
        this.countInCounter = 1;
        this.counter = 0;
        if (this.allNodes()) {
            while (this.more) {
                if (this.allNodes.next() && this.root.next()) {
                    if (!this.check()) continue;
                    return true;
                }
                this.more = false;
                return false;
            }
        }
        if (!this.more) {
            return false;
        }
        if (this.max == 0) {
            this.doNextOnAll();
            if (this.found()) {
                return true;
            }
        }
        return this.findNext();
    }

    private boolean allNodes() {
        if (this.sfps.length == 0) {
            return true;
        }
        for (StructuredFieldPosition sfp : this.sfps) {
            if (sfp.getCachingTermPositions() == null) continue;
            return false;
        }
        return true;
    }

    private boolean findNext() throws IOException {
        while (this.more) {
            this.move();
            if (!this.found()) continue;
            return true;
        }
        return false;
    }

    private void skipToMax() throws IOException {
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if (i == 0) {
                this.min = this.max;
            }
            if (this.sfps[i].getCachingTermPositions() == null || this.sfps[i].getCachingTermPositions().doc() >= this.max) continue;
            if (this.sfps[i].getCachingTermPositions().skipTo(this.max)) {
                int current = this.sfps[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, false);
                continue;
            }
            this.more = false;
            return;
        }
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void move() throws IOException {
        if (this.min == this.max) {
            this.doNextOnAll();
        } else {
            this.skipToMax();
        }
    }

    private void doNextOnAll() throws IOException {
        boolean first = true;
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if (this.sfps[i].getCachingTermPositions() == null) continue;
            if (this.sfps[i].getCachingTermPositions().next()) {
                int current = this.sfps[i].getCachingTermPositions().doc();
                this.adjustMinMax(current, first);
                first = false;
                continue;
            }
            this.more = false;
            return;
        }
        if (!this.root.next()) {
            this.more = false;
            return;
        }
        this.rootDoc = this.root.doc();
        if (this.root.doc() < this.max) {
            if (this.root.skipTo(this.max)) {
                this.rootDoc = this.root.doc();
            } else {
                this.more = false;
                return;
            }
        }
    }

    private void adjustMinMax(int doc, boolean setMin) {
        if (this.max < doc) {
            this.max = doc;
        }
        if (setMin) {
            this.min = doc;
        } else if (this.min > doc) {
            this.min = doc;
        }
    }

    private boolean found() throws IOException {
        if (this.sfps.length == 0) {
            return true;
        }
        if (!this.more) {
            return false;
        }
        if (this.min != this.max) {
            return false;
        }
        if (this.rootDoc != this.max) {
            return false;
        }
        return this.check();
    }

    private boolean check() throws IOException {
        if (this.allNodes()) {
            int i;
            int l;
            int position;
            this.counter = 0;
            StructuredFieldPosition last = this.sfps[this.sfps.length - 1];
            if (last.linkSelf() && this.self != null && this.sfps[1].linkSelf() && (position = Arrays.binarySearch(this.self, this.doc())) >= 0 && !this.selfDocs.get(this.doc())) {
                this.selfDocs.set(this.doc());
                while (position > -1 && this.self[position] == this.doc()) {
                    --position;
                }
                l = this.self.length;
                for (i = position + 1; i < l && this.self[i] == this.doc(); ++i) {
                    ++this.counter;
                }
            }
            if (!this.selfDocs.get(this.doc()) && last.linkParent()) {
                if (this.parents != null && (position = Arrays.binarySearch(this.parents, this.doc())) >= 0) {
                    while (position > -1 && this.parents[position] == this.doc()) {
                        --position;
                    }
                    l = this.parents.length;
                    for (i = position + 1; i < l && this.parents[i] == this.doc(); ++i) {
                        ++this.counter;
                    }
                }
                if (this.cats != null && (position = Arrays.binarySearch(this.cats, this.doc())) >= 0) {
                    while (position > -1 && this.cats[position] == this.doc()) {
                        --position;
                    }
                    l = this.cats.length;
                    for (i = position + 1; i < l && this.cats[i] == this.doc(); ++i) {
                        ++this.counter;
                    }
                }
            }
            return this.counter > 0;
        }
        int count = this.root.freq();
        int start = 0;
        int end = -1;
        for (int i = 0; i < count; ++i) {
            if (i == 0) {
                start = 0;
                end = this.root.nextPosition();
            } else {
                start = end + 1;
                end = this.root.nextPosition();
            }
            this.check(start, end, i);
        }
        return this.counter > 0;
    }

    private void check(int start, int end, int position) throws IOException {
        int offset = 0;
        int l = this.sfps.length;
        for (int i = 0; i < l; ++i) {
            if ((offset = this.sfps[i].matches(start, end, offset)) != -1) continue;
            return;
        }
        if (offset == -1) {
            return;
        }
        if (this.sfps[this.sfps.length - 1].isTerminal() && offset != 2) {
            return;
        }
        Document doc = this.reader.document(this.doc());
        Field[] parentFields = doc.getFields("PARENT");
        Field[] linkFields = doc.getFields("LINKASPECT");
        String parentID = null;
        String linkAspect = null;
        if (parentFields != null && parentFields.length > position && parentFields[position] != null) {
            parentID = parentFields[position].stringValue();
        }
        if (linkFields != null && linkFields.length > position && linkFields[position] != null) {
            linkAspect = linkFields[position].stringValue();
        }
        this.containersIncludeCurrent(doc, parentID, linkAspect);
    }

    private void containersIncludeCurrent(Document document, String parentID, String aspectQName) throws IOException {
        if (this.containerScorer != null || this.level0 != null) {
            Counter counter;
            if (this.sfps.length == 0) {
                return;
            }
            String id = document.getField("ID").stringValue();
            StructuredFieldPosition last = this.sfps[this.sfps.length - 1];
            if (last.linkSelf() && this.selfIds.containsKey(id) && (counter = this.selfIds.get(id)) != null && !this.selfLinks.contains(id)) {
                this.counter += counter.count;
                this.selfLinks.add(id);
                return;
            }
            if (parentID != null && parentID.length() > 0 && last.linkParent() && !this.selfLinks.contains(id)) {
                if (this.categories.containsKey(parentID)) {
                    QName classRef;
                    AspectDefinition aspDef;
                    Counter counter2;
                    QName typeRef;
                    Field typeField = document.getField("TYPE");
                    if (typeField != null && typeField.stringValue() != null && this.isCategory(typeRef = QName.createQName(typeField.stringValue())) && (counter2 = this.parentIds.get(parentID)) != null) {
                        this.counter += counter2.count;
                        return;
                    }
                    if (aspectQName != null && this.isCategorised(aspDef = this.dictionaryService.getAspect(classRef = QName.createQName(aspectQName)))) {
                        for (PropertyDefinition propDef : aspDef.getProperties().values()) {
                            Field[] categoryFields;
                            if (!propDef.getDataType().getName().equals(DataTypeDefinition.CATEGORY) || (categoryFields = document.getFields("@" + propDef.getName())) == null) continue;
                            for (Field categoryField : categoryFields) {
                                if (categoryField == null || categoryField.stringValue() == null || !categoryField.stringValue().endsWith(parentID)) continue;
                                int count = 0;
                                List<String> paths = this.categories.get(parentID);
                                if (paths != null) {
                                    for (String path : paths) {
                                        if (path.indexOf(aspectQName) == -1) continue;
                                        ++count;
                                    }
                                }
                                this.counter += count;
                                return;
                            }
                        }
                    }
                } else {
                    counter = this.parentIds.get(parentID);
                    if (counter != null) {
                        this.counter += counter.count;
                        return;
                    }
                }
            }
            return;
        }
    }

    private boolean isCategory(QName classRef) {
        if (classRef == null) {
            return false;
        }
        TypeDefinition current = this.dictionaryService.getType(classRef);
        while (current != null) {
            if (current.getName().equals(ContentModel.TYPE_CATEGORY)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getType(parentName);
        }
        return false;
    }

    private boolean isCategorised(AspectDefinition aspDef) {
        AspectDefinition current = aspDef;
        while (current != null) {
            if (current.getName().equals(ContentModel.ASPECT_CLASSIFIABLE)) {
                return true;
            }
            QName parentName = current.getParentName();
            if (parentName == null) break;
            current = this.dictionaryService.getAspect(parentName);
        }
        return false;
    }

    public int doc() {
        if (this.allNodes()) {
            return this.allNodes.doc();
        }
        return this.max;
    }

    public float score() throws IOException {
        return this.repeat ? 1.0f : (float)this.counter;
    }

    public boolean skipTo(int target) throws IOException {
        this.countInCounter = 1;
        this.counter = 0;
        if (this.allNodes()) {
            this.allNodes.skipTo(target);
            this.root.skipTo(this.allNodes.doc());
            if (this.check()) {
                return true;
            }
            while (this.more) {
                if (this.allNodes.next() && this.root.next()) {
                    if (!this.check()) continue;
                    return true;
                }
                this.more = false;
                return false;
            }
        }
        this.max = target;
        return this.findNext();
    }

    public Explanation explain(int doc) throws IOException {
        Explanation tfExplanation = new Explanation();
        while (this.next() && this.doc() < doc) {
        }
        float phraseFreq = this.doc() == doc ? this.freq : 0.0f;
        tfExplanation.setValue(this.getSimilarity().tf(phraseFreq));
        tfExplanation.setDescription("tf(phraseFreq=" + phraseFreq + ")");
        return tfExplanation;
    }

    static class Counter {
        int count = 0;

        Counter() {
        }

        public String toString() {
            return "count = " + this.count;
        }
    }
}

