/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.search.impl.lucene.query.PathScorer;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Weight;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathQuery
extends Query {
    private static final long serialVersionUID = 3832904355660707892L;
    private String pathField = "PATH";
    private String qNameField = "QNAME";
    private int unitSize = 2;
    private List<StructuredFieldPosition> pathStructuredFieldPositions = new ArrayList<StructuredFieldPosition>();
    private List<StructuredFieldPosition> qNameStructuredFieldPositions = new ArrayList<StructuredFieldPosition>();
    private DictionaryService dictionarySertvice;
    private boolean repeats = false;

    public PathQuery(DictionaryService dictionarySertvice) {
        this.dictionarySertvice = dictionarySertvice;
    }

    public void setQuery(List<StructuredFieldPosition> path, List<StructuredFieldPosition> qname) {
        this.qNameStructuredFieldPositions.clear();
        this.pathStructuredFieldPositions.clear();
        if (qname.size() != this.unitSize) {
            throw new UnsupportedOperationException();
        }
        if (path.size() % this.unitSize != 0) {
            throw new UnsupportedOperationException();
        }
        this.qNameStructuredFieldPositions.addAll(qname);
        this.pathStructuredFieldPositions.addAll(path);
    }

    public void appendQuery(List<StructuredFieldPosition> sfps) {
        if (sfps.size() != this.unitSize) {
            throw new UnsupportedOperationException();
        }
        StructuredFieldPosition last = null;
        StructuredFieldPosition next = sfps.get(0);
        if (this.qNameStructuredFieldPositions.size() > 0) {
            last = this.qNameStructuredFieldPositions.get(this.qNameStructuredFieldPositions.size() - 1);
        }
        if (last != null && next.linkParent() && !last.allowslinkingByParent()) {
            return;
        }
        if (last != null && next.linkSelf() && !last.allowsLinkingBySelf()) {
            return;
        }
        if (this.qNameStructuredFieldPositions.size() == this.unitSize) {
            this.pathStructuredFieldPositions.addAll(this.qNameStructuredFieldPositions);
        }
        this.qNameStructuredFieldPositions.clear();
        this.qNameStructuredFieldPositions.addAll(sfps);
    }

    public String getPathField() {
        return this.pathField;
    }

    public void setPathField(String pathField) {
        this.pathField = pathField;
    }

    public String getQnameField() {
        return this.qNameField;
    }

    public void setQnameField(String qnameField) {
        this.qNameField = qnameField;
    }

    public Term getPathRootTerm() {
        return new Term(this.getPathField(), ";");
    }

    public Term getQNameRootTerm() {
        return new Term(this.getQnameField(), ";");
    }

    protected Weight createWeight(Searcher searcher) {
        return new StructuredFieldWeight(searcher);
    }

    public String toString() {
        return "";
    }

    public String toString(String field) {
        return "";
    }

    public void removeDescendantAndSelf() {
        while (this.getLast() != null && this.getLast().linkSelf()) {
            this.removeLast();
            this.removeLast();
        }
    }

    private StructuredFieldPosition getLast() {
        if (this.qNameStructuredFieldPositions.size() > 0) {
            return this.qNameStructuredFieldPositions.get(this.qNameStructuredFieldPositions.size() - 1);
        }
        return null;
    }

    private void removeLast() {
        this.qNameStructuredFieldPositions.clear();
        for (int i = 0; i < this.unitSize; ++i) {
            if (this.pathStructuredFieldPositions.size() <= 0) continue;
            this.qNameStructuredFieldPositions.add(0, this.pathStructuredFieldPositions.remove(this.pathStructuredFieldPositions.size() - 1));
        }
    }

    public boolean isEmpty() {
        return this.qNameStructuredFieldPositions.size() == 0;
    }

    public List<StructuredFieldPosition> getPathStructuredFieldPositions() {
        return this.pathStructuredFieldPositions;
    }

    public List<StructuredFieldPosition> getQNameStructuredFieldPositions() {
        return this.qNameStructuredFieldPositions;
    }

    public void setRepeats(boolean repeats) {
        this.repeats = repeats;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StructuredFieldWeight
    implements Weight {
        private static final long serialVersionUID = 3257854259645985328L;
        private Searcher searcher;
        private float value;
        private float idf;
        private float queryNorm;
        private float queryWeight;

        public StructuredFieldWeight(Searcher searcher) {
            this.searcher = searcher;
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            throw new UnsupportedOperationException();
        }

        public Query getQuery() {
            return PathQuery.this;
        }

        public float getValue() {
            return this.value;
        }

        public void normalize(float queryNorm) {
            this.queryNorm = queryNorm;
            this.queryWeight *= queryNorm;
            this.value = this.queryWeight * this.idf;
        }

        public Scorer scorer(IndexReader reader) throws IOException {
            return PathScorer.createPathScorer(PathQuery.this.getSimilarity(this.searcher), PathQuery.this, reader, this, PathQuery.this.dictionarySertvice, PathQuery.this.repeats);
        }

        public float sumOfSquaredWeights() throws IOException {
            this.idf = PathQuery.this.getSimilarity(this.searcher).idf(this.getTerms(), this.searcher);
            this.queryWeight = this.idf * PathQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        private ArrayList<Term> getTerms() {
            ArrayList<Term> answer = new ArrayList<Term>(PathQuery.this.pathStructuredFieldPositions.size());
            for (StructuredFieldPosition sfp : PathQuery.this.pathStructuredFieldPositions) {
                if (sfp.getTermText() == null) continue;
                Term term = new Term(PathQuery.this.pathField, sfp.getTermText());
                answer.add(term);
            }
            return answer;
        }
    }
}

