/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.repo.search.impl.lucene.query.CachingTermPositions;
import org.alfresco.repo.search.impl.lucene.query.ContainerScorer;
import org.alfresco.repo.search.impl.lucene.query.LeafScorer;
import org.alfresco.repo.search.impl.lucene.query.PathQuery;
import org.alfresco.repo.search.impl.lucene.query.SelfAxisStructuredFieldPosition;
import org.alfresco.repo.search.impl.lucene.query.StructuredFieldPosition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermPositions;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;

public class PathScorer
extends Scorer {
    Scorer scorer;

    PathScorer(Similarity similarity, Scorer scorer) {
        super(similarity);
        this.scorer = scorer;
    }

    public static PathScorer createPathScorer(Similarity similarity, PathQuery pathQuery, IndexReader reader, Weight weight, DictionaryService dictionarySertvice, boolean repeat) throws IOException {
        CachingTermPositions ctp;
        TermPositions p;
        PathScorer selfScorer = null;
        HashMap<String, LeafScorer.Counter> selfIds = null;
        StructuredFieldPosition last = null;
        if (pathQuery.getQNameStructuredFieldPositions().size() > 0) {
            last = pathQuery.getQNameStructuredFieldPositions().get(pathQuery.getQNameStructuredFieldPositions().size() - 1);
        }
        if (last != null && last.linkSelf()) {
            PathQuery selfQuery = new PathQuery(dictionarySertvice);
            selfQuery.setQuery(pathQuery.getPathStructuredFieldPositions(), pathQuery.getQNameStructuredFieldPositions());
            selfQuery.removeDescendantAndSelf();
            if (!selfQuery.isEmpty()) {
                selfIds = new HashMap<String, LeafScorer.Counter>();
                selfScorer = PathScorer.createPathScorer(similarity, selfQuery, reader, weight, dictionarySertvice, repeat);
                selfIds.clear();
                while (selfScorer.next()) {
                    int doc = selfScorer.doc();
                    Document document = reader.document(doc);
                    Field id = document.getField("ID");
                    LeafScorer.Counter counter = (LeafScorer.Counter)selfIds.get(id.stringValue());
                    if (counter == null) {
                        counter = new LeafScorer.Counter();
                        selfIds.put(id.stringValue(), counter);
                    }
                    ++counter.count;
                }
            }
        }
        if (pathQuery.getPathStructuredFieldPositions().size() + pathQuery.getQNameStructuredFieldPositions().size() == 0) {
            ArrayList<StructuredFieldPosition> answer = new ArrayList<StructuredFieldPosition>(2);
            answer.add(new SelfAxisStructuredFieldPosition());
            answer.add(new SelfAxisStructuredFieldPosition());
            pathQuery.appendQuery(answer);
        }
        for (StructuredFieldPosition sfp : pathQuery.getPathStructuredFieldPositions()) {
            if (sfp.getTermText() == null) continue;
            p = reader.termPositions(new Term(pathQuery.getPathField(), sfp.getTermText()));
            if (p == null) {
                return null;
            }
            ctp = new CachingTermPositions(p);
            sfp.setCachingTermPositions(ctp);
        }
        for (StructuredFieldPosition sfp : pathQuery.getQNameStructuredFieldPositions()) {
            if (sfp.getTermText() == null) continue;
            p = reader.termPositions(new Term(pathQuery.getQnameField(), sfp.getTermText()));
            if (p == null) {
                return null;
            }
            ctp = new CachingTermPositions(p);
            sfp.setCachingTermPositions(ctp);
        }
        TermPositions rootContainerPositions = null;
        if (pathQuery.getPathRootTerm() != null) {
            rootContainerPositions = reader.termPositions(pathQuery.getPathRootTerm());
        }
        TermPositions rootLeafPositions = null;
        if (pathQuery.getQNameRootTerm() != null) {
            rootLeafPositions = reader.termPositions(pathQuery.getQNameRootTerm());
        }
        TermPositions tp = reader.termPositions();
        ContainerScorer cs = null;
        TermPositions level0 = null;
        TermPositions nodePositions = reader.termPositions(new Term("ISNODE", "T"));
        if (pathQuery.getPathStructuredFieldPositions().size() > 0) {
            TermPositions containerPositions = reader.termPositions(new Term("ISCONTAINER", "T"));
            cs = new ContainerScorer(weight, rootContainerPositions, pathQuery.getPathStructuredFieldPositions().toArray(new StructuredFieldPosition[0]), containerPositions, similarity, reader.norms(pathQuery.getPathField()));
        } else {
            level0 = reader.termPositions(new Term("ISROOT", "T"));
        }
        if (cs == null && pathQuery.getQNameStructuredFieldPositions().get(pathQuery.getQNameStructuredFieldPositions().size() - 1).linkSelf()) {
            nodePositions = reader.termPositions(new Term("ISROOT", "T"));
        }
        LeafScorer ls = new LeafScorer(weight, rootLeafPositions, level0, cs, pathQuery.getQNameStructuredFieldPositions().toArray(new StructuredFieldPosition[0]), nodePositions, selfIds, reader, similarity, reader.norms(pathQuery.getQnameField()), dictionarySertvice, repeat, tp);
        return new PathScorer(similarity, ls);
    }

    public boolean next() throws IOException {
        return this.scorer.next();
    }

    public int doc() {
        return this.scorer.doc();
    }

    public float score() throws IOException {
        return this.scorer.score();
    }

    public boolean skipTo(int position) throws IOException {
        return this.scorer.skipTo(position);
    }

    public Explanation explain(int position) throws IOException {
        return this.scorer.explain(position);
    }
}

