/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.results.ChildAssocRefResultSetRow;
import org.alfresco.repo.search.results.ChildAssocRefResultSetRowIterator;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChildAssocRefResultSet
extends AbstractResultSet {
    private List<ChildAssociationRef> cars;
    NodeService nodeService;

    public ChildAssocRefResultSet(NodeService nodeService, List<ChildAssociationRef> cars, Path[] propertyPaths) {
        super(propertyPaths);
        this.nodeService = nodeService;
        this.cars = cars;
    }

    public ChildAssocRefResultSet(NodeService nodeService, List<NodeRef> nodeRefs, Path[] propertyPaths, boolean resolveAllParents) {
        super(propertyPaths);
        this.nodeService = nodeService;
        ArrayList<ChildAssociationRef> cars = new ArrayList<ChildAssociationRef>(nodeRefs.size());
        for (NodeRef nodeRef : nodeRefs) {
            if (resolveAllParents) {
                cars.addAll(nodeService.getParentAssocs(nodeRef));
                continue;
            }
            cars.add(nodeService.getPrimaryParent(nodeRef));
        }
        this.cars = cars;
    }

    @Override
    public int length() {
        return this.cars.size();
    }

    @Override
    public NodeRef getNodeRef(int n) {
        return this.cars.get(n).getChildRef();
    }

    @Override
    public ChildAssociationRef getChildAssocRef(int n) {
        return this.cars.get(n);
    }

    @Override
    public ResultSetRow getRow(int i) {
        return new ChildAssocRefResultSetRow(this, i);
    }

    @Override
    public Iterator<ResultSetRow> iterator() {
        return new ChildAssocRefResultSetRowIterator(this);
    }

    public NodeService getNodeService() {
        return this.nodeService;
    }

    @Override
    public ResultSetMetaData getResultSetMetaData() {
        return new SimpleResultSetMetaData(LimitBy.UNLIMITED, PermissionEvaluationMode.EAGER, new SearchParameters());
    }
}

