/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.results;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.alfresco.repo.search.AbstractResultSet;
import org.alfresco.repo.search.SimpleResultSetMetaData;
import org.alfresco.repo.search.results.DetachedResultSetRow;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.search.PermissionEvaluationMode;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetMetaData;
import org.alfresco.service.cmr.search.ResultSetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetachedResultSet
extends AbstractResultSet {
    List<ResultSetRow> rows = null;
    ResultSetMetaData rsmd;

    public DetachedResultSet(ResultSet resultSet, Path[] propertyPaths) {
        super(propertyPaths);
        this.rsmd = resultSet.getResultSetMetaData();
        this.rows = new ArrayList<ResultSetRow>(resultSet.length());
        for (ResultSetRow row : resultSet) {
            this.rows.add(new DetachedResultSetRow((ResultSet)this, row));
        }
    }

    @Override
    public int length() {
        return this.rows.size();
    }

    @Override
    public NodeRef getNodeRef(int n) {
        return this.rows.get(n).getNodeRef();
    }

    @Override
    public ResultSetRow getRow(int i) {
        return this.rows.get(i);
    }

    @Override
    public Iterator<ResultSetRow> iterator() {
        return this.rows.iterator();
    }

    @Override
    public ChildAssociationRef getChildAssocRef(int n) {
        return this.rows.get(n).getChildAssocRef();
    }

    @Override
    public ResultSetMetaData getResultSetMetaData() {
        return new SimpleResultSetMetaData(this.rsmd.getLimitedBy(), PermissionEvaluationMode.EAGER, this.rsmd.getSearchParameters());
    }
}

