/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextImpl;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;

public abstract class AbstractAuthenticationComponent
implements AuthenticationComponent {
    private static final String SYSTEM_USER_NAME = "System";
    private Boolean allowGuestLogin = null;

    public void setAllowGuestLogin(Boolean allowGuestLogin) {
        this.allowGuestLogin = allowGuestLogin;
    }

    public Authentication setCurrentUser(String userName) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            GrantedAuthority[] gas;
            UserDetails ud = null;
            if (userName.equals(SYSTEM_USER_NAME)) {
                gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
                ud = new User(SYSTEM_USER_NAME, "", true, true, true, true, gas);
            } else if (userName.equalsIgnoreCase("guest")) {
                gas = new GrantedAuthority[]{};
                ud = new User("guest".toLowerCase(), "", true, true, true, true, gas);
            } else {
                ud = this.getUserDetails(userName);
            }
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
            auth.setDetails((Object)ud);
            auth.setAuthenticated(true);
            return this.setCurrentAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    protected UserDetails getUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    public Authentication setCurrentAuthentication(Authentication authentication) {
        Context context = ContextHolder.getContext();
        SecureContextImpl sc = null;
        if (context == null || !(context instanceof SecureContext)) {
            sc = new SecureContextImpl();
            ContextHolder.setContext((Context)sc);
        } else {
            sc = (SecureContext)context;
        }
        authentication.setAuthenticated(true);
        sc.setAuthentication(authentication);
        return authentication;
    }

    public Authentication getCurrentAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof SecureContext)) {
            return null;
        }
        return ((SecureContext)context).getAuthentication();
    }

    public String getCurrentUserName() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof SecureContext)) {
            return null;
        }
        return this.getUserName(((SecureContext)context).getAuthentication());
    }

    private String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    public Authentication setSystemUserAsCurrentUser() {
        return this.setCurrentUser(SYSTEM_USER_NAME);
    }

    public String getSystemUserName() {
        return SYSTEM_USER_NAME;
    }

    public String getGuestUserName() {
        return "guest".toLowerCase();
    }

    public Authentication setGuestUserAsCurrentUser() throws AuthenticationException {
        if (this.allowGuestLogin == null) {
            if (this.implementationAllowsGuestLogin()) {
                return this.setCurrentUser("guest");
            }
            throw new AuthenticationException("Guest authentication is not allowed");
        }
        if (this.allowGuestLogin.booleanValue()) {
            return this.setCurrentUser("guest");
        }
        throw new AuthenticationException("Guest authentication is not allowed");
    }

    protected abstract boolean implementationAllowsGuestLogin();

    public void clearCurrentSecurityContext() {
        ContextHolder.setContext(null);
    }

    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }

    public String getMD4HashedPassword(String userName) {
        throw new UnsupportedOperationException();
    }

    public NTLMMode getNTLMMode() {
        return NTLMMode.NONE;
    }
}

