/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.NTLMMode;

public class AuthenticationComponentImpl
extends AbstractAuthenticationComponent {
    private MutableAuthenticationDao authenticationDao;
    AuthenticationManager authenticationManager;

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void authenticate(String userName, char[] password) throws AuthenticationException {
        try {
            UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userName, (Object)new String(password));
            this.authenticationManager.authenticate((Authentication)authentication);
            this.setCurrentUser(userName);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    protected UserDetails getUserDetails(String userName) {
        return this.authenticationDao.loadUserByUsername(userName);
    }

    public String getMD4HashedPassword(String userName) {
        return this.authenticationDao.getMD4HashedPassword(userName);
    }

    public NTLMMode getNTLMMode() {
        return NTLMMode.MD4_PROVIDER;
    }

    protected boolean implementationAllowsGuestLogin() {
        return true;
    }
}

