/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Collections;
import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.service.cmr.security.AuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationServiceImpl
implements AuthenticationService {
    MutableAuthenticationDao authenticationDao;
    AuthenticationComponent authenticationComponent;
    TicketComponent ticketComponent;
    private String domain;
    private boolean allowsUserCreation = true;
    private boolean allowsUserDeletion = true;
    private boolean allowsUserPasswordChange = true;

    public void setAuthenticationDao(MutableAuthenticationDao authenticationDao) {
        this.authenticationDao = authenticationDao;
    }

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    @Override
    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        this.authenticationDao.createUser(userName, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        String currentUser = AuthenticationUtil.getCurrentUserName();
        try {
            this.authenticate(userName, oldPassword);
        }
        finally {
            AuthenticationUtil.setCurrentUser(currentUser);
        }
        this.authenticationDao.updateUser(userName, newPassword);
    }

    @Override
    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        this.authenticationDao.updateUser(userName, newPassword);
    }

    @Override
    public void deleteAuthentication(String userName) throws AuthenticationException {
        this.authenticationDao.deleteUser(userName);
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        return this.authenticationDao.getEnabled(userName);
    }

    @Override
    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        this.authenticationDao.setEnabled(userName, enabled);
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        try {
            this.authenticationComponent.authenticate(userName, password);
        }
        catch (AuthenticationException ae) {
            this.clearCurrentSecurityContext();
            throw ae;
        }
    }

    @Override
    public boolean authenticationExists(String userName) {
        return this.authenticationDao.userExists(userName);
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        return this.authenticationComponent.getCurrentUserName();
    }

    @Override
    public void invalidateUserSession(String userName) throws AuthenticationException {
        this.ticketComponent.invalidateTicketByUser(userName);
    }

    @Override
    public void invalidateTicket(String ticket) throws AuthenticationException {
        this.ticketComponent.invalidateTicketById(ticket);
    }

    @Override
    public void validate(String ticket) throws AuthenticationException {
        try {
            this.authenticationComponent.setCurrentUser(this.ticketComponent.validateTicket(ticket));
        }
        catch (AuthenticationException ae) {
            this.clearCurrentSecurityContext();
            throw ae;
        }
    }

    @Override
    public String getCurrentTicket() {
        return this.ticketComponent.getTicket(this.getCurrentUserName());
    }

    @Override
    public void clearCurrentSecurityContext() {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        String userName = this.getCurrentUserName();
        return userName != null && userName.equals(this.authenticationComponent.getSystemUserName());
    }

    @Override
    public void authenticateAsGuest() throws AuthenticationException {
        this.authenticationComponent.setGuestUserAsCurrentUser();
    }

    public boolean getAllowsUserCreation() {
        return this.allowsUserCreation;
    }

    public void setAllowsUserCreation(boolean allowsUserCreation) {
        this.allowsUserCreation = allowsUserCreation;
    }

    public boolean getAllowsUserDeletion() {
        return this.allowsUserDeletion;
    }

    public void setAllowsUserDeletion(boolean allowsUserDeletion) {
        this.allowsUserDeletion = allowsUserDeletion;
    }

    public boolean getAllowsUserPasswordChange() {
        return this.allowsUserPasswordChange;
    }

    public void setAllowsUserPasswordChange(boolean allowsUserPasswordChange) {
        this.allowsUserPasswordChange = allowsUserPasswordChange;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public Set<String> getDomains() {
        return Collections.singleton(this.getDomain());
    }

    @Override
    public Set<String> getDomainsThatAllowUserCreation() {
        if (this.getAllowsUserCreation()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomainsThatAllowUserDeletion() {
        if (this.getAllowsUserDeletion()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        if (this.getAllowsUserPasswordChange()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }
}

