/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import net.sf.acegisecurity.AccountExpiredException;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationManager;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.DisabledException;
import net.sf.acegisecurity.LockedException;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.SaltSource;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.InMemoryTicketComponentImpl;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authentication.RepositoryAuthenticationDao;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private SearchService searchService;
    private NodeRef rootNodeRef;
    private NodeRef systemNodeRef;
    private NodeRef typesNodeRef;
    private NodeRef personAndyNodeRef;
    private DictionaryService dictionaryService;
    private MD4PasswordEncoder passwordEncoder;
    private MutableAuthenticationDao dao;
    private AuthenticationManager authenticationManager;
    private SaltSource saltSource;
    private TicketComponent ticketComponent;
    private AuthenticationService authenticationService;
    private AuthenticationService pubAuthenticationService;
    private AuthenticationComponent authenticationComponent;
    private PermissionServiceSPI permissionServiceSPI;
    private UserTransaction userTransaction;
    private AuthenticationComponent authenticationComponentImpl;

    public AuthenticationTest() {
    }

    public AuthenticationTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.searchService = (SearchService)ctx.getBean("searchService");
        this.dictionaryService = (DictionaryService)ctx.getBean("dictionaryService");
        this.passwordEncoder = (MD4PasswordEncoder)ctx.getBean("passwordEncoder");
        this.ticketComponent = (TicketComponent)ctx.getBean("ticketComponent");
        this.authenticationService = (AuthenticationService)ctx.getBean("authenticationService");
        this.pubAuthenticationService = (AuthenticationService)ctx.getBean("AuthenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponentImpl");
        this.permissionServiceSPI = (PermissionServiceSPI)ctx.getBean("permissionService");
        this.dao = (MutableAuthenticationDao)ctx.getBean("alfDaoImpl");
        this.authenticationManager = (AuthenticationManager)ctx.getBean("authenticationManager");
        this.saltSource = (SaltSource)ctx.getBean("saltSource");
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.userTransaction = transactionService.getUserTransaction();
        this.userTransaction.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName("http://www.alfresco.org/model/system/1.0", "system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName("http://www.alfresco.org/model/system/1.0", "people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        this.typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("Andy");
        this.personAndyNodeRef = this.nodeService.createNode(this.typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        AuthenticationTest.assertNotNull((Object)this.personAndyNodeRef);
        this.deleteAndy();
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    private void deleteAndy() {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setNodeService(this.nodeService);
        dao.setSearchService(this.searchService);
        dao.setDictionaryService(this.dictionaryService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setPasswordEncoder(this.passwordEncoder);
        if (dao.getUserOrNull("andy") != null) {
            dao.deleteUser("andy");
        }
    }

    protected void tearDown() throws Exception {
        this.authenticationComponentImpl.clearCurrentSecurityContext();
        this.userTransaction.rollback();
        super.tearDown();
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)"Andy"));
        return properties;
    }

    public void xtestScalability() {
        long create = 0L;
        long count = 0L;
        this.authenticationComponent.authenticate("admin", "admin".toCharArray());
        for (int i = 0; i < 10000; ++i) {
            String id = "TestUser-" + i;
            long start = System.nanoTime();
            this.authenticationService.createAuthentication(id, id.toCharArray());
            long end = System.nanoTime();
            create += end - start;
            if (i <= 0 || i % 100 != 0) continue;
            System.out.println("Count = " + i);
            System.out.println("Average create : " + (float)(create / (long)i) / 1000000.0f);
            start = System.nanoTime();
            this.dao.userExists(id);
            end = System.nanoTime();
            System.out.println("Exists : " + (float)(end - start) / 1000000.0f);
        }
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    public void testCreateAndyUserAndOtherCRUD() throws NoSuchAlgorithmException, UnsupportedEncodingException {
        RepositoryAuthenticationDao dao = new RepositoryAuthenticationDao();
        dao.setNodeService(this.nodeService);
        dao.setSearchService(this.searchService);
        dao.setDictionaryService(this.dictionaryService);
        dao.setNamespaceService(this.getNamespacePrefixReolsver(""));
        dao.setPasswordEncoder(this.passwordEncoder);
        dao.createUser("Andy", "cabbage".toCharArray());
        AuthenticationTest.assertNotNull((Object)dao.getUserOrNull("Andy"));
        byte[] decodedHash = this.passwordEncoder.decodeHash(dao.getMD4HashedPassword("Andy"));
        byte[] testHash = MessageDigest.getInstance("MD4").digest("cabbage".getBytes("UnicodeLittleUnmarked"));
        AuthenticationTest.assertEquals((String)new String(decodedHash), (String)new String(testHash));
        UserDetails AndyDetails = dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((Object)AndyDetails);
        AuthenticationTest.assertEquals((String)(dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)AndyDetails.getUsername());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((boolean)AndyDetails.isEnabled());
        AuthenticationTest.assertNotSame((Object)"cabbage", (Object)AndyDetails.getPassword());
        AuthenticationTest.assertEquals((String)AndyDetails.getPassword(), (String)this.passwordEncoder.encodePassword("cabbage", this.saltSource.getSalt(AndyDetails)));
        AuthenticationTest.assertEquals((int)1, (int)AndyDetails.getAuthorities().length);
        dao.updateUser("Andy", "carrot".toCharArray());
        UserDetails newDetails = dao.loadUserByUsername("Andy");
        AuthenticationTest.assertNotNull((Object)newDetails);
        AuthenticationTest.assertEquals((String)(dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)newDetails.getUsername());
        AuthenticationTest.assertTrue((boolean)newDetails.isAccountNonExpired());
        AuthenticationTest.assertTrue((boolean)newDetails.isAccountNonLocked());
        AuthenticationTest.assertTrue((boolean)newDetails.isCredentialsNonExpired());
        AuthenticationTest.assertTrue((boolean)newDetails.isEnabled());
        AuthenticationTest.assertNotSame((Object)"carrot", (Object)newDetails.getPassword());
        AuthenticationTest.assertEquals((int)1, (int)newDetails.getAuthorities().length);
        AuthenticationTest.assertNotSame((Object)AndyDetails.getPassword(), (Object)newDetails.getPassword());
        dao.deleteUser("Andy");
        AuthenticationTest.assertNull((Object)dao.getUserOrNull("Andy"));
        try {
            MessageDigest digester = MessageDigest.getInstance("MD4");
            System.out.println("Digester from " + digester.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            System.out.println("No digester");
        }
    }

    public void testAuthentication() {
        this.dao.createUser("GUEST", "".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"GUEST", (Object)"");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.createUser("Andy", "squash".toCharArray());
        token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"squash");
        token.setAuthenticated(false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setEnabled("Andy", false);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (DisabledException e) {
            // empty catch block
        }
        this.dao.setEnabled("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setLocked("Andy", true);
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (LockedException e) {
            // empty catch block
        }
        this.dao.setLocked("Andy", false);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpires("Andy", true);
        this.dao.setCredentialsExpire("Andy", true);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", null);
        this.dao.setCredentialsExpiryDate("Andy", null);
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AccountExpiredException e) {
            // empty catch block
        }
        this.dao.setAccountExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() - 10000L));
        try {
            result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (CredentialsExpiredException credentialsExpiredException) {
            // empty catch block
        }
        this.dao.setCredentialsExpiryDate("Andy", new Date(new Date().getTime() + 10000L));
        result = this.authenticationManager.authenticate((Authentication)token);
        AuthenticationTest.assertNotNull((Object)result);
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationFailure() {
        this.dao.createUser("Andy", "squash".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"turnip");
        token.setAuthenticated(false);
        try {
            Authentication result = this.authenticationManager.authenticate((Authentication)token);
            AuthenticationTest.assertNotNull((Object)result);
            AuthenticationTest.assertNotNull(null);
        }
        catch (BadCredentialsException badCredentialsException) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    public void testTicket() {
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = this.ticketComponent.getTicket(this.getUserName(result));
        String user = this.ticketComponent.validateTicket(ticket);
        user = null;
        try {
            user = this.ticketComponent.validateTicket("INVALID");
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            AuthenticationTest.assertNull((Object)user);
        }
        this.ticketComponent.invalidateTicketById(ticket);
        try {
            user = this.ticketComponent.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    public void testTicketRepeat() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        tc.validateTicket(ticket);
        this.dao.deleteUser("Andy");
    }

    public void testTicketOneOff() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(true);
        tc.setTicketsExpire(false);
        tc.setValidDuration("P0D");
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketExpires() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P5S");
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        tc.validateTicket(ticket);
        tc.validateTicket(ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        AuthenticationTest e = this;
        synchronized (e) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        try {
            tc.validateTicket(ticket);
            AuthenticationTest.assertNotNull(null);
        }
        catch (AuthenticationException e2) {
            // empty catch block
        }
        this.dao.deleteUser("Andy");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTicketDoesNotExpire() {
        InMemoryTicketComponentImpl tc = new InMemoryTicketComponentImpl();
        tc.setOneOff(false);
        tc.setTicketsExpire(true);
        tc.setValidDuration("P1D");
        this.dao.createUser("Andy", "ticket".toCharArray());
        UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken((Object)"Andy", (Object)"ticket");
        token.setAuthenticated(false);
        Authentication result = this.authenticationManager.authenticate((Authentication)token);
        result.setAuthenticated(true);
        String ticket = tc.getTicket(this.getUserName(result));
        tc.validateTicket(ticket);
        tc.validateTicket(ticket);
        tc.validateTicket(ticket);
        AuthenticationTest authenticationTest = this;
        synchronized (authenticationTest) {
            try {
                ((Object)((Object)this)).wait(10000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        tc.validateTicket(ticket);
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationService1() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService2() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.authenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService3() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        this.authenticationService.invalidateTicket(ticket);
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid taicket should have been rejected");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAuthenticationService4() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.validate(ticket);
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        try {
            this.authenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Invalid ticket should have been rejected");
        }
        catch (AuthenticationException e) {
            AuthenticationTest.assertNull((Object)this.authenticationComponentImpl.getCurrentAuthentication());
        }
    }

    public void testAuthenticationService() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth4".toCharArray(), "auth5".toCharArray());
        this.authenticationService.authenticate("Andy", "auth5".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testAuthenticationService0() {
        this.authenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.authenticationService.clearCurrentSecurityContext();
        this.authenticationService.deleteAuthentication("Andy");
        this.authenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.authenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationService.authenticate("Andy", "auth3".toCharArray());
        this.authenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        String ticket = this.authenticationService.getCurrentTicket();
        this.authenticationService.validate(ticket);
        this.authenticationService.invalidateTicket(ticket);
        Authentication current = this.authenticationComponent.getCurrentAuthentication();
        if (current != null) {
            AuthenticationTest.assertTrue((boolean)current.isAuthenticated());
        }
        this.authenticationService.authenticate("Andy", "auth4".toCharArray());
        this.authenticationService.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationService.getCurrentUserName());
        this.dao.deleteUser("Andy");
    }

    public void testPubAuthenticationService1() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService2() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        try {
            this.pubAuthenticationService.authenticate("Andy", "auth2".toCharArray());
            AuthenticationTest.fail((String)"Authentication should fail");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService3() {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.validate(ticket);
        this.pubAuthenticationService.invalidateTicket(ticket);
        try {
            this.pubAuthenticationService.validate(ticket);
            AuthenticationTest.fail((String)"Ticket should not validate");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testPubAuthenticationService() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        this.pubAuthenticationService.invalidateTicket(ticket);
    }

    public void testPubAuthenticationService0() {
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.pubAuthenticationService.authenticate("GUEST", "".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.pubAuthenticationService.authenticateAsGuest();
        this.authenticationComponent.clearCurrentSecurityContext();
        AuthenticationTest.assertNull((Object)this.authenticationComponent.getCurrentAuthentication());
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth1".toCharArray());
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
        this.pubAuthenticationService.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.deleteAuthentication("Andy");
        this.authenticationComponent.clearCurrentSecurityContext();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.pubAuthenticationService.createAuthentication("Andy", "auth2".toCharArray());
        this.pubAuthenticationService.setAuthentication("Andy", "auth3".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        String ticket = this.pubAuthenticationService.getCurrentTicket();
        this.pubAuthenticationService.validate(ticket);
        this.pubAuthenticationService.invalidateTicket(ticket);
        this.authenticationComponent.clearCurrentSecurityContext();
        this.pubAuthenticationService.authenticate("Andy", "auth3".toCharArray());
        this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
        this.pubAuthenticationService.authenticate("Andy", "auth4".toCharArray());
        try {
            this.pubAuthenticationService.updateAuthentication("Andy", "auth3".toCharArray(), "auth4".toCharArray());
            AuthenticationTest.fail((String)"Should not be able to update");
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAbstractAuthenticationComponentGuestUserSupport() {
        this.authenticationComponent.setGuestUserAsCurrentUser();
        AuthenticationTest.assertEquals((String)this.authenticationComponent.getCurrentUserName(), (String)this.authenticationComponent.getGuestUserName());
    }

    public void testPassThroughLogin() {
        this.authenticationService.createAuthentication("Andy", "auth1".toCharArray());
        this.authenticationComponent.setCurrentUser("Andy");
        AuthenticationTest.assertEquals((String)(this.dao.getUserNamesAreCaseSensitive() ? "Andy" : "andy"), (String)this.authenticationService.getCurrentUserName());
    }

    private String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("usr", "http://www.alfresco.org/model/user/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }
}

