/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.context.Context;
import net.sf.acegisecurity.context.ContextHolder;
import net.sf.acegisecurity.context.security.SecureContext;
import net.sf.acegisecurity.context.security.SecureContextImpl;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;
import net.sf.acegisecurity.providers.dao.User;
import org.alfresco.repo.security.authentication.AuthenticationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AuthenticationUtil {
    private static final String SYSTEM_USER_NAME = "System";

    private AuthenticationUtil() {
    }

    public static Authentication setCurrentUser(String userName) {
        return AuthenticationUtil.setCurrentUser(userName, AuthenticationUtil.getDefaultUserDetails(userName));
    }

    public static Authentication setCurrentUser(String userName, UserDetails providedDetails) throws AuthenticationException {
        if (userName == null) {
            throw new AuthenticationException("Null user name");
        }
        try {
            GrantedAuthority[] gas;
            UserDetails ud = null;
            if (userName.equals(SYSTEM_USER_NAME)) {
                gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_SYSTEM")};
                ud = new User(SYSTEM_USER_NAME, "", true, true, true, true, gas);
            } else if (userName.equalsIgnoreCase("guest")) {
                gas = new GrantedAuthority[]{};
                ud = new User("guest".toLowerCase(), "", true, true, true, true, gas);
            } else if (providedDetails.getUsername().equals(userName)) {
                ud = providedDetails;
            } else {
                throw new AuthenticationException("Provided user details do not match the user name");
            }
            UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)ud, (Object)"", ud.getAuthorities());
            auth.setDetails((Object)ud);
            auth.setAuthenticated(true);
            return AuthenticationUtil.setCurrentAuthentication((Authentication)auth);
        }
        catch (net.sf.acegisecurity.AuthenticationException ae) {
            throw new AuthenticationException(ae.getMessage(), ae);
        }
    }

    private static UserDetails getDefaultUserDetails(String userName) {
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, "", true, true, true, true, gas);
        return ud;
    }

    public static Authentication setCurrentAuthentication(Authentication authentication) {
        Context context = ContextHolder.getContext();
        SecureContextImpl sc = null;
        if (context == null || !(context instanceof SecureContext)) {
            sc = new SecureContextImpl();
            ContextHolder.setContext((Context)sc);
        } else {
            sc = (SecureContext)context;
        }
        authentication.setAuthenticated(true);
        sc.setAuthentication(authentication);
        return authentication;
    }

    public static Authentication getCurrentAuthentication() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof SecureContext)) {
            return null;
        }
        return ((SecureContext)context).getAuthentication();
    }

    public static String getCurrentUserName() throws AuthenticationException {
        Context context = ContextHolder.getContext();
        if (context == null || !(context instanceof SecureContext)) {
            return null;
        }
        return AuthenticationUtil.getUserName(((SecureContext)context).getAuthentication());
    }

    private static String getUserName(Authentication authentication) {
        String username = authentication.getPrincipal().toString();
        if (authentication.getPrincipal() instanceof UserDetails) {
            username = ((UserDetails)authentication.getPrincipal()).getUsername();
        }
        return username;
    }

    public static Authentication setSystemUserAsCurrentUser() {
        return AuthenticationUtil.setCurrentUser(SYSTEM_USER_NAME);
    }

    public static String getSystemUserName() {
        return SYSTEM_USER_NAME;
    }

    public static String getGuestUserName() {
        return "guest".toLowerCase();
    }

    public static void clearCurrentSecurityContext() {
        ContextHolder.setContext(null);
    }

    public static <R> R runAs(RunAsWork<R> runAsWork, String uid) {
        String currentUser = AuthenticationUtil.getCurrentUserName();
        R result = null;
        try {
            AuthenticationUtil.setCurrentUser(uid);
            R r = result = (R)runAsWork.doWork();
            return r;
        }
        catch (Throwable exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException("Error during run as.", exception);
        }
        finally {
            AuthenticationUtil.clearCurrentSecurityContext();
            if (currentUser != null) {
                AuthenticationUtil.setCurrentUser(currentUser);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface RunAsWork<Result> {
        public Result doWork() throws Exception;
    }
}

