/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.service.cmr.security.AuthenticationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainingAuthenticationServiceImpl
implements AuthenticationService {
    private List<AuthenticationService> authenticationServices;
    private AuthenticationService mutableAuthenticationService;

    public List<AuthenticationService> getAuthenticationServices() {
        return this.authenticationServices;
    }

    public void setAuthenticationServices(List<AuthenticationService> authenticationServices) {
        this.authenticationServices = authenticationServices;
    }

    public AuthenticationService getMutableAuthenticationService() {
        return this.mutableAuthenticationService;
    }

    public void setMutableAuthenticationService(AuthenticationService mutableAuthenticationService) {
        this.mutableAuthenticationService = mutableAuthenticationService;
    }

    @Override
    public void createAuthentication(String userName, char[] password) throws AuthenticationException {
        if (this.mutableAuthenticationService == null) {
            throw new AuthenticationException("Unable to create authentication as there is no suitable authentication service.");
        }
        this.mutableAuthenticationService.createAuthentication(userName, password);
    }

    @Override
    public void updateAuthentication(String userName, char[] oldPassword, char[] newPassword) throws AuthenticationException {
        if (this.mutableAuthenticationService == null) {
            throw new AuthenticationException("Unable to update authentication as there is no suitable authentication service.");
        }
        this.mutableAuthenticationService.updateAuthentication(userName, oldPassword, newPassword);
    }

    @Override
    public void setAuthentication(String userName, char[] newPassword) throws AuthenticationException {
        if (this.mutableAuthenticationService == null) {
            throw new AuthenticationException("Unable to set authentication as there is no suitable authentication service.");
        }
        this.mutableAuthenticationService.setAuthentication(userName, newPassword);
    }

    @Override
    public void deleteAuthentication(String userName) throws AuthenticationException {
        if (this.mutableAuthenticationService == null) {
            throw new AuthenticationException("Unable to delete authentication as there is no suitable authentication service.");
        }
        this.mutableAuthenticationService.deleteAuthentication(userName);
    }

    @Override
    public void setAuthenticationEnabled(String userName, boolean enabled) throws AuthenticationException {
        if (this.mutableAuthenticationService == null) {
            throw new AuthenticationException("Unable to set authentication enabled as there is no suitable authentication service.");
        }
        this.mutableAuthenticationService.setAuthenticationEnabled(userName, enabled);
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                if (!authService.getAuthenticationEnabled(userName)) continue;
                return true;
            }
            catch (AuthenticationException e) {
            }
        }
        return false;
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.authenticate(userName, password);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Failed to authenticate");
    }

    @Override
    public void authenticateAsGuest() throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.authenticateAsGuest();
                return;
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        throw new AuthenticationException("Guest authentication not supported");
    }

    @Override
    public boolean authenticationExists(String userName) {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            if (!authService.authenticationExists(userName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.getCurrentUserName();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        return null;
    }

    @Override
    public void invalidateUserSession(String userName) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.invalidateUserSession(userName);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to invalidate user session");
    }

    @Override
    public void invalidateTicket(String ticket) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.invalidateTicket(ticket);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to invalidate ticket");
    }

    @Override
    public void validate(String ticket) throws AuthenticationException {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.validate(ticket);
                return;
            }
            catch (AuthenticationException e) {
            }
        }
        throw new AuthenticationException("Unable to validate ticket");
    }

    @Override
    public String getCurrentTicket() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.getCurrentTicket();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        return null;
    }

    @Override
    public void clearCurrentSecurityContext() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                authService.clearCurrentSecurityContext();
                return;
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        throw new AuthenticationException("Failed to clear security context");
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            try {
                return authService.isCurrentUserTheSystemUser();
            }
            catch (AuthenticationException authenticationException) {
            }
        }
        return false;
    }

    private List<AuthenticationService> getUsableAuthenticationServices() {
        if (this.mutableAuthenticationService == null) {
            return this.authenticationServices;
        }
        ArrayList<AuthenticationService> services = new ArrayList<AuthenticationService>(this.authenticationServices == null ? 1 : this.authenticationServices.size() + 1);
        services.add(this.mutableAuthenticationService);
        if (this.authenticationServices != null) {
            services.addAll(this.authenticationServices);
        }
        return services;
    }

    @Override
    public Set<String> getDomains() {
        HashSet<String> domains = new HashSet<String>();
        for (AuthenticationService authService : this.getUsableAuthenticationServices()) {
            domains.addAll(authService.getDomains());
        }
        return domains;
    }

    @Override
    public Set<String> getDomainsThatAllowUserCreation() {
        HashSet<String> domains = new HashSet<String>();
        if (this.mutableAuthenticationService != null) {
            domains.addAll(this.mutableAuthenticationService.getDomainsThatAllowUserCreation());
        }
        return domains;
    }

    @Override
    public Set<String> getDomainsThatAllowUserDeletion() {
        HashSet<String> domains = new HashSet<String>();
        if (this.mutableAuthenticationService != null) {
            domains.addAll(this.mutableAuthenticationService.getDomainsThatAllowUserDeletion());
        }
        return domains;
    }

    @Override
    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        HashSet<String> domains = new HashSet<String>();
        if (this.mutableAuthenticationService != null) {
            domains.addAll(this.mutableAuthenticationService.getDomiansThatAllowUserPasswordChanges());
        }
        return domains;
    }
}

