/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.TicketComponent;
import org.alfresco.repo.security.authentication.TicketExpiredException;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.util.GUID;

public class InMemoryTicketComponentImpl
implements TicketComponent {
    public static final String GRANTED_AUTHORITY_TICKET_PREFIX = "TICKET_";
    private boolean ticketsExpire;
    private Duration validDuration;
    private boolean oneOff;
    private HashMap<String, Ticket> tickets = new HashMap();

    public String getTicket(String userName) throws AuthenticationException {
        Date expiryDate = null;
        if (this.ticketsExpire) {
            expiryDate = Duration.add(new Date(), this.validDuration);
        }
        Ticket ticket = new Ticket(this.ticketsExpire, expiryDate, userName);
        this.tickets.put(ticket.getTicketId(), ticket);
        return GRANTED_AUTHORITY_TICKET_PREFIX + ticket.getTicketId();
    }

    public String validateTicket(String ticketString) throws AuthenticationException {
        if (ticketString.length() < GRANTED_AUTHORITY_TICKET_PREFIX.length()) {
            throw new AuthenticationException(ticketString + " is an invalid ticket format");
        }
        String key = ticketString.substring(GRANTED_AUTHORITY_TICKET_PREFIX.length());
        Ticket ticket = this.tickets.get(key);
        if (ticket == null) {
            throw new AuthenticationException("Missing ticket for " + ticketString);
        }
        if (ticket.hasExpired()) {
            throw new TicketExpiredException("Ticket expired for " + ticketString);
        }
        if (this.oneOff) {
            this.tickets.remove(key);
        }
        return ticket.getUserName();
    }

    public void invalidateTicketById(String ticketString) {
        String key = ticketString.substring(GRANTED_AUTHORITY_TICKET_PREFIX.length());
        this.tickets.remove(key);
    }

    public void invalidateTicketByUser(String userName) {
        HashSet<String> toRemove = new HashSet<String>();
        for (String key : this.tickets.keySet()) {
            Ticket ticket = this.tickets.get(key);
            if (!ticket.getUserName().equals(userName)) continue;
            toRemove.add(ticket.getTicketId());
        }
        for (String id : toRemove) {
            this.tickets.remove(id);
        }
    }

    public void setOneOff(boolean oneOff) {
        this.oneOff = oneOff;
    }

    public void setTicketsExpire(boolean ticketsExpire) {
        this.ticketsExpire = ticketsExpire;
    }

    public void setValidDuration(String validDuration) {
        this.validDuration = new Duration(validDuration);
    }

    private static class Ticket {
        private boolean expires;
        private Date expiryDate;
        private String userName;
        private String ticketId;

        Ticket(boolean expires, Date expiryDate, String userName) {
            this.expires = expires;
            this.expiryDate = expiryDate;
            this.userName = userName;
            this.ticketId = GUID.generate();
        }

        boolean hasExpired() {
            return this.expires && this.expiryDate != null && this.expiryDate.compareTo(new Date()) < 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Ticket)) {
                return false;
            }
            Ticket t = (Ticket)o;
            return this.expires == t.expires && this.expiryDate.equals(t.expiryDate) && this.userName.equals(t.userName) && this.ticketId.equals(t.ticketId);
        }

        public int hashCode() {
            return this.ticketId.hashCode();
        }

        protected boolean getExpires() {
            return this.expires;
        }

        protected Date getExpiryDate() {
            return this.expiryDate;
        }

        protected String getTicketId() {
            return this.ticketId;
        }

        protected String getUserName() {
            return this.userName;
        }
    }
}

