/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import cryptix.jce.provider.CryptixCrypto;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import net.sf.acegisecurity.providers.encoding.BaseDigestPasswordEncoder;
import org.alfresco.repo.security.authentication.MD4PasswordEncoder;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

public class MD4PasswordEncoderImpl
extends BaseDigestPasswordEncoder
implements MD4PasswordEncoder {
    public boolean isPasswordValid(String encPass, String rawPass, Object salt) {
        String pass1 = "" + encPass;
        String pass2 = this.encodeInternal(this.mergePasswordAndSalt(rawPass, salt, false));
        return pass1.equals(pass2);
    }

    public String encodePassword(String rawPass, Object salt) {
        return this.encodeInternal(this.mergePasswordAndSalt(rawPass, salt, false));
    }

    private String encodeInternal(String input) {
        if (!this.getEncodeHashAsBase64()) {
            return new String(Hex.encodeHex((byte[])this.md4(input)));
        }
        byte[] encoded = Base64.encodeBase64((byte[])this.md4(input));
        try {
            return new String(encoded, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 not supported!", e);
        }
    }

    private byte[] md4(String input) {
        try {
            MessageDigest digester = MessageDigest.getInstance("MD4");
            return digester.digest(input.getBytes("UnicodeLittleUnmarked"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public byte[] decodeHash(String encodedHash) {
        if (!this.getEncodeHashAsBase64()) {
            try {
                return Hex.decodeHex((char[])encodedHash.toCharArray());
            }
            catch (DecoderException e) {
                throw new RuntimeException("Unable to decode password hash");
            }
        }
        return Base64.decodeBase64((byte[])encodedHash.getBytes());
    }

    static {
        try {
            MessageDigest.getInstance("MD4");
        }
        catch (NoSuchAlgorithmException e) {
            Security.addProvider((Provider)new CryptixCrypto());
        }
    }
}

