/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import net.sf.acegisecurity.UserDetails;
import net.sf.acegisecurity.providers.dao.User;
import net.sf.acegisecurity.providers.dao.UsernameNotFoundException;
import net.sf.acegisecurity.providers.encoding.PasswordEncoder;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.springframework.dao.DataAccessException;

public class RepositoryAuthenticationDao
implements MutableAuthenticationDao {
    private static final StoreRef STOREREF_USERS = new StoreRef("user", "alfrescoUserStore");
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private DictionaryService dictionaryService;
    private SearchService searchService;
    private PasswordEncoder passwordEncoder;
    private boolean userNamesAreCaseSensitive;

    public boolean getUserNamesAreCaseSensitive() {
        return this.userNamesAreCaseSensitive;
    }

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public UserDetails loadUserByUsername(String caseSensitiveUserName) throws UsernameNotFoundException, DataAccessException {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new UsernameNotFoundException("Could not find user by userName: " + caseSensitiveUserName);
        }
        Map<QName, Serializable> properties = this.nodeService.getProperties(userRef);
        String password = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)properties.get(ContentModel.PROP_PASSWORD));
        GrantedAuthority[] gas = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
        User ud = new User(userName, password, this.getEnabled(userRef), !this.getAccountHasExpired(userRef), !this.getCredentialsHaveExpired(userRef), !this.getAccountlocked(userRef), gas);
        return ud;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef getUserOrNull(String caseSensitiveUserName) {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        SearchParameters sp = new SearchParameters();
        sp.setLanguage("lucene");
        sp.setQuery("@usr\\:username:" + userName);
        sp.addStore(STOREREF_USERS);
        sp.excludeDataInTheCurrentTransaction(false);
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            for (ResultSetRow row : rs) {
                String realUserName;
                NodeRef nodeRef = row.getNodeRef();
                if (!this.nodeService.exists(nodeRef) || !(realUserName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_USER_USERNAME))).equals(userName)) continue;
                NodeRef nodeRef2 = nodeRef;
                return nodeRef2;
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return null;
    }

    public void createUser(String caseSensitiveUserName, char[] rawPassword) throws AuthenticationException {
        String userName = this.userNamesAreCaseSensitive ? caseSensitiveUserName : caseSensitiveUserName.toLowerCase();
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef != null) {
            throw new AuthenticationException("User already exists: " + userName);
        }
        NodeRef typesNode = this.getUserFolderLocation();
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USER_USERNAME, (Serializable)((Object)userName));
        Object salt = null;
        properties.put(ContentModel.PROP_SALT, (Serializable)salt);
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)this.passwordEncoder.encodePassword(new String(rawPassword), salt)));
        properties.put(ContentModel.PROP_ACCOUNT_EXPIRES, Boolean.valueOf(false));
        properties.put(ContentModel.PROP_CREDENTIALS_EXPIRE, Boolean.valueOf(false));
        properties.put(ContentModel.PROP_ENABLED, Boolean.valueOf(true));
        properties.put(ContentModel.PROP_ACCOUNT_LOCKED, Boolean.valueOf(false));
        this.nodeService.createNode(typesNode, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_USER, ContentModel.TYPE_USER, properties);
    }

    private NodeRef getUserFolderLocation() {
        QName qnameAssocSystem = QName.createQName("sys", "system", this.namespacePrefixResolver);
        QName qnameAssocUsers = QName.createQName("sys", "people", this.namespacePrefixResolver);
        NodeRef rootNode = this.nodeService.getRootNode(STOREREF_USERS);
        List<ChildAssociationRef> results = this.nodeService.getChildAssocs(rootNode, RegexQNamePattern.MATCH_ALL, qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority system folder path not found: " + qnameAssocSystem);
        }
        sysNodeRef = results.get(0).getChildRef();
        results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, qnameAssocUsers);
        NodeRef userNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required user folder path not found: " + qnameAssocUsers);
        }
        userNodeRef = results.get(0).getChildRef();
        return userNodeRef;
    }

    public void updateUser(String userName, char[] rawPassword) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        Map<QName, Serializable> properties = this.nodeService.getProperties(userRef);
        Object salt = null;
        properties.remove(ContentModel.PROP_SALT);
        properties.put(ContentModel.PROP_SALT, (Serializable)salt);
        properties.remove(ContentModel.PROP_PASSWORD);
        properties.put(ContentModel.PROP_PASSWORD, (Serializable)((Object)this.passwordEncoder.encodePassword(new String(rawPassword), salt)));
        this.nodeService.setProperties(userRef, properties);
    }

    public void deleteUser(String userName) throws AuthenticationException {
        NodeRef userRef = this.getUserOrNull(userName);
        if (userRef == null) {
            throw new AuthenticationException("User name does not exist: " + userName);
        }
        this.nodeService.deleteNode(userRef);
    }

    public Object getSalt(UserDetails userDetails) {
        return null;
    }

    public boolean userExists(String userName) {
        return this.getUserOrNull(userName) != null;
    }

    public boolean getAccountExpires(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue(ser);
    }

    public Date getAccountExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue(this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            return DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
        }
        return null;
    }

    public boolean getAccountHasExpired(String userName) {
        return this.getAccountHasExpired(this.getUserOrNull(userName));
    }

    private boolean getAccountHasExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue(this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES))) {
            Date date = DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    public boolean getAccountlocked(String userName) {
        return this.getAccountlocked(this.getUserOrNull(userName));
    }

    private boolean getAccountlocked(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue(ser);
    }

    public boolean getCredentialsExpire(String userName) {
        return this.getCredentialsExpired(this.getUserOrNull(userName));
    }

    private boolean getCredentialsExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE);
        if (ser == null) {
            return false;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue(ser);
    }

    public Date getCredentialsExpiryDate(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue(this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            return DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
        }
        return null;
    }

    public boolean getCredentialsHaveExpired(String userName) {
        return this.getCredentialsHaveExpired(this.getUserOrNull(userName));
    }

    private boolean getCredentialsHaveExpired(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        if (DefaultTypeConverter.INSTANCE.booleanValue(this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE))) {
            Date date = DefaultTypeConverter.INSTANCE.convert(Date.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE));
            if (date == null) {
                return false;
            }
            return date.compareTo(new Date()) < 1;
        }
        return false;
    }

    public boolean getEnabled(String userName) {
        return this.getEnabled(this.getUserOrNull(userName));
    }

    private boolean getEnabled(NodeRef userNode) {
        if (userNode == null) {
            return false;
        }
        Serializable ser = this.nodeService.getProperty(userNode, ContentModel.PROP_ENABLED);
        if (ser == null) {
            return true;
        }
        return DefaultTypeConverter.INSTANCE.booleanValue(ser);
    }

    public void setAccountExpires(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRES, Boolean.valueOf(expires));
    }

    public void setAccountExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_EXPIRY_DATE, exipryDate);
    }

    public void setCredentialsExpire(String userName, boolean expires) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRE, Boolean.valueOf(expires));
    }

    public void setCredentialsExpiryDate(String userName, Date exipryDate) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_CREDENTIALS_EXPIRY_DATE, exipryDate);
    }

    public void setEnabled(String userName, boolean enabled) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ENABLED, Boolean.valueOf(enabled));
    }

    public void setLocked(String userName, boolean locked) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            throw new AuthenticationException("User not found: " + userName);
        }
        this.nodeService.setProperty(userNode, ContentModel.PROP_ACCOUNT_LOCKED, Boolean.valueOf(locked));
    }

    public String getMD4HashedPassword(String userName) {
        NodeRef userNode = this.getUserOrNull(userName);
        if (userNode == null) {
            return null;
        }
        String password = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(userNode, ContentModel.PROP_PASSWORD));
        return password;
    }
}

