/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;

public class LDAPAuthenticationComponentImpl
extends AbstractAuthenticationComponent {
    private String userNameFormat;
    private LDAPInitialDirContextFactory ldapInitialContextFactory;

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setUserNameFormat(String userNameFormat) {
        this.userNameFormat = userNameFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        InitialContext ctx = null;
        try {
            ctx = this.ldapInitialContextFactory.getInitialDirContext(String.format(this.userNameFormat, userName), new String(password));
            this.setCurrentUser(userName);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    this.clearCurrentSecurityContext();
                    throw new AuthenticationException("Failed to close connection", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean implementationAllowsGuestLogin() {
        InitialDirContext ctx = null;
        try {
            ctx = this.ldapInitialContextFactory.getDefaultIntialDirContext();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new AuthenticationException("Failed to close connection", e);
                }
            }
        }
    }
}

