/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ExportSource;
import org.alfresco.repo.importer.ExportSourceImporterException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPGroupExportSource
implements ExportSource,
InitializingBean {
    private static Log s_logger = LogFactory.getLog(LDAPGroupExportSource.class);
    private String groupQuery = "(objectclass=groupOfNames)";
    private String searchBase;
    private String groupIdAttributeName = "cn";
    private String userIdAttributeName = "uid";
    private String groupType = "groupOfNames";
    private String personType = "inetOrgPerson";
    private LDAPInitialDirContextFactory ldapInitialContextFactory;
    private NamespaceService namespaceService;
    private String memberAttribute = "member";
    private boolean errorOnMissingMembers = false;
    private QName viewRef;
    private QName viewId;
    private QName viewAssociations;
    private QName childQName;
    private QName viewValueQName;
    private QName viewIdRef;
    private AuthorityDAO authorityDAO;

    public void setGroupIdAttributeName(String groupIdAttributeName) {
        this.groupIdAttributeName = groupIdAttributeName;
    }

    public void setGroupQuery(String groupQuery) {
        this.groupQuery = groupQuery;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setMemberAttribute(String memberAttribute) {
        this.memberAttribute = memberAttribute;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPersonType(String personType) {
        this.personType = personType;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setUserIdAttributeName(String userIdAttributeName) {
        this.userIdAttributeName = userIdAttributeName;
    }

    public void setErrorOnMissingMembers(boolean errorOnMissingMembers) {
        this.errorOnMissingMembers = errorOnMissingMembers;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    @Override
    public void generateExport(XMLWriter writer) {
        HashSet<Group> rootGroups = new HashSet<Group>();
        HashMap<String, Group> lookup = new HashMap<String, Group>();
        HashSet<SecondaryLink> secondaryLinks = new HashSet<SecondaryLink>();
        this.buildGroupsAndRoots(rootGroups, lookup, secondaryLinks);
        this.buildXML(rootGroups, lookup, secondaryLinks, writer);
    }

    private void buildXML(HashSet<Group> rootGroups, HashMap<String, Group> lookup, HashSet<SecondaryLink> secondaryLinks, XMLWriter writer) {
        Collection<String> prefixes = this.namespaceService.getPrefixes();
        QName childQName = QName.createQName("view", "childName", this.namespaceService);
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", childQName.getLocalName(), childQName.toPrefixString(), null, ContentModel.TYPE_PERSON.toPrefixString(this.namespaceService));
            writer.startDocument();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                String uri = this.namespaceService.getNamespaceURI(prefix);
                writer.startPrefixMapping(prefix, uri);
            }
            writer.startElement("view", "view", "view:view", (org.xml.sax.Attributes)new AttributesImpl());
            for (Group group : rootGroups) {
                this.addRootGroup(lookup, group, writer);
            }
            for (SecondaryLink sl : secondaryLinks) {
                this.addSecondarylink(lookup, sl, writer);
            }
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                writer.endPrefixMapping(prefix);
            }
            writer.endElement("view", "view", "view:view");
            writer.endDocument();
        }
        catch (SAXException e) {
            throw new ExportSourceImporterException("Failed to create file for import.", e);
        }
    }

    private void addSecondarylink(HashMap<String, Group> lookup, SecondaryLink sl, XMLWriter writer) throws SAXException {
        String fromId = lookup.get((Object)sl.from).guid;
        String toId = lookup.get((Object)sl.to).guid;
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(this.viewIdRef.getNamespaceURI(), this.viewIdRef.getLocalName(), this.viewIdRef.toPrefixString(), null, fromId);
        writer.startElement(this.viewRef.getNamespaceURI(), this.viewRef.getLocalName(), this.viewRef.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)attrs);
        writer.startElement(this.viewAssociations.getNamespaceURI(), this.viewAssociations.getLocalName(), this.viewAssociations.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
        writer.startElement(ContentModel.ASSOC_MEMBER.getNamespaceURI(), ContentModel.ASSOC_MEMBER.getLocalName(), ContentModel.ASSOC_MEMBER.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
        AttributesImpl attrsRef = new AttributesImpl();
        attrsRef.addAttribute(this.viewIdRef.getNamespaceURI(), this.viewIdRef.getLocalName(), this.viewIdRef.toPrefixString(), null, toId);
        attrsRef.addAttribute(this.childQName.getNamespaceURI(), this.childQName.getLocalName(), this.childQName.toPrefixString(), null, QName.createQName("http://www.alfresco.org/model/user/1.0", sl.to).toPrefixString(this.namespaceService));
        writer.startElement(this.viewRef.getNamespaceURI(), this.viewRef.getLocalName(), this.viewRef.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)attrsRef);
        writer.endElement(this.viewRef.getNamespaceURI(), this.viewRef.getLocalName(), this.viewRef.toPrefixString(this.namespaceService));
        writer.endElement(ContentModel.ASSOC_MEMBER.getNamespaceURI(), ContentModel.ASSOC_MEMBER.getLocalName(), ContentModel.ASSOC_MEMBER.toPrefixString(this.namespaceService));
        writer.endElement(this.viewAssociations.getNamespaceURI(), this.viewAssociations.getLocalName(), this.viewAssociations.toPrefixString(this.namespaceService));
        writer.endElement(this.viewRef.getNamespaceURI(), this.viewRef.getLocalName(), this.viewRef.toPrefixString(this.namespaceService));
    }

    private void addRootGroup(HashMap<String, Group> lookup, Group group, XMLWriter writer) throws SAXException {
        NodeRef authNodeRef;
        QName nodeUUID = QName.createQName("sys:node-uuid", this.namespaceService);
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", this.childQName.getLocalName(), this.childQName.toPrefixString(), null, QName.createQName("http://www.alfresco.org/model/user/1.0", group.gid).toPrefixString(this.namespaceService));
        attrs.addAttribute(this.viewId.getNamespaceURI(), this.viewId.getLocalName(), this.viewId.toPrefixString(), null, group.guid);
        writer.startElement(ContentModel.TYPE_AUTHORITY_CONTAINER.getNamespaceURI(), ContentModel.TYPE_AUTHORITY_CONTAINER.getLocalName(), ContentModel.TYPE_AUTHORITY_CONTAINER.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)attrs);
        if (this.authorityDAO != null && this.authorityDAO.authorityExists(group.gid) && (authNodeRef = this.authorityDAO.getAuthorityNodeRefOrNull(group.gid)) != null) {
            String uguid = this.authorityDAO.getAuthorityNodeRefOrNull(group.gid).getId();
            writer.startElement(nodeUUID.getNamespaceURI(), nodeUUID.getLocalName(), nodeUUID.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
            writer.characters(uguid.toCharArray(), 0, uguid.length());
            writer.endElement(nodeUUID.getNamespaceURI(), nodeUUID.getLocalName(), nodeUUID.toPrefixString(this.namespaceService));
        }
        writer.startElement(ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI(), ContentModel.PROP_AUTHORITY_NAME.getLocalName(), ContentModel.PROP_AUTHORITY_NAME.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
        writer.characters(group.gid.toCharArray(), 0, group.gid.length());
        writer.endElement(ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI(), ContentModel.PROP_AUTHORITY_NAME.getLocalName(), ContentModel.PROP_AUTHORITY_NAME.toPrefixString(this.namespaceService));
        if (group.members.size() > 0) {
            writer.startElement(ContentModel.PROP_MEMBERS.getNamespaceURI(), ContentModel.PROP_MEMBERS.getLocalName(), ContentModel.PROP_MEMBERS.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
            for (String member : group.members) {
                writer.startElement(this.viewValueQName.getNamespaceURI(), this.viewValueQName.getLocalName(), this.viewValueQName.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                writer.characters(member.toCharArray(), 0, member.length());
                writer.endElement(this.viewValueQName.getNamespaceURI(), this.viewValueQName.getLocalName(), this.viewValueQName.toPrefixString(this.namespaceService));
            }
            writer.endElement(ContentModel.PROP_MEMBERS.getNamespaceURI(), ContentModel.PROP_MEMBERS.getLocalName(), ContentModel.PROP_MEMBERS.toPrefixString(this.namespaceService));
        }
        for (Group child : group.children) {
            this.addgroup(lookup, child, writer);
        }
        writer.endElement(ContentModel.TYPE_AUTHORITY_CONTAINER.getNamespaceURI(), ContentModel.TYPE_AUTHORITY_CONTAINER.getLocalName(), ContentModel.TYPE_AUTHORITY_CONTAINER.toPrefixString(this.namespaceService));
    }

    private void addgroup(HashMap<String, Group> lookup, Group group, XMLWriter writer) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        writer.startElement(ContentModel.ASSOC_MEMBER.getNamespaceURI(), ContentModel.ASSOC_MEMBER.getLocalName(), ContentModel.ASSOC_MEMBER.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)attrs);
        this.addRootGroup(lookup, group, writer);
        writer.endElement(ContentModel.ASSOC_MEMBER.getNamespaceURI(), ContentModel.ASSOC_MEMBER.getLocalName(), ContentModel.ASSOC_MEMBER.toPrefixString(this.namespaceService));
    }

    private void buildGroupsAndRoots(HashSet<Group> rootGroups, HashMap<String, Group> lookup, HashSet<SecondaryLink> secondaryLinks) {
        InitialDirContext ctx = null;
        try {
            ctx = this.ldapInitialContextFactory.getDefaultIntialDirContext();
            SearchControls userSearchCtls = new SearchControls();
            userSearchCtls.setSearchScope(2);
            NamingEnumeration<SearchResult> searchResults = ctx.search(this.searchBase, this.groupQuery, userSearchCtls);
            while (searchResults.hasMoreElements()) {
                Attribute memAttribute;
                SearchResult result = searchResults.next();
                Attributes attributes = result.getAttributes();
                Attribute gidAttribute = attributes.get(this.groupIdAttributeName);
                if (gidAttribute == null) {
                    throw new ExportSourceImporterException("Group returned by group search does not have mandatory group id attribute " + attributes);
                }
                String gid = (String)gidAttribute.get(0);
                Group group = lookup.get(gid);
                if (group == null) {
                    group = new Group(gid);
                    lookup.put(group.gid, group);
                    rootGroups.add(group);
                }
                if ((memAttribute = attributes.get(this.memberAttribute)) == null) continue;
                for (int i = 0; i < memAttribute.size(); ++i) {
                    String attribute = (String)memAttribute.get(i);
                    if (attribute == null) continue;
                    group.distinguishedNames.add(attribute);
                }
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Found " + lookup.size()));
            }
            for (Group group : lookup.values()) {
                if (s_logger.isDebugEnabled()) {
                    s_logger.debug((Object)("Linking " + group.gid));
                }
                for (String dn : group.distinguishedNames) {
                    NamingEnumeration<SearchResult> memberSearchResults;
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("... " + dn));
                    }
                    Boolean isGroup = null;
                    SearchControls memberSearchCtls = new SearchControls();
                    memberSearchCtls.setSearchScope(0);
                    try {
                        memberSearchResults = ctx.search(dn, "(objectClass=*)", memberSearchCtls);
                    }
                    catch (NamingException e) {
                        if (this.errorOnMissingMembers) {
                            throw e;
                        }
                        s_logger.warn((Object)("Failed to resolve distinguished name: " + dn));
                        continue;
                    }
                    while (memberSearchResults.hasMoreElements()) {
                        SearchResult result;
                        String id = null;
                        try {
                            result = memberSearchResults.next();
                        }
                        catch (NamingException e) {
                            if (this.errorOnMissingMembers) {
                                throw e;
                            }
                            s_logger.warn((Object)("Failed to resolve distinguished name: " + dn));
                            continue;
                        }
                        Attributes attributes = result.getAttributes();
                        Attribute objectclass = attributes.get("objectclass");
                        if (objectclass == null) {
                            throw new ExportSourceImporterException("Failed to find attribute objectclass for DN " + dn);
                        }
                        for (int i = 0; i < objectclass.size(); ++i) {
                            String testType;
                            try {
                                testType = (String)objectclass.get(i);
                            }
                            catch (NamingException e) {
                                if (this.errorOnMissingMembers) {
                                    throw e;
                                }
                                s_logger.warn((Object)("Failed to resolve object class attribute for distinguished name: " + dn));
                                continue;
                            }
                            if (testType.equals(this.groupType)) {
                                isGroup = true;
                                try {
                                    Attribute groupIdAttribute = attributes.get(this.groupIdAttributeName);
                                    if (groupIdAttribute == null) {
                                        throw new ExportSourceImporterException("Group missing group id attribute DN =" + dn + "  att = " + this.groupIdAttributeName);
                                    }
                                    id = (String)groupIdAttribute.get(0);
                                }
                                catch (NamingException e) {
                                    if (this.errorOnMissingMembers) {
                                        throw e;
                                    }
                                    s_logger.warn((Object)("Failed to resolve group identifier " + this.groupIdAttributeName + " for distinguished name: " + dn));
                                    id = "Unknown sub group";
                                }
                                break;
                            }
                            if (!testType.equals(this.personType)) continue;
                            isGroup = false;
                            try {
                                Attribute userIdAttribute = attributes.get(this.userIdAttributeName);
                                if (userIdAttribute == null) {
                                    throw new ExportSourceImporterException("User missing user id attribute DN =" + dn + "  att = " + this.userIdAttributeName);
                                }
                                id = (String)userIdAttribute.get(0);
                            }
                            catch (NamingException e) {
                                if (this.errorOnMissingMembers) {
                                    throw e;
                                }
                                s_logger.warn((Object)("Failed to resolve group identifier " + this.userIdAttributeName + " for distinguished name: " + dn));
                                id = "Unknown member";
                            }
                            break;
                        }
                        if (id == null) continue;
                        if (isGroup == null) {
                            throw new ExportSourceImporterException("Type not recognised for DN" + dn);
                        }
                        if (isGroup.booleanValue()) {
                            Group child;
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)"... is sub group");
                            }
                            if ((child = lookup.get("GROUP_" + id)) == null) {
                                throw new ExportSourceImporterException("Failed to find child group " + id);
                            }
                            if (rootGroups.contains(child)) {
                                if (s_logger.isDebugEnabled()) {
                                    s_logger.debug((Object)("...       Primary created from " + group.gid + " to " + child.gid));
                                }
                                group.children.add(child);
                                rootGroups.remove(child);
                                continue;
                            }
                            if (s_logger.isDebugEnabled()) {
                                s_logger.debug((Object)("...      Secondary created from " + group.gid + " to " + child.gid));
                            }
                            secondaryLinks.add(new SecondaryLink(group.gid, child.gid));
                            continue;
                        }
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)"... is member");
                        }
                        group.members.add(id);
                    }
                }
            }
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Top " + rootGroups.size()));
                s_logger.debug((Object)("Secondary " + secondaryLinks.size()));
            }
        }
        catch (NamingException e) {
            throw new ExportSourceImporterException("Failed to import people.", e);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    throw new ExportSourceImporterException("Failed to import people.", e);
                }
            }
        }
    }

    public static void main(String[] args) throws Exception {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        ExportSource source = (ExportSource)ctx.getBean("ldapGroupExportSource");
        TransactionService txs = (TransactionService)ctx.getBean("transactionComponent");
        UserTransaction tx = txs.getUserTransaction();
        tx.begin();
        File file = new File(args[0]);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        XMLWriter xmlWriter = LDAPGroupExportSource.createXMLExporter(writer);
        source.generateExport(xmlWriter);
        xmlWriter.close();
        tx.commit();
    }

    private static XMLWriter createXMLExporter(Writer writer) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        return xmlWriter;
    }

    public void afterPropertiesSet() throws Exception {
        this.viewRef = QName.createQName("view", "reference", this.namespaceService);
        this.viewId = QName.createQName("view", "id", this.namespaceService);
        this.viewIdRef = QName.createQName("view", "idref", this.namespaceService);
        this.viewAssociations = QName.createQName("view", "associations", this.namespaceService);
        this.childQName = QName.createQName("view", "childName", this.namespaceService);
        this.viewValueQName = QName.createQName("view", "value", this.namespaceService);
    }

    private static class SecondaryLink {
        String from;
        String to;

        private SecondaryLink(String from, String to) {
            this.from = from;
            this.to = to;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            SecondaryLink l = (SecondaryLink)o;
            return EqualsHelper.nullSafeEquals((Object)this.from, (Object)l.from) && EqualsHelper.nullSafeEquals((Object)this.to, (Object)l.to);
        }

        public int hashCode() {
            int hashCode = 0;
            if (this.from != null) {
                hashCode = hashCode * 37 + this.from.hashCode();
            }
            if (this.to != null) {
                hashCode = hashCode * 37 + this.to.hashCode();
            }
            return hashCode;
        }
    }

    private static class Group {
        String gid;
        String guid = GUID.generate();
        HashSet<Group> children = new HashSet();
        HashSet<String> members = new HashSet();
        HashSet<String> distinguishedNames = new HashSet();

        private Group(String gid) {
            this.gid = "GROUP_" + gid;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Group)) {
                return false;
            }
            Group g = (Group)o;
            return this.gid.equals(g.gid);
        }

        public int hashCode() {
            return this.gid.hashCode();
        }
    }
}

