/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.InitialDirContext;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPInitialDirContextFactoryImpl
implements LDAPInitialDirContextFactory {
    private Map<String, String> initialDirContextEnvironment = Collections.emptyMap();

    @Override
    public void setInitialDirContextEnvironment(Map<String, String> initialDirContextEnvironment) {
        this.initialDirContextEnvironment = initialDirContextEnvironment;
    }

    public Map<String, String> getInitialDirContextEnvironment() {
        return this.initialDirContextEnvironment;
    }

    @Override
    public InitialDirContext getDefaultIntialDirContext() throws AuthenticationException {
        Hashtable<String, String> env = new Hashtable<String, String>(this.initialDirContextEnvironment.size());
        env.putAll(this.initialDirContextEnvironment);
        env.put("javax.security.auth.useSubjectCredsOnly", "false");
        return this.buildInitialDirContext(env);
    }

    private InitialDirContext buildInitialDirContext(Hashtable<String, String> env) throws AuthenticationException {
        try {
            return new InitialDirContext(env);
        }
        catch (javax.naming.AuthenticationException ax) {
            throw new AuthenticationException("LDAP authentication failed.", ax);
        }
        catch (NamingException nx) {
            throw new AuthenticationException("Unable to connect to LDAP Server; check LDAP configuration", nx);
        }
    }

    @Override
    public InitialDirContext getInitialDirContext(String principal, String credentials) throws AuthenticationException {
        if (principal == null) {
            throw new AuthenticationException("Null user name provided.");
        }
        if (credentials == null) {
            throw new AuthenticationException("No credentials provided.");
        }
        Hashtable<String, String> env = new Hashtable<String, String>(this.initialDirContextEnvironment.size());
        env.putAll(this.initialDirContextEnvironment);
        env.put("java.naming.security.principal", principal);
        env.put("java.naming.security.credentials", credentials);
        return this.buildInitialDirContext(env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int userMembers = Integer.parseInt(args[3]);
        ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
        LDAPInitialDirContextFactory factory = (LDAPInitialDirContextFactory)applicationContext.getBean("ldapInitialDirContextFactory");
        InitialContext ctx = null;
        try {
            ctx = factory.getInitialDirContext("cn=" + args[0] + "," + args[2], args[1]);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("person");
            objClasses.add("organizationalPerson");
            objClasses.add("inetOrgPerson");
            for (int i = 0; i < userMembers; ++i) {
                BasicAttribute cn = new BasicAttribute("cn", "User" + i + " TestUser");
                BasicAttribute sn = new BasicAttribute("sn", "TestUser");
                BasicAttribute givenNames = new BasicAttribute("givenName", "User" + i);
                BasicAttribute telephoneNumber = new BasicAttribute("telephoneNumber", "123");
                BasicAttribute uid = new BasicAttribute("uid", "User" + i);
                BasicAttribute mail = new BasicAttribute("mail", "woof@woof");
                BasicAttribute o = new BasicAttribute("o", "Alfresco");
                BasicAttribute userPassword = new BasicAttribute("userPassword", "bobbins");
                String dn = "cn=User" + i + " TestUser," + args[2];
                BasicAttributes orig = new BasicAttributes();
                orig.put(objClasses);
                orig.put(cn);
                orig.put(sn);
                orig.put(givenNames);
                orig.put(telephoneNumber);
                orig.put(uid);
                orig.put(mail);
                orig.put(o);
                orig.put(userPassword);
                try {
                    ctx.destroySubcontext(dn);
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
                ((InitialDirContext)ctx).createSubcontext(dn, orig);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        System.setProperty("javax.security.auth.useSubjectCredentialsOnly", "false");
    }
}

