/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.transaction.UserTransaction;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.importer.ExportSource;
import org.alfresco.repo.importer.ExportSourceImporterException;
import org.alfresco.repo.security.authentication.ldap.LDAPInitialDirContextFactory;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.context.ApplicationContext;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPPersonExportSource
implements ExportSource {
    private static Log s_logger = LogFactory.getLog(LDAPPersonExportSource.class);
    private String personQuery = "(objectclass=inetOrgPerson)";
    private String searchBase;
    private String userIdAttributeName;
    private LDAPInitialDirContextFactory ldapInitialContextFactory;
    private PersonService personService;
    private Map<String, String> attributeMapping;
    private NamespaceService namespaceService;
    private String defaultHomeFolder;

    public void setPersonQuery(String personQuery) {
        this.personQuery = personQuery;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public void setUserIdAttributeName(String userIdAttributeName) {
        this.userIdAttributeName = userIdAttributeName;
    }

    public void setLDAPInitialDirContextFactory(LDAPInitialDirContextFactory ldapInitialDirContextFactory) {
        this.ldapInitialContextFactory = ldapInitialDirContextFactory;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setDefaultHomeFolder(String defaultHomeFolder) {
        this.defaultHomeFolder = defaultHomeFolder;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setAttributeMapping(Map<String, String> attributeMapping) {
        this.attributeMapping = attributeMapping;
    }

    @Override
    public void generateExport(XMLWriter writer) {
        QName nodeUUID = QName.createQName("sys:node-uuid", this.namespaceService);
        Collection<String> prefixes = this.namespaceService.getPrefixes();
        QName childQName = QName.createQName("view", "childName", this.namespaceService);
        try {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.alfresco.org/view/repository/1.0", childQName.getLocalName(), childQName.toPrefixString(), null, ContentModel.TYPE_PERSON.toPrefixString(this.namespaceService));
            writer.startDocument();
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                String uri = this.namespaceService.getNamespaceURI(prefix);
                writer.startPrefixMapping(prefix, uri);
            }
            writer.startElement("view", "view", "view:view", (org.xml.sax.Attributes)new AttributesImpl());
            InitialDirContext ctx = null;
            try {
                ctx = this.ldapInitialContextFactory.getDefaultIntialDirContext();
                SearchControls userSearchCtls = new SearchControls();
                userSearchCtls.setSearchScope(2);
                userSearchCtls.setCountLimit(Integer.MAX_VALUE);
                NamingEnumeration<SearchResult> searchResults = ctx.search(this.searchBase, this.personQuery, userSearchCtls);
                while (searchResults.hasMoreElements()) {
                    SearchResult result = searchResults.next();
                    Attributes attributes = result.getAttributes();
                    Attribute uidAttribute = attributes.get(this.userIdAttributeName);
                    if (uidAttribute == null) {
                        throw new ExportSourceImporterException("User returned by user search does not have mandatory user id attribute " + attributes);
                    }
                    String uid = (String)uidAttribute.get(0);
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Adding user for " + uid));
                    }
                    writer.startElement(ContentModel.TYPE_PERSON.getNamespaceURI(), ContentModel.TYPE_PERSON.getLocalName(), ContentModel.TYPE_PERSON.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)attrs);
                    writer.startElement(ContentModel.ASPECT_OWNABLE.getNamespaceURI(), ContentModel.ASPECT_OWNABLE.getLocalName(), ContentModel.ASPECT_OWNABLE.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                    writer.endElement(ContentModel.ASPECT_OWNABLE.getNamespaceURI(), ContentModel.ASPECT_OWNABLE.getLocalName(), ContentModel.ASPECT_OWNABLE.toPrefixString(this.namespaceService));
                    writer.startElement(ContentModel.PROP_OWNER.getNamespaceURI(), ContentModel.PROP_OWNER.getLocalName(), ContentModel.PROP_OWNER.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                    writer.characters(uid.toCharArray(), 0, uid.length());
                    writer.endElement(ContentModel.PROP_OWNER.getNamespaceURI(), ContentModel.PROP_OWNER.getLocalName(), ContentModel.PROP_OWNER.toPrefixString(this.namespaceService));
                    for (String key : this.attributeMapping.keySet()) {
                        String value;
                        Attribute attribute;
                        QName keyQName = QName.createQName(key, this.namespaceService);
                        writer.startElement(keyQName.getNamespaceURI(), keyQName.getLocalName(), keyQName.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                        String attributeName = this.attributeMapping.get(key);
                        if (attributeName != null && (attribute = attributes.get(attributeName)) != null && (value = (String)attribute.get(0)) != null) {
                            writer.characters(value.toCharArray(), 0, value.length());
                        }
                        writer.endElement(keyQName.getNamespaceURI(), keyQName.getLocalName(), keyQName.toPrefixString(this.namespaceService));
                    }
                    if (!(this.attributeMapping.keySet().contains(ContentModel.PROP_HOMEFOLDER.toString()) || this.attributeMapping.keySet().contains(ContentModel.PROP_HOMEFOLDER.toPrefixString(this.namespaceService)) || this.personService.personExists(uid))) {
                        writer.startElement(ContentModel.PROP_HOMEFOLDER.getNamespaceURI(), ContentModel.PROP_HOMEFOLDER.getLocalName(), ContentModel.PROP_HOMEFOLDER.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                        if (this.defaultHomeFolder != null) {
                            writer.characters(this.defaultHomeFolder.toCharArray(), 0, this.defaultHomeFolder.length());
                        }
                        writer.endElement(ContentModel.PROP_HOMEFOLDER.getNamespaceURI(), ContentModel.PROP_HOMEFOLDER.getLocalName(), ContentModel.PROP_HOMEFOLDER.toPrefixString(this.namespaceService));
                    }
                    if (this.personService.personExists(uid)) {
                        String uguid = this.personService.getPerson(uid).getId();
                        writer.startElement(nodeUUID.getNamespaceURI(), nodeUUID.getLocalName(), nodeUUID.toPrefixString(this.namespaceService), (org.xml.sax.Attributes)new AttributesImpl());
                        writer.characters(uguid.toCharArray(), 0, uguid.length());
                        writer.endElement(nodeUUID.getNamespaceURI(), nodeUUID.getLocalName(), nodeUUID.toPrefixString(this.namespaceService));
                    }
                    writer.endElement(ContentModel.TYPE_PERSON.getNamespaceURI(), ContentModel.TYPE_PERSON.getLocalName(), ContentModel.TYPE_PERSON.toPrefixString(this.namespaceService));
                }
            }
            catch (NamingException e) {
                throw new ExportSourceImporterException("Failed to import people.", e);
            }
            finally {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException e) {
                        throw new ExportSourceImporterException("Failed to import people.", e);
                    }
                }
            }
            for (String prefix : prefixes) {
                if (prefix.equals("xml")) continue;
                writer.endPrefixMapping(prefix);
            }
            writer.endElement("view", "view", "view:view");
            writer.endDocument();
        }
        catch (SAXException e) {
            throw new ExportSourceImporterException("Failed to create file for import.", e);
        }
    }

    public static void main(String[] args) throws Exception {
        ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
        ExportSource source = (ExportSource)ctx.getBean("ldapPeopleExportSource");
        TransactionService txs = (TransactionService)ctx.getBean("transactionComponent");
        UserTransaction tx = txs.getUserTransaction();
        tx.begin();
        File file = new File(args[0]);
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        XMLWriter xmlWriter = LDAPPersonExportSource.createXMLExporter(writer);
        source.generateExport(xmlWriter);
        xmlWriter.close();
        tx.commit();
    }

    private static XMLWriter createXMLExporter(Writer writer) {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setIndentSize(3);
        format.setEncoding("UTF-8");
        XMLWriter xmlWriter = new XMLWriter(writer, format);
        return xmlWriter;
    }
}

