/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ntlm;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;
import net.sf.acegisecurity.Authentication;
import net.sf.acegisecurity.AuthenticationServiceException;
import net.sf.acegisecurity.BadCredentialsException;
import net.sf.acegisecurity.CredentialsExpiredException;
import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.GrantedAuthorityImpl;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.server.auth.PasswordEncryptor;
import org.alfresco.filesys.server.auth.passthru.AuthenticateSession;
import org.alfresco.filesys.server.auth.passthru.PassthruServers;
import org.alfresco.filesys.smb.SMBException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NTLMChallenge;
import org.alfresco.repo.security.authentication.ntlm.NTLMLocalToken;
import org.alfresco.repo.security.authentication.ntlm.NTLMPassthruToken;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NTLMAuthenticationComponentImpl
extends AbstractAuthenticationComponent {
    private static final Log logger = LogFactory.getLog((String)"org.alfresco.passthru.auth");
    public static final String NTLMAuthorityGuest = "Guest";
    public static final String NTLMAuthorityAdministrator = "Administrator";
    private static final long DefaultSessionTimeout = 60000L;
    private static final long MinimumSessionTimeout = 5000L;
    private PassthruServers m_passthruServers = new PassthruServers();
    private PasswordEncryptor m_encryptor = new PasswordEncryptor();
    private boolean m_allowGuest;
    private Hashtable<NTLMPassthruToken, AuthenticateSession> m_passthruSessions = new Hashtable();
    private long m_passthruSessTmo = 60000L;
    private PassthruReaperThread m_reaperThread = new PassthruReaperThread();
    private PersonService m_personService;
    private NodeService m_nodeService;

    public final boolean allowsGuest() {
        return this.m_allowGuest;
    }

    public void setDomain(String domain) {
        if (this.m_passthruServers.getTotalServerCount() > 0) {
            throw new AlfrescoRuntimeException("Passthru server list already configured");
        }
        this.m_passthruServers.setDomain(domain);
    }

    public void setServers(String servers) {
        if (this.m_passthruServers.getTotalServerCount() > 0) {
            throw new AlfrescoRuntimeException("Passthru server list already configured");
        }
        this.m_passthruServers.setServerList(servers);
    }

    public void setUseLocalServer(String useLocal) {
        if (Boolean.parseBoolean(useLocal)) {
            if (this.m_passthruServers.getTotalServerCount() > 0) {
                throw new AlfrescoRuntimeException("Passthru server list already configured");
            }
            try {
                StringBuilder addrStr;
                InetAddress[] localAddrs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                if (localAddrs != null && localAddrs.length > 0) {
                    addrStr = new StringBuilder();
                    for (InetAddress curAddr : localAddrs) {
                        if (curAddr.isLoopbackAddress()) continue;
                        addrStr.append(curAddr.getHostAddress());
                        addrStr.append(",");
                    }
                    if (addrStr.length() > 0) {
                        addrStr.setLength(addrStr.length() - 1);
                    }
                } else {
                    throw new AlfrescoRuntimeException("No local server address(es)");
                }
                this.m_passthruServers.setServerList(addrStr.toString());
            }
            catch (UnknownHostException ex) {
                throw new AlfrescoRuntimeException("Failed to get local address list");
            }
        }
    }

    public void setGuestAccess(String guest) {
        this.m_allowGuest = Boolean.parseBoolean(guest);
    }

    public void setJCEProvider(String providerClass) {
        block5: {
            try {
                Object jceObj = Class.forName(providerClass).newInstance();
                if (jceObj instanceof Provider) {
                    Provider jceProvider = (Provider)jceObj;
                    Security.addProvider(jceProvider);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using JCE provider " + providerClass));
                    }
                    break block5;
                }
                throw new AlfrescoRuntimeException("JCE provider class is not a valid Provider class");
            }
            catch (ClassNotFoundException ex) {
                throw new AlfrescoRuntimeException("JCE provider class " + providerClass + " not found");
            }
            catch (Exception ex) {
                throw new AlfrescoRuntimeException("JCE provider class error", (Throwable)ex);
            }
        }
    }

    public void setSessionTimeout(String sessTmo) {
        try {
            long sessTmoMilli = Long.parseLong(sessTmo) * 1000L;
            if (sessTmoMilli < 5000L) {
                throw new AlfrescoRuntimeException("Authentication session timeout too low, " + sessTmo);
            }
            this.m_passthruSessTmo = sessTmoMilli;
            this.m_reaperThread.setWakeup(sessTmoMilli / 2L);
        }
        catch (NumberFormatException ex) {
            throw new AlfrescoRuntimeException("Invalid authenication session timeout value");
        }
    }

    public final void setPersonService(PersonService personService) {
        this.m_personService = personService;
    }

    public final void setNodeService(NodeService nodeService) {
        this.m_nodeService = nodeService;
    }

    private final long getSessionTimeout() {
        return this.m_passthruSessTmo;
    }

    public void authenticate(String userName, char[] password) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticate user=" + userName + " via local credentials"));
        }
        NTLMLocalToken authToken = new NTLMLocalToken(userName, new String(password));
        this.authenticate((Authentication)authToken);
        this.setCurrentUser(userName.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication auth) throws AuthenticationException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Authenticate " + auth + " via token"));
        }
        if (auth instanceof NTLMPassthruToken) {
            NTLMPassthruToken ntlmToken = (NTLMPassthruToken)auth;
            this.authenticatePassthru(ntlmToken);
        } else {
            if (auth instanceof NTLMLocalToken) {
                AuthenticateSession authSess = null;
                try {
                    NTLMLocalToken ntlmToken = (NTLMLocalToken)auth;
                    authSess = this.m_passthruServers.openSession();
                    this.authenticateLocal(ntlmToken, authSess);
                }
                finally {
                    if (authSess != null) {
                        try {
                            authSess.CloseSession();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            throw new AuthenticationException("Unsupported authentication token type");
        }
        return this.getCurrentAuthentication();
    }

    public NTLMMode getNTLMMode() {
        return NTLMMode.PASS_THROUGH;
    }

    public String getMD4HashedPassword(String userName) {
        throw new AlfrescoRuntimeException("MD4 passwords not supported");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void authenticateLocal(NTLMLocalToken ntlmToken, AuthenticateSession authSess) {
        try {
            GrantedAuthority[] authorities;
            String username = (String)ntlmToken.getPrincipal();
            String plainPwd = (String)ntlmToken.getCredentials();
            byte[] ntlm1Pwd = this.m_encryptor.generateEncryptedPassword(plainPwd, authSess.getEncryptionKey(), 1, null, null);
            authSess.doSessionSetup(username, null, ntlm1Pwd);
            if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                if (!this.allowsGuest()) throw new AuthenticationException("Guest logons disabled");
                authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest), new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
                ntlmToken.setAuthorities(authorities);
            } else {
                authorities = new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_AUTHENTICATED")};
                ntlmToken.setAuthorities(authorities);
            }
            ntlmToken.setAuthenticated(true);
            NodeRef userNode = this.m_personService.getPerson(username);
            if (userNode != null) {
                String personName = (String)((Object)this.m_nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                this.setCurrentUser(personName);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting current user using person " + personName + " (username " + username + ")"));
                }
            } else {
                if (!this.m_personService.getUserNamesAreCaseSensitive()) {
                    username = username.toLowerCase();
                }
                this.setCurrentUser(username);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Setting current user using username " + username));
                }
            }
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)("Authenticated token=" + (Object)((Object)ntlmToken)));
            return;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationServiceException("JCE provider error", (Throwable)ex);
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationServiceException("Invalid key error", (Throwable)ex);
        }
        catch (IOException ex) {
            throw new AuthenticationServiceException("I/O error", (Throwable)ex);
        }
        catch (SMBException ex) {
            if (ex.getErrorClass() != 6) throw new AuthenticationException("Logon failure");
            AuthenticationException authEx = null;
            switch (ex.getErrorCode()) {
                case -1073741715: {
                    authEx = new AuthenticationException("Logon failure");
                    throw authEx;
                }
                case -1073741710: {
                    authEx = new AuthenticationException("Account disabled");
                    throw authEx;
                }
                default: {
                    authEx = new AuthenticationException("Logon failure");
                }
            }
            throw authEx;
        }
    }

    private void authenticatePassthru(NTLMPassthruToken ntlmToken) {
        AuthenticateSession authSess = this.m_passthruSessions.get((Object)ntlmToken);
        if (authSess == null) {
            if (ntlmToken.getChallenge() != null) {
                throw new CredentialsExpiredException("Authentication session expired");
            }
            authSess = this.m_passthruServers.openSession();
            ntlmToken.setAuthenticationExpireTime(System.currentTimeMillis() + this.getSessionTimeout());
            ntlmToken.setChallenge(new NTLMChallenge(authSess.getEncryptionKey()));
            StringBuilder details = new StringBuilder();
            details.append(authSess.getDomain());
            details.append("\\");
            details.append(authSess.getPCShare().getNodeName());
            details.append(",");
            details.append(authSess.getSession().getProtocolName());
            ntlmToken.setDetails(details.toString());
            this.m_passthruSessions.put(ntlmToken, authSess);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Passthru stage 1 token " + (Object)((Object)ntlmToken)));
            }
        } else {
            try {
                byte[] lmPwd = null;
                byte[] ntlmPwd = null;
                if (ntlmToken.getPasswordType() == 0) {
                    lmPwd = ntlmToken.getHashedPassword();
                } else if (ntlmToken.getPasswordType() == 1) {
                    ntlmPwd = ntlmToken.getHashedPassword();
                }
                String username = (String)ntlmToken.getPrincipal();
                authSess.doSessionSetup(username, lmPwd, ntlmPwd);
                if (authSess.isGuest() || username.equalsIgnoreCase("GUEST")) {
                    if (this.allowsGuest()) {
                        GrantedAuthority[] authorities = new GrantedAuthority[]{new GrantedAuthorityImpl(NTLMAuthorityGuest)};
                        ntlmToken.setAuthorities(authorities);
                    } else {
                        throw new BadCredentialsException("Guest logons disabled");
                    }
                }
                ntlmToken.setAuthenticated(true);
                NodeRef userNode = this.m_personService.getPerson(username);
                if (userNode != null) {
                    String personName = (String)((Object)this.m_nodeService.getProperty(userNode, ContentModel.PROP_USERNAME));
                    this.setCurrentUser(personName);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting current user using person " + personName + " (username " + username + ")"));
                    }
                } else {
                    if (!this.m_personService.getUserNamesAreCaseSensitive()) {
                        username = username.toLowerCase();
                    }
                    this.setCurrentUser(username);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Setting current user using username " + username));
                    }
                }
            }
            catch (IOException ex) {
                throw new AuthenticationServiceException("I/O error", (Throwable)ex);
            }
            catch (SMBException ex) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Passthru exception, " + ex));
                }
                if (ex.getErrorClass() == 6) {
                    AuthenticationException authEx = null;
                    switch (ex.getErrorCode()) {
                        case -1073741715: {
                            authEx = new AuthenticationException("Logon failure");
                            break;
                        }
                        case -1073741710: {
                            authEx = new AuthenticationException("Account disabled");
                            break;
                        }
                        default: {
                            authEx = new AuthenticationException("Logon failure");
                        }
                    }
                    throw authEx;
                }
                throw new BadCredentialsException("Logon failure");
            }
            finally {
                if (authSess != null) {
                    try {
                        this.m_passthruSessions.remove((Object)ntlmToken);
                        authSess.CloseSession();
                    }
                    catch (Exception ex) {}
                }
            }
        }
    }

    public boolean exists(String userName) {
        throw new UnsupportedOperationException();
    }

    protected boolean implementationAllowsGuestLogin() {
        return this.allowsGuest();
    }

    class PassthruReaperThread
    extends Thread {
        private boolean m_ishutdown;
        private long m_wakeupInterval;

        PassthruReaperThread() {
            this.m_wakeupInterval = NTLMAuthenticationComponentImpl.this.m_passthruSessTmo / 2L;
            this.setDaemon(true);
            this.setName("PassthruReaper");
            this.start();
        }

        public final void setWakeup(long wakeup) {
            this.m_wakeupInterval = wakeup;
        }

        public void run() {
            this.m_ishutdown = false;
            while (!this.m_ishutdown) {
                try {
                    PassthruReaperThread.sleep(this.m_wakeupInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (NTLMAuthenticationComponentImpl.this.m_passthruSessions.size() <= 0) continue;
                Enumeration tokenEnum = NTLMAuthenticationComponentImpl.this.m_passthruSessions.keys();
                long timeNow = System.currentTimeMillis();
                while (tokenEnum.hasMoreElements()) {
                    NTLMPassthruToken ntlmToken;
                    block8: {
                        ntlmToken = (NTLMPassthruToken)((Object)tokenEnum.nextElement());
                        if (ntlmToken == null || ntlmToken.getAuthenticationExpireTime() >= timeNow) continue;
                        AuthenticateSession authSess = (AuthenticateSession)NTLMAuthenticationComponentImpl.this.m_passthruSessions.get((Object)ntlmToken);
                        if (authSess != null) {
                            try {
                                authSess.CloseSession();
                            }
                            catch (Exception ex) {
                                if (!logger.isDebugEnabled()) break block8;
                                logger.debug((Object)"Error closing expired authentication session", (Throwable)ex);
                            }
                        }
                    }
                    NTLMAuthenticationComponentImpl.this.m_passthruSessions.remove((Object)ntlmToken);
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("Removed expired NTLM token " + (Object)((Object)ntlmToken)));
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Passthru reaper thread shutdown");
            }
        }

        public final void shutdownRequest() {
            this.m_ishutdown = true;
            this.interrupt();
        }
    }
}

