/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ntlm;

import net.sf.acegisecurity.GrantedAuthority;
import net.sf.acegisecurity.providers.UsernamePasswordAuthenticationToken;

public class NTLMLocalToken
extends UsernamePasswordAuthenticationToken {
    private static final long serialVersionUID = -7946514578455279387L;

    protected NTLMLocalToken() {
        super(null, null);
    }

    public NTLMLocalToken(String username, String plainPwd) {
        super((Object)username.toLowerCase(), (Object)plainPwd);
    }

    public final boolean isGuestLogon() {
        return this.hasAuthority("Guest");
    }

    public final boolean isAdministrator() {
        return this.hasAuthority("Administrator");
    }

    public final boolean hasAuthority(String authority) {
        boolean found = false;
        GrantedAuthority[] authorities = this.getAuthorities();
        if (authorities != null && authorities.length > 0) {
            int i = 0;
            while (!found && i < authorities.length) {
                if (!authorities[i++].getAuthority().equals(authority)) continue;
                found = true;
            }
        }
        return found;
    }
}

