/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.search.impl.lucene.QueryParser;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.UnknownAuthorityException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.ISO9075;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityDAOImpl
implements AuthorityDAO {
    public static final StoreRef STOREREF_USERS = new StoreRef("user", "alfrescoUserStore");
    private NodeService nodeService;
    private NamespacePrefixResolver namespacePrefixResolver;
    private QName qnameAssocSystem;
    private QName qnameAssocAuthorities;
    private SearchService searchService;
    private DictionaryService dictionaryService;
    private SimpleCache<String, ArrayList<NodeRef>> userToAuthorityCache;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
        this.qnameAssocSystem = QName.createQName("sys", "system", namespacePrefixResolver);
        this.qnameAssocAuthorities = QName.createQName("sys", "authorities", namespacePrefixResolver);
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSearchService(SearchService searchService) {
        this.searchService = searchService;
    }

    public void setUserToAuthorityCache(SimpleCache<String, ArrayList<NodeRef>> userToAuthorityCache) {
        this.userToAuthorityCache = userToAuthorityCache;
    }

    @Override
    public boolean authorityExists(String name) {
        NodeRef ref = this.getAuthorityOrNull(name);
        return ref != null;
    }

    @Override
    public void addAuthority(String parentName, String childName) {
        NodeRef parentRef = this.getAuthorityOrNull(parentName);
        if (parentRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + parentName);
        }
        if (AuthorityType.getAuthorityType(childName).equals((Object)AuthorityType.USER)) {
            Collection<String> memberCollection = DefaultTypeConverter.INSTANCE.getCollection(String.class, this.nodeService.getProperty(parentRef, ContentModel.PROP_MEMBERS));
            HashSet<String> members = new HashSet<String>();
            members.addAll(memberCollection);
            members.add(childName);
            this.nodeService.setProperty(parentRef, ContentModel.PROP_MEMBERS, members);
            this.userToAuthorityCache.remove(childName);
        } else {
            NodeRef childRef = this.getAuthorityOrNull(childName);
            if (childRef == null) {
                throw new UnknownAuthorityException("An authority was not found for " + childName);
            }
            this.nodeService.addChild(parentRef, childRef, ContentModel.ASSOC_MEMBER, QName.createQName("usr", childName, this.namespacePrefixResolver));
        }
    }

    @Override
    public void createAuthority(String parentName, String name) {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
        props.put(ContentModel.PROP_AUTHORITY_NAME, (Serializable)((Object)name));
        if (parentName != null) {
            NodeRef parentRef = this.getAuthorityOrNull(parentName);
            if (parentRef == null) {
                throw new UnknownAuthorityException("An authority was not found for " + parentName);
            }
            this.nodeService.createNode(parentRef, ContentModel.ASSOC_MEMBER, QName.createQName("usr", name, this.namespacePrefixResolver), ContentModel.TYPE_AUTHORITY_CONTAINER, props);
        } else {
            NodeRef authorityContainerRef = this.getAuthorityContainer();
            this.nodeService.createNode(authorityContainerRef, ContentModel.ASSOC_CHILDREN, QName.createQName("usr", name, this.namespacePrefixResolver), ContentModel.TYPE_AUTHORITY_CONTAINER, props);
        }
    }

    @Override
    public void deleteAuthority(String name) {
        NodeRef nodeRef = this.getAuthorityOrNull(name);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + name);
        }
        this.nodeService.deleteNode(nodeRef);
    }

    @Override
    public Set<String> getAllRootAuthorities(AuthorityType type) {
        HashSet<String> authorities = new HashSet<String>();
        NodeRef container = this.getAuthorityContainer();
        if (container != null) {
            this.findAuthorities(type, container, authorities, false, false, false);
        }
        return authorities;
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        HashSet<String> authorities = new HashSet<String>();
        NodeRef container = this.getAuthorityContainer();
        if (container != null) {
            this.findAuthorities(type, container, authorities, false, true, false);
        }
        return authorities;
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        if (AuthorityType.getAuthorityType(name).equals((Object)AuthorityType.USER)) {
            return Collections.emptySet();
        }
        NodeRef nodeRef = this.getAuthorityOrNull(name);
        if (nodeRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + name);
        }
        HashSet<String> authorities = new HashSet<String>();
        this.findAuthorities(type, nodeRef, authorities, false, !immediate, false);
        return authorities;
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        NodeRef parentRef = this.getAuthorityOrNull(parentName);
        if (parentRef == null) {
            throw new UnknownAuthorityException("An authority was not found for " + parentName);
        }
        if (AuthorityType.getAuthorityType(childName).equals((Object)AuthorityType.USER)) {
            Collection<String> memberCollection = DefaultTypeConverter.INSTANCE.getCollection(String.class, this.nodeService.getProperty(parentRef, ContentModel.PROP_MEMBERS));
            HashSet<String> members = new HashSet<String>();
            members.addAll(memberCollection);
            members.remove(childName);
            this.nodeService.setProperty(parentRef, ContentModel.PROP_MEMBERS, members);
            this.userToAuthorityCache.remove(childName);
        } else {
            NodeRef childRef = this.getAuthorityOrNull(childName);
            if (childRef == null) {
                throw new UnknownAuthorityException("An authority was not found for " + childName);
            }
            this.nodeService.removeChild(parentRef, childRef);
        }
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        HashSet<String> authorities = new HashSet<String>();
        this.findAuthorities(type, name, authorities, true, !immediate);
        return authorities;
    }

    private void findAuthorities(AuthorityType type, String name, Set<String> authorities, boolean parents, boolean recursive) {
        if (!AuthorityType.getAuthorityType(name).equals((Object)AuthorityType.GUEST)) {
            if (AuthorityType.getAuthorityType(name).equals((Object)AuthorityType.USER)) {
                for (NodeRef ref : this.getUserContainers(name)) {
                    this.findAuthorities(type, ref, authorities, parents, recursive, true);
                }
            } else {
                NodeRef ref = this.getAuthorityOrNull(name);
                if (ref == null) {
                    throw new UnknownAuthorityException("An authority was not found for " + name);
                }
                this.findAuthorities(type, ref, authorities, parents, recursive, false);
            }
        }
    }

    private ArrayList<NodeRef> getUserContainers(String name) {
        ArrayList<NodeRef> containers = this.userToAuthorityCache.get(name);
        if (containers == null) {
            containers = this.findUserContainers(name);
            this.userToAuthorityCache.put(name, containers);
        }
        return containers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<NodeRef> findUserContainers(String name) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(STOREREF_USERS);
        sp.setLanguage("lucene");
        sp.setQuery("+TYPE:\"" + ContentModel.TYPE_AUTHORITY_CONTAINER + "\"" + " +@" + QueryParser.escape("{" + ContentModel.PROP_MEMBERS.getNamespaceURI() + "}" + ISO9075.encode(ContentModel.PROP_MEMBERS.getLocalName())) + ":\"" + name + "\"");
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            ArrayList<NodeRef> answer = new ArrayList<NodeRef>(rs.length());
            for (ResultSetRow row : rs) {
                answer.add(row.getNodeRef());
            }
            ArrayList<NodeRef> arrayList = answer;
            return arrayList;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private void findAuthorities(AuthorityType type, NodeRef nodeRef, Set<String> authorities, boolean parents, boolean recursive, boolean includeNode) {
        Collection<String> members;
        List<ChildAssociationRef> cars;
        List<ChildAssociationRef> list = cars = parents ? this.nodeService.getParentAssocs(nodeRef) : this.nodeService.getChildAssocs(nodeRef);
        if (includeNode) {
            String authorityName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTHORITY_NAME));
            if (type == null) {
                authorities.add(authorityName);
            } else {
                AuthorityType authorityType = AuthorityType.getAuthorityType(authorityName);
                if (authorityType.equals((Object)type)) {
                    authorities.add(authorityName);
                }
            }
        }
        for (ChildAssociationRef car : cars) {
            NodeRef current = parents ? car.getParentRef() : car.getChildRef();
            QName currentType = this.nodeService.getType(current);
            if (!this.dictionaryService.isSubClass(currentType, ContentModel.TYPE_AUTHORITY)) continue;
            String authorityName = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(current, ContentModel.PROP_AUTHORITY_NAME));
            if (type == null) {
                authorities.add(authorityName);
                if (!recursive) continue;
                this.findAuthorities(type, current, authorities, parents, recursive, false);
                continue;
            }
            AuthorityType authorityType = AuthorityType.getAuthorityType(authorityName);
            if (authorityType.equals((Object)type)) {
                authorities.add(authorityName);
            }
            if (!recursive) continue;
            this.findAuthorities(type, current, authorities, parents, recursive, false);
        }
        if (!parents && (members = DefaultTypeConverter.INSTANCE.getCollection(String.class, this.nodeService.getProperty(nodeRef, ContentModel.PROP_MEMBERS))) != null) {
            for (String user : members) {
                if (user == null) continue;
                if (type == null) {
                    authorities.add(user);
                    continue;
                }
                AuthorityType authorityType = AuthorityType.getAuthorityType(user);
                if (!authorityType.equals((Object)type)) continue;
                authorities.add(user);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NodeRef getAuthorityOrNull(String name) {
        SearchParameters sp = new SearchParameters();
        sp.addStore(STOREREF_USERS);
        sp.setLanguage("lucene");
        sp.setQuery("+TYPE:\"" + ContentModel.TYPE_AUTHORITY_CONTAINER + "\"" + " +@" + QueryParser.escape("{" + ContentModel.PROP_AUTHORITY_NAME.getNamespaceURI() + "}" + ISO9075.encode(ContentModel.PROP_AUTHORITY_NAME.getLocalName())) + ":\"" + name + "\"");
        ResultSet rs = null;
        try {
            rs = this.searchService.query(sp);
            if (rs.length() == 0) {
                NodeRef nodeRef = null;
                return nodeRef;
            }
            for (ResultSetRow row : rs) {
                String test = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(row.getNodeRef(), ContentModel.PROP_AUTHORITY_NAME));
                if (!test.equals(name)) continue;
                NodeRef nodeRef = row.getNodeRef();
                return nodeRef;
            }
            NodeRef nodeRef = null;
            return nodeRef;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    private NodeRef getAuthorityContainer() {
        NodeRef rootNodeRef = this.nodeService.getRootNode(STOREREF_USERS);
        List<ChildAssociationRef> results = this.nodeService.getChildAssocs(rootNodeRef, RegexQNamePattern.MATCH_ALL, this.qnameAssocSystem);
        NodeRef sysNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority system path not found: " + this.qnameAssocSystem);
        }
        sysNodeRef = results.get(0).getChildRef();
        results = this.nodeService.getChildAssocs(sysNodeRef, RegexQNamePattern.MATCH_ALL, this.qnameAssocAuthorities);
        NodeRef authNodeRef = null;
        if (results.size() == 0) {
            throw new AlfrescoRuntimeException("Required authority path not found: " + this.qnameAssocAuthorities);
        }
        authNodeRef = results.get(0).getChildRef();
        return authNodeRef;
    }

    @Override
    public NodeRef getAuthorityNodeRefOrNull(String name) {
        return this.getAuthorityOrNull(name);
    }
}

