/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authority.AuthorityDAO;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthorityServiceImpl
implements AuthorityService {
    private PersonService personService;
    private NodeService nodeService;
    private AuthorityDAO authorityDAO;
    private PermissionServiceSPI permissionServiceSPI;
    private Set<String> adminSet = Collections.singleton("ROLE_ADMINISTRATOR");
    private Set<String> guestSet = Collections.singleton("guest");
    private Set<String> allSet = Collections.singleton("GROUP_EVERYONE");
    private Set<String> adminUsers;
    private AuthenticationComponent authenticationComponent;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityDAO(AuthorityDAO authorityDAO) {
        this.authorityDAO = authorityDAO;
    }

    public void setPermissionServiceSPI(PermissionServiceSPI permissionServiceSPI) {
        this.permissionServiceSPI = permissionServiceSPI;
    }

    @Override
    public boolean hasAdminAuthority() {
        String currentUserName = this.authenticationComponent.getCurrentUserName();
        return currentUserName != null && this.adminUsers.contains(currentUserName);
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    public void setAdminUsers(Set<String> adminUsers) {
        this.adminUsers = adminUsers;
    }

    @Override
    public Set<String> getAuthorities() {
        HashSet<String> authorities = new HashSet<String>();
        String currentUserName = this.authenticationComponent.getCurrentUserName();
        if (this.adminUsers.contains(currentUserName)) {
            authorities.addAll(this.adminSet);
        }
        if (AuthorityType.getAuthorityType(currentUserName) != AuthorityType.GUEST) {
            authorities.addAll(this.allSet);
        }
        authorities.addAll(this.getContainingAuthorities(null, currentUserName, false));
        return authorities;
    }

    @Override
    public Set<String> getAllAuthorities(AuthorityType type) {
        HashSet<String> authorities = new HashSet<String>();
        switch (type) {
            case ADMIN: {
                authorities.addAll(this.adminSet);
                break;
            }
            case EVERYONE: {
                authorities.addAll(this.allSet);
                break;
            }
            case GUEST: {
                authorities.addAll(this.guestSet);
                break;
            }
            case GROUP: {
                authorities.addAll(this.authorityDAO.getAllAuthorities(type));
                break;
            }
            case OWNER: {
                break;
            }
            case ROLE: {
                authorities.addAll(this.authorityDAO.getAllAuthorities(type));
                break;
            }
            case USER: {
                for (NodeRef personRef : this.personService.getAllPeople()) {
                    authorities.add(DefaultTypeConverter.INSTANCE.convert(String.class, (Object)this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME)));
                }
                break;
            }
        }
        return authorities;
    }

    @Override
    public void addAuthority(String parentName, String childName) {
        this.authorityDAO.addAuthority(parentName, childName);
    }

    private void checkTypeIsMutable(AuthorityType type) {
        if (type == AuthorityType.GROUP || type == AuthorityType.ROLE) {
            return;
        }
        throw new AuthorityException("Trying to modify a fixed authority");
    }

    @Override
    public String createAuthority(AuthorityType type, String parentName, String shortName) {
        this.checkTypeIsMutable(type);
        String name = this.getName(type, shortName);
        this.authorityDAO.createAuthority(parentName, name);
        return name;
    }

    @Override
    public void deleteAuthority(String name) {
        AuthorityType type = AuthorityType.getAuthorityType(name);
        this.checkTypeIsMutable(type);
        this.authorityDAO.deleteAuthority(name);
        this.permissionServiceSPI.deletePermissions(name);
    }

    @Override
    public Set<String> getAllRootAuthorities(AuthorityType type) {
        return this.authorityDAO.getAllRootAuthorities(type);
    }

    @Override
    public Set<String> getContainedAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainedAuthorities(type, name, immediate);
    }

    @Override
    public Set<String> getContainingAuthorities(AuthorityType type, String name, boolean immediate) {
        return this.authorityDAO.getContainingAuthorities(type, name, immediate);
    }

    @Override
    public String getName(AuthorityType type, String shortName) {
        if (type.isFixedString()) {
            return type.getFixedString();
        }
        if (type.isPrefixed()) {
            return type.getPrefixString() + shortName;
        }
        return shortName;
    }

    @Override
    public String getShortName(String name) {
        AuthorityType type = AuthorityType.getAuthorityType(name);
        if (type.isFixedString()) {
            return "";
        }
        if (type.isPrefixed()) {
            return name.substring(type.getPrefixString().length());
        }
        return name;
    }

    @Override
    public void removeAuthority(String parentName, String childName) {
        this.authorityDAO.removeAuthority(parentName, childName);
    }

    @Override
    public boolean authorityExists(String name) {
        return this.authorityDAO.authorityExists(name);
    }
}

