/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.authority.AuthorityException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class AuthorityServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private AuthenticationComponent authenticationComponentImpl;
    private AuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    private AuthorityService authorityService;
    private AuthorityService pubAuthorityService;
    private PersonService personService;
    private UserTransaction tx;

    public void setUp() throws Exception {
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponentImpl = (AuthenticationComponent)ctx.getBean("authenticationComponentImpl");
        this.authenticationService = (AuthenticationService)ctx.getBean("authenticationService");
        this.authorityService = (AuthorityService)ctx.getBean("authorityService");
        this.pubAuthorityService = (AuthorityService)ctx.getBean("AuthorityService");
        this.personService = (PersonService)ctx.getBean("personService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        this.authenticationComponentImpl.setSystemUserAsCurrentUser();
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.tx = transactionService.getUserTransaction();
        this.tx.begin();
        if (!this.authenticationDAO.userExists("andy")) {
            this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        }
        if (!this.authenticationDAO.userExists("admin")) {
            this.authenticationService.createAuthentication("admin", "admin".toCharArray());
        }
        if (!this.authenticationDAO.userExists("administrator")) {
            this.authenticationService.createAuthentication("administrator", "administrator".toCharArray());
        }
    }

    protected void tearDown() throws Exception {
        this.authenticationComponentImpl.clearCurrentSecurityContext();
        this.tx.rollback();
        super.tearDown();
    }

    public void testNonAdminUser() {
        this.authenticationComponent.setCurrentUser("andy");
        AuthorityServiceTest.assertFalse((boolean)this.authorityService.hasAdminAuthority());
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.hasAdminAuthority());
        AuthorityServiceTest.assertEquals((int)1, (int)this.authorityService.getAuthorities().size());
    }

    public void testAdminUser() {
        this.authenticationComponent.setCurrentUser("admin");
        AuthorityServiceTest.assertTrue((boolean)this.authorityService.hasAdminAuthority());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.hasAdminAuthority());
        AuthorityServiceTest.assertEquals((int)2, (int)this.authorityService.getAuthorities().size());
        this.authenticationComponent.setCurrentUser("administrator");
        AuthorityServiceTest.assertTrue((boolean)this.authorityService.hasAdminAuthority());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.hasAdminAuthority());
        AuthorityServiceTest.assertEquals((int)2, (int)this.authorityService.getAuthorities().size());
    }

    public void testAuthorities() {
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.ADMIN).contains("ROLE_ADMINISTRATOR"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.EVERYONE).contains("GROUP_EVERYONE"));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).contains("GROUP_EVERYONE"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getAllAuthorities(AuthorityType.GUEST).contains("guest"));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.OWNER).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)this.personService.getAllPeople().size(), (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
    }

    public void testCreateAdminAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.ADMIN, null, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an admin authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateEveryoneAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.EVERYONE, null, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an everyone authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateGuestAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.GUEST, null, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an guest authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateOwnerAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.OWNER, null, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an owner authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateUserAuth() {
        try {
            this.pubAuthorityService.createAuthority(AuthorityType.USER, null, "woof");
            AuthorityServiceTest.fail((String)"Should not be able to create an user authority");
        }
        catch (AuthorityException authorityException) {
            // empty catch block
        }
    }

    public void testCreateRootAuth() {
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "woof");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, null, "woof");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
    }

    public void testCreateAuth() {
        AuthorityServiceTest.assertFalse((boolean)this.pubAuthorityService.authorityExists(this.pubAuthorityService.getName(AuthorityType.GROUP, "one")));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "one");
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.authorityExists(auth1));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "two");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "three");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "four");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth2, "five");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth5);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth4);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth3);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth2);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        this.pubAuthorityService.deleteAuthority(auth1);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth1 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, null, "one");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth2 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, null, "two");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth3 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, auth1, "three");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth4 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, auth1, "four");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        auth5 = this.pubAuthorityService.createAuthority(AuthorityType.ROLE, auth2, "five");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth5);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth4);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth3);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth2);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
        this.pubAuthorityService.deleteAuthority(auth1);
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.ROLE).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.ROLE).size());
    }

    public void testCreateAuthTree() {
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "one");
        AuthorityServiceTest.assertEquals((String)"GROUP_one", (String)auth1);
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "two");
        AuthorityServiceTest.assertEquals((String)"GROUP_two", (String)auth2);
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "three");
        AuthorityServiceTest.assertEquals((String)"GROUP_three", (String)auth3);
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "four");
        AuthorityServiceTest.assertEquals((String)"GROUP_four", (String)auth4);
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth2, "five");
        AuthorityServiceTest.assertEquals((String)"GROUP_five", (String)auth5);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        this.pubAuthorityService.addAuthority(auth5, "andy");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).contains("andy"));
        this.pubAuthorityService.removeAuthority(auth5, "andy");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, auth5, false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getContainedAuthorities(null, auth5, false).size());
    }

    public void testCreateAuthNet() {
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "one");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "two");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "three");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "four");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth2, "five");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        this.pubAuthorityService.addAuthority(auth5, "andy");
        this.pubAuthorityService.addAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
        this.pubAuthorityService.removeAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
    }

    public void testCreateAuthNet2() {
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)0, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth1 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "one");
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)1, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth2 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, null, "two");
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth3 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "three");
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth4 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth1, "four");
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        String auth5 = this.pubAuthorityService.createAuthority(AuthorityType.GROUP, auth2, "five");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        this.pubAuthorityService.addAuthority(auth5, "andy");
        this.pubAuthorityService.addAuthority(auth1, "andy");
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)3, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
        this.pubAuthorityService.addAuthority(auth3, auth2);
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllRootAuthorities(AuthorityType.GROUP).size());
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getAllAuthorities(AuthorityType.USER).size());
        AuthorityServiceTest.assertEquals((int)4, (int)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth1));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainingAuthorities(null, "andy", false).contains(auth3));
        AuthorityServiceTest.assertEquals((int)2, (int)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth2, false).contains("andy"));
        AuthorityServiceTest.assertEquals((int)5, (int)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).size());
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth3));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth4));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth2));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains(auth5));
        AuthorityServiceTest.assertTrue((boolean)this.pubAuthorityService.getContainedAuthorities(null, auth1, false).contains("andy"));
    }
}

