/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.repository.NodeRef;
import org.springframework.beans.factory.InitializingBean;

public class LockOwnerDynamicAuthority
implements DynamicAuthority,
InitializingBean {
    private LockService lockService;

    public boolean hasAuthority(NodeRef nodeRef, String userName) {
        return this.lockService.getLockStatus(nodeRef) == LockStatus.LOCK_OWNER;
    }

    public String getAuthority() {
        return "ROLE_LOCK_OWNER";
    }

    public void afterPropertiesSet() throws Exception {
        if (this.lockService == null) {
            throw new IllegalStateException("A lock service must be set");
        }
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }
}

