/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.dynamic.LockOwnerDynamicAuthority;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class LockOwnerDynamicAuthorityTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private AuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationDao authenticationDAO;
    private LockService lockService;
    private NodeRef rootNodeRef;
    private UserTransaction userTransaction;
    private PermissionService permissionService;
    private LockOwnerDynamicAuthority dynamicAuthority;

    public LockOwnerDynamicAuthorityTest() {
    }

    public LockOwnerDynamicAuthorityTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.authenticationService = (AuthenticationService)ctx.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.lockService = (LockService)ctx.getBean("lockService");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("alfDaoImpl");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.userTransaction = transactionService.getUserTransaction();
        this.userTransaction.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "AddChildren", true);
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists("frog")) {
            this.authenticationService.deleteAuthentication("frog");
        }
        this.authenticationService.createAuthentication("frog", "frog".toCharArray());
        this.dynamicAuthority = new LockOwnerDynamicAuthority();
        this.dynamicAuthority.setLockService(this.lockService);
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.userTransaction.rollback();
        super.tearDown();
    }

    public void testSetup() {
        LockOwnerDynamicAuthorityTest.assertNotNull((Object)this.nodeService);
        LockOwnerDynamicAuthorityTest.assertNotNull((Object)this.authenticationService);
        LockOwnerDynamicAuthorityTest.assertNotNull((Object)this.lockService);
    }

    public void testUnSet() {
        this.permissionService.setPermission(this.rootNodeRef, "andy", "All", true);
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)LockStatus.NO_LOCK), (Object)((Object)this.lockService.getLockStatus(this.rootNodeRef)));
        this.authenticationService.clearCurrentSecurityContext();
    }

    public void testPermissionWithNoLockAspect() {
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        NodeRef testNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_PERSON, ContentModel.TYPE_CMOBJECT, null).getChildRef();
        LockOwnerDynamicAuthorityTest.assertNotNull((Object)testNode);
        this.permissionService.setPermission(this.rootNodeRef, "andy", "All", true);
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(this.rootNodeRef, "Lock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(this.rootNodeRef, "Unlock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(this.rootNodeRef, "CheckOut")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(this.rootNodeRef, "CheckIn")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(this.rootNodeRef, "CancelCheckOut")));
    }

    public void testPermissionWithLockAspect() {
        this.permissionService.setPermission(this.rootNodeRef, "andy", "All", true);
        this.permissionService.setPermission(this.rootNodeRef, "lemur", "CheckOut", true);
        this.permissionService.setPermission(this.rootNodeRef, "lemur", "Write", true);
        this.permissionService.setPermission(this.rootNodeRef, "lemur", "Read", true);
        this.permissionService.setPermission(this.rootNodeRef, "frog", "CheckOut", true);
        this.permissionService.setPermission(this.rootNodeRef, "frog", "Write", true);
        this.permissionService.setPermission(this.rootNodeRef, "frog", "Read", true);
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        NodeRef testNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_PERSON, ContentModel.TYPE_CMOBJECT, null).getChildRef();
        this.lockService.lock(testNode, LockType.READ_ONLY_LOCK);
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Lock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Unlock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckOut")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckIn")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CancelCheckOut")));
        this.authenticationService.authenticate("lemur", "lemur".toCharArray());
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Lock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "Unlock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckOut")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckIn")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "CancelCheckOut")));
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        this.lockService.unlock(testNode);
        this.authenticationService.authenticate("lemur", "lemur".toCharArray());
        this.lockService.lock(testNode, LockType.READ_ONLY_LOCK);
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Lock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Unlock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckOut")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckIn")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CancelCheckOut")));
        this.authenticationService.authenticate("frog", "frog".toCharArray());
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "Lock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "Unlock")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.ALLOWED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckOut")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "CheckIn")));
        LockOwnerDynamicAuthorityTest.assertEquals((Object)((Object)AccessStatus.DENIED), (Object)((Object)this.permissionService.hasPermission(testNode, "CancelCheckOut")));
    }
}

