/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.dynamic;

import org.alfresco.repo.security.permissions.DynamicAuthority;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.util.EqualsHelper;
import org.springframework.beans.factory.InitializingBean;

public class OwnerDynamicAuthority
implements DynamicAuthority,
InitializingBean {
    private OwnableService ownableService;

    public void setOwnableService(OwnableService ownableService) {
        this.ownableService = ownableService;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.ownableService == null) {
            throw new IllegalArgumentException("There must be an ownable service");
        }
    }

    public boolean hasAuthority(NodeRef nodeRef, String userName) {
        return EqualsHelper.nullSafeEquals((Object)this.ownableService.getOwner(nodeRef), (Object)userName);
    }

    public String getAuthority() {
        return "ROLE_OWNER";
    }
}

