/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.PermissionServiceSPI;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthenticationService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.springframework.orm.hibernate3.LocalSessionFactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractPermissionTest
extends BaseSpringTest {
    protected static final String ROLE_AUTHENTICATED = "ROLE_AUTHENTICATED";
    protected NodeService nodeService;
    protected DictionaryService dictionaryService;
    protected PermissionServiceSPI permissionService;
    protected AuthenticationService authenticationService;
    private MutableAuthenticationDao authenticationDAO;
    protected LocalSessionFactoryBean sessionFactory;
    protected NodeRef rootNodeRef;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected ServiceRegistry serviceRegistry;
    protected NodeRef systemNodeRef;
    protected AuthenticationComponent authenticationComponent;
    protected ModelDAO permissionModelDAO;
    protected PersonService personService;
    protected AuthorityService authorityService;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("nodeService");
        this.dictionaryService = (DictionaryService)this.applicationContext.getBean(ServiceRegistry.DICTIONARY_SERVICE.getLocalName());
        this.permissionService = (PermissionServiceSPI)this.applicationContext.getBean("permissionService");
        this.namespacePrefixResolver = (NamespacePrefixResolver)this.applicationContext.getBean(ServiceRegistry.NAMESPACE_SERVICE.getLocalName());
        this.authenticationService = (AuthenticationService)this.applicationContext.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.permissionModelDAO = (ModelDAO)this.applicationContext.getBean("permissionsModelDAO");
        this.personService = (PersonService)this.applicationContext.getBean("personService");
        this.authorityService = (AuthorityService)this.applicationContext.getBean("authorityService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)this.applicationContext.getBean("alfDaoImpl");
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        QName children = ContentModel.ASSOC_CHILDREN;
        QName system = QName.createQName("http://www.alfresco.org/model/system/1.0", "system");
        QName container = ContentModel.TYPE_CONTAINER;
        QName types = QName.createQName("http://www.alfresco.org/model/system/1.0", "people");
        this.systemNodeRef = this.nodeService.createNode(this.rootNodeRef, children, system, container).getChildRef();
        NodeRef typesNodeRef = this.nodeService.createNode(this.systemNodeRef, children, types, container).getChildRef();
        Map<QName, Serializable> props = this.createPersonProperties("andy");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        props = this.createPersonProperties("lemur");
        this.nodeService.createNode(typesNodeRef, children, ContentModel.TYPE_PERSON, container, props).getChildRef();
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        if (this.authenticationDAO.userExists("lemur")) {
            this.authenticationService.deleteAuthentication("lemur");
        }
        this.authenticationService.createAuthentication("lemur", "lemur".toCharArray());
        if (this.authenticationDAO.userExists("admin")) {
            this.authenticationService.deleteAuthentication("admin");
        }
        this.authenticationService.createAuthentication("admin", "admin".toCharArray());
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void onTearDownInTransaction() throws Exception {
        try {
            this.flushAndClear();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        super.onTearDownInTransaction();
    }

    protected void runAs(String userName) {
        this.authenticationService.authenticate(userName, userName.toCharArray());
        AbstractPermissionTest.assertNotNull((Object)this.authenticationService.getCurrentUserName());
    }

    private Map<QName, Serializable> createPersonProperties(String userName) {
        HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
        properties.put(ContentModel.PROP_USERNAME, (Serializable)((Object)userName));
        return properties;
    }

    protected PermissionReference getPermission(String permission) {
        return this.permissionModelDAO.getPermissionReference(null, permission);
    }
}

